package com.enterprisedb.dashboard.agent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import java.sql.DriverManager;

/**
 * Contains all the database configuration information and methods to connect to
 * source database.
 */

public class Source {
	static {
		// load the driver
		try {
			Class.forName("com.edb.Driver");
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		}
	}

	private String name = null;

	private String user = null;

	private String pass = null;

	private String url = null;

	private String database = null;

	private String host = null;

	private String port = null;

	private boolean readOnly = true;

	/**
	 * @return Returns the host.
	 */
	public String getHost() {
		return host;
	}

	/**
	 * @param host
	 *            The host to set.
	 */
	public void setHost(String host) {
		this.host = host;
	}

	/**
	 * @return Returns the port.
	 */
	public String getPort() {
		return port;
	}

	/**
	 * @param port
	 *            The port to set.
	 */
	public void setPort(String port) {
		this.port = port;
	}

	/**
	 * 
	 * a wrapper for connect that can see the database params.
	 * 
	 * 
	 * 
	 * @return - the Connection object.
	 * @throws SQLException
	 * 
	 */

	public synchronized Connection getConnection() throws SQLException {
		return connect(url, user, pass);
	}

	/**
	 * Returns version information of database
	 * 
	 * @param conn
	 * @return version as double value, -1 if invalid
	 */
	public double getVersion() throws SQLException {
		Connection conn = null;
		if ((conn = getConnection()) != null) {
			try {
				Statement get_version = conn.createStatement();
				ResultSet version = get_version
						.executeQuery("SELECT VERSION();");

				if (version.next()) {

					String versionstr = version.getString("Version()");

					if (versionstr.indexOf("8.0.") != -1) {

						System.out.println("EnterpriseDB/PostgreSQL 2005 8.0");

						return 8.0;

					} else if (versionstr.indexOf("8.1") != -1) {
						return 8.1;
					}

				} else {

					return -1;

				}

				get_version.close();
				version.close();
			} finally {
				if (conn != null) {
					try {
						conn.close();
					} catch (SQLException e) {
					}
				}
			}
		}

		return -1;

	}

	/**
	 * Connects to a database using the params below.
	 * 
	 * @param dbURL -
	 *            the url to connect to.
	 * @param dbLogin -
	 *            the user name for this databse.
	 * @param dbPass -
	 *            the pasword for this database.
	 * @return - the connection object.
	 * @throws SQLException
	 * 
	 */

	private Connection connect(String dbURL, String dbLogin,

	String dbPass) throws SQLException {

		Connection con = null;

		con = DriverManager.getConnection(dbURL, dbLogin, dbPass);
		return con;
 
	}

	/**
	 * Performs comparison on 'name' property of this class
	 */
	public boolean equals(Object obj) {
		if (obj != null && obj instanceof Source) {
			Source _source = (Source) obj;
			if (_source.name != null
					&& _source.name.equalsIgnoreCase(this.name)) {
				return true;
			}
			return false;
		} else {
			return false;
		}
	}

	public String getUser() {
		return user;
	}

	public void setUser(String login) {
		this.user = login;
	}

	/**
	 * Name is in format HOST:PORT/DATABASE
	 * @return String Display Name of database
	 */
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getPass() {
		return pass;
	}

	public void setPass(String pass) {
		this.pass = pass;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	/**
	 * Used by query_exec.jsp to determine whether to allow DML/DDL statements
	 * to execute or not
	 * 
	 * @return Returns the readOnly.
	 */
	public boolean isReadOnly() {
		return readOnly;
	}

	/**
	 * Used by query_exec.jsp to determine whether to allow DML/DDL statements
	 * to execute or not
	 * 
	 * @param readOnly
	 *            true: No DML/DDL, false: Every thing is allowed.
	 */
	public void setReadOnly(boolean readOnly) {
		this.readOnly = readOnly;
	}

	/**
	 * @return Returns the database.
	 */
	public String getDatabase() {
		return database;
	}

	/**
	 * @param database
	 *            The database to set.
	 */
	public void setDatabase(String database) {
		this.database = database;
	}

}
