/**
 * 
 */
package com.enterprisedb.dashboard.agent;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

/**
 * Custom JRDataSource class for the Stored Procedures reports
 * 
 * @author sarah
 * @version 1.0
 */
public class StoredProcJRDataSource implements JRDataSource {

	private static final Logger logger = Logger
			.getLogger(StoredProcJRDataSource.class.getName());
	// defaults to 0 - empty
	private int count = 0;

	// fields...
	private ArrayList procedureName = new ArrayList();
	private ArrayList procedureLanguage = new ArrayList();
	private ArrayList procedureReturnType = new ArrayList();
	private ArrayList procedureOwner = new ArrayList();
	private ArrayList procedureDefinition = new ArrayList();
	private ArrayList sourceName = new ArrayList();
	private ArrayList reportTime = new ArrayList();

	/**
	 * Default constructor - initialize fields
	 * 
	 * @param src
	 *            Source object from which to data obtain
	 */
	public StoredProcJRDataSource(Source src, String schema) {
		if (src != null && schema!=null) {
			Connection con = null;
			Statement stOuter = null;
			ResultSet rsOuter = null;
			String dbSchema = schema.toUpperCase().trim();
						
			try {
				con = src.getConnection();
				
				Statement stVersion = con.createStatement();
				stOuter = con.createStatement();
				
									
				String STOREDPROCS_QUERY = "";
				
				//Standard Query for getting stored procedures from an EnterpriseDB database
				STOREDPROCS_QUERY =   " SELECT pr.proname as proname, pr.prosig as prosig, pr.prosrc as prosrc," 
									+ " pg_get_userbyid(proowner) as procowner, description, TYP.typname, TYPNS.nspname AS typnsp, lanname"
									+ " FROM pg_catalog.pg_procedure pr" 
									+ " JOIN pg_type TYP ON TYP.oid=prorettype "
									+ " JOIN pg_namespace TYPNS ON TYPNS.oid=pr.pronamespace" 
									+ " JOIN pg_language LNG ON LNG.oid=prolang" 
									+ " LEFT OUTER JOIN pg_description des ON des.objoid=pr.oid" 
									+ " WHERE UPPER(typname) NOT IN('TRIGGER','LANGUAGE_HANDLER')"
									+ " AND UPPER(nspname) = '" + dbSchema + "'"
									+ " AND UPPER(lanname) = 'EDBSPL'";
					
					rsOuter = stOuter.executeQuery(STOREDPROCS_QUERY);
						
					while(rsOuter.next()) {
							sourceName.add(src.getName());
							reportTime.add(new Timestamp(new java.util.Date().getTime()));
							procedureName.add(rsOuter.getString("proname").trim());
							procedureLanguage.add(rsOuter.getString("lanname").trim());
							procedureReturnType.add(rsOuter.getString("typname").trim());
							procedureOwner.add(rsOuter.getString("procowner").trim());
							procedureDefinition.add(rsOuter.getString("prosig").trim() + "\n" + rsOuter.getString("prosrc").trim());						
							count++;
					
					}//while
					
					rsOuter.close();
					stOuter.close();
				}
			catch (SQLException sqe) {
				logger.log(Level.SEVERE, sqe.getMessage(), sqe);
				sqe.printStackTrace();
			} finally {
				if (con != null) {
					try {
						con.close();
					} catch (SQLException sqe) {
						logger.log(Level.SEVERE, sqe.getMessage(), sqe);
					}
				}
			}

		}
	}
	/**
	 * @return Returns the counter.
	 */
	public int getCount() {
		return count;
	}

	/**
	 * @param count
	 *            The counter to set.
	 */
	public void setCount(int count) {
		this.count = count;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.sf.jasperreports.engine.JRDataSource#next()
	 */
	public boolean next() throws JRException {
		if (count > 0) {
			count--;
			return true;
		}
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.sf.jasperreports.engine.JRDataSource#getFieldValue(net.sf.jasperreports.engine.JRField)
	 */
	public Object getFieldValue(JRField field) throws JRException {
		if (field.getName().equals("source")) {
			return this.sourceName.get(count);
		} else if (field.getName().equals("owner")) {
			return this.procedureOwner.get(count); 
		} else if (field.getName().equals("procedureName")) {
			return this.procedureName.get(count);
		} else if (field.getName().equals("procedureLanguage")) {
			return this.procedureLanguage.get(count);
		} else if (field.getName().equals("procedureDefinition")) {
			return this.procedureDefinition.get(count);
		} else if (field.getName().equals("report_time")) {
			return this.reportTime.get(count);
		}
		return null;
	}

}
