/**
 * 
 */
package com.enterprisedb.dashboard.agent;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.io.*;

import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

/**
 * Custom JRDataSource class for Table Information Report
 * 
 * @author Sarah
 * @version 1.0a 
 * @converting this report to JR Data Source due to table size
 * 
 */
public class TableInfoJRDataSource implements JRDataSource {

	private static final Logger logger = Logger
			.getLogger(TableInfoJRDataSource.class.getName());
	// defaults to 0 - empty
	private int count = 0;

	// fields...
	private ArrayList tableName = new ArrayList();
	private ArrayList columnName = new ArrayList();
	private ArrayList isNullable = new ArrayList();
	private ArrayList dataType = new ArrayList();
	private ArrayList rowCount = new ArrayList();
	private ArrayList maximumLength = new ArrayList();
	private ArrayList numericPrecision = new ArrayList();
	private ArrayList numericScale = new ArrayList();
	private ArrayList tableSize = new ArrayList();
	private ArrayList sourceName = new ArrayList();	
	private ArrayList reportTime = new ArrayList();
	/**
	 * Default constructor - initialize fields
	 * 
	 * @param src
	 *            Source object from which to data obtain
	 */
	public TableInfoJRDataSource(Source src, String schema) {
			if (src != null && schema!=null) {
			Connection con = null;
			String dbSchema = schema.toUpperCase().trim();
			String OUTER_QUERY = 	"SELECT a.table_name," 
								+ 	" a.column_name, initcap(a.is_nullable) AS is_nullable," 
								+ 	" a.data_type, c.reltuples::int8," 
								+	" case when a.character_maximum_length=0 then null::int8 else a.character_maximum_length end as character_maximum_length,"
								+ 	" case when a.numeric_precision=0 then null::int8 else a.numeric_precision end as numeric_precision," 
								+	" case when a.numeric_scale = 0 then null::int8 else a.numeric_scale end as numeric_scale" 
								+	" FROM information_schema.columns a, information_schema.tables b, pg_class c"
								+	" WHERE UPPER(a.table_schema) = '" + dbSchema + "'"
								+	" AND a.table_name = b.table_name AND c.relname = a.table_name AND c.relname=b.table_name"
								+       " AND c.relnamespace = (select oid from pg_namespace where nspname = '"+schema+"')"
								+	" AND a.table_schema = b.table_schema"
								+	" AND UPPER(a.table_schema) NOT IN('PG_CATALOG','INFORMATION_SCHEMA','SYS','DBO','PG_TOAST')"
								+	" AND UPPER(a.table_schema) NOT LIKE 'PG_TEMP%' AND b.table_type <> 'VIEW'" 
								+	" ORDER BY a.table_name DESC,a.column_name DESC";
					
				try {
				con = src.getConnection();
				// step 1: Outer query
				Statement stOuter = con.createStatement();
				ResultSet rsOuter = stOuter.executeQuery(OUTER_QUERY);
				
				while (rsOuter.next()) {
					
					sourceName.add(src.getName());
					reportTime.add(new Timestamp(new java.util.Date().getTime()));
					tableName.add(rsOuter.getString("table_name").trim());
					columnName.add(rsOuter.getString("column_name").trim());
					isNullable.add(rsOuter.getString("is_nullable").trim());
					dataType.add(rsOuter.getString("data_type").trim());
					rowCount.add(new Long(rsOuter.getLong("reltuples")));
					maximumLength.add(new Long(rsOuter.getLong("character_maximum_length")));
					numericPrecision.add(new Long(rsOuter.getLong("numeric_precision")));
					numericScale.add(new Long(rsOuter.getLong("numeric_scale")));
					// Step 2: Check if the table size is available
					for (int i = 0; i < columnName.size(); i++) {
						Statement stIsTableSizeAvailable = con.createStatement();
						ResultSet rsIsTableSizeAvailable = stIsTableSizeAvailable.executeQuery("SELECT * FROM pg_proc WHERE proname = 'pg_total_relation_size'");
						if(rsIsTableSizeAvailable.next()) {
							ResultSet rsTableSize = stIsTableSizeAvailable.executeQuery("SELECT pg_size_pretty(pg_total_relation_size('" + schema + "." + rsOuter.getString("table_name").trim() + "')) AS table_size");
							if(rsTableSize.next()) {
								tableSize.add(rsTableSize.getString("table_size"));
							}
						}
						else {
							tableSize.add("Not Available");
						}
						stIsTableSizeAvailable.close();
						rsIsTableSizeAvailable.close();
						if(rsIsTableSizeAvailable!=null) {
							rsIsTableSizeAvailable.close();
						}
					}
				count++;
				}
				rsOuter.close();
				stOuter.close();	
			} catch (SQLException sqe) {
				logger.log(Level.SEVERE, sqe.getMessage(), sqe);
			} finally {
				if (con != null) {
					try {
						con.close();
					} catch (SQLException sqe) {
						logger.log(Level.SEVERE, sqe.getMessage(), sqe);
					}
				}
			}

		}
	}
	/**
	 * @return Returns the counter.
	 */
	public int getCount() {
		return count;
	}

	/**
	 * @param count
	 *            The counter to set.
	 */
	public void setCount(int count) {
		this.count = count;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.sf.jasperreports.engine.JRDataSource#next()
	 */
	public boolean next() throws JRException {
		if (count > 0) {
			count--;
			return true;
		}
	return false;

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.sf.jasperreports.engine.JRDataSource#getFieldValue(net.sf.jasperreports.engine.JRField)
	 */
	public Object getFieldValue(JRField field) throws JRException {
		if (field.getName().equals("table_name")) {
			return this.tableName.get(count);
		} else if (field.getName().equals("column_name")) {
			return this.columnName.get(count);
		} else if (field.getName().equals("source")) {
			return this.sourceName.get(count);
		} else if (field.getName().equals("report_time")) {
			return this.reportTime.get(count);			
		} else if (field.getName().equals("is_nullable")) {
			return this.isNullable.get(count);
		} else if (field.getName().equals("data_type")) {
			return this.dataType.get(count);
		} else if (field.getName().equals("character_maximum_length")) {
			return this.maximumLength.get(count);
		} else if (field.getName().equals("numeric_precision")) {
			return this.numericPrecision.get(count);
		} else if (field.getName().equals("numeric_scale")) {
			return this.numericScale.get(count);
		} else if (field.getName().equals("row_count")) {
			return this.rowCount.get(count);
		} else if (field.getName().equals("table_size")) {
			return this.tableSize.get(count);
		}

		return null;
	}

}
