package com.enterprisedb.dashboard.querytest;

import java.sql.*;

/**
 * Determine Buffer Cache Information
 * 
 * @author Sarah
 * @version 0.9
 */

public class BufferCacheQueryCount extends QueryCount

{

	public int getCount()

	{

		Connection conn = getConnection();

		String query = jasperReport.getProperty(QUERY_PROPERTY);

		Statement statement = null;

		try {
			statement = conn.createStatement();
			
			ResultSet rs = statement.executeQuery(query);

			if (rs.next()) {
				return rs.getInt("record_count");

			}

		} catch (SQLException e) {

			e.printStackTrace();

		} finally {

			if (statement != null)

				try {

					statement.close();

				} catch (SQLException e) {

					e.printStackTrace();

				}

		}

		return -1;

	}

}
