package com.enterprisedb.dashboard.querytest;

import java.sql.*;

/**
 * Determines Column Privileges Query Count
 * 
 * @author Usman
 * @version 0.7c
 * 
 */

public class ColumnPrivilegesQueryCount extends QueryCount

{

	public int getCount() {

		Connection conn = getConnection();

		String query = jasperReport.getProperty(QUERY_PROPERTY);

		PreparedStatement pst = null;

		try {

			pst = conn.prepareStatement(query);

			pst.setString(1, (String) parameters.get("database"));

			pst.setString(2, (String) parameters.get("user"));

			ResultSet rs = pst.executeQuery();

			if (rs.next()) {

				return rs.getInt("record_count");

			}

		} catch (SQLException e) {

			e.printStackTrace();

		} finally {

			if (pst != null)

				try {

					pst.close();

				} catch (SQLException e) {

					e.printStackTrace();

				}

		}

		return -1;

	}

}
