package com.enterprisedb.dashboard.querytest;



import java.sql.*;



/**
 * Determines Indexes Query Count
 * @author Usman
 * @version 0.7c
 */

public class IndexesQueryCount extends QueryCount

{

    public int getCount()

    {

        Connection conn = getConnection();

        String query = jasperReport.getProperty(QUERY_PROPERTY);

        PreparedStatement pst = null;

        try {

            pst = conn.prepareStatement(query);

            //pass schema name to count query...
            pst.setString(1, (String) parameters.get("database"));

            ResultSet rs = pst.executeQuery();

            if (rs.next()) {

                return rs.getInt("record_count");

            }

        } catch (SQLException e) {

            e.printStackTrace();

        } finally {

            if (pst != null)

                try {

                    pst.close();

                } catch (SQLException e) {

                    e.printStackTrace();

                }

        }

        return -1;

    }

}

