/**
 * 
 */
package com.enterprisedb.dashboard.querytest;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * Determine Lock Activity Query Count
 * @author usman
 * @version 0.7c
 */
public class LockActivityQueryCount extends QueryCount {
	 public int getCount()

	    {

	        Connection conn = getConnection();

	        String query = jasperReport.getProperty(QUERY_PROPERTY);

	        PreparedStatement pst = null;

	        try {

	            pst = conn.prepareStatement(query);

	            pst.setString(1,(String)parameters.get("dbname"));
	            ResultSet rs = pst.executeQuery();
	            if (rs.next()) {

	                return rs.getInt("record_count");

	            }

	        } catch (SQLException e) {

	            e.printStackTrace();

	        } finally {

	            if (pst != null)

	                try {

	                    pst.close();

	                } catch (SQLException e) {

	                    e.printStackTrace();

	                }

	        }

	        return -1;

	    }
}
