package com.enterprisedb.dashboard.querytest;



import net.sf.jasperreports.engine.*;



import java.util.*;

import java.sql.*;



/**
 * Determine records count dynamically at runtime.
 * Each report has its own *Count class extends from this class.
 * @author Usman Saleem
 * @version 0.7c
 */



public abstract class QueryCount

{

    protected Map parameters;

    protected JasperReport jasperReport;

    private Connection connection;



	/**

	 * Property name in the report template containing the count query.

	 */

    public static String QUERY_PROPERTY = "count.query";



	/**

	 * Property name in the report template containing the count query handler class. Must be an instance of this class.

	 */

	public static String QUERYCLASS_PROPERTY = "count.queryClass";





	/**

	 * The maximum row count for which the report size is not considered too large.

	 */

	public static int QUERY_MAXCOUNT = 3000;





    public abstract int getCount();





    public Connection getConnection()

    {

         return connection;

    }





    public Map getParameters()

    {

        return parameters;

    }





    public void setParameters(Map parameters)

    {

        this.parameters = parameters;

    }





    public void setConnection(Connection connection)

    {

        this.connection = connection;

    }





    public JasperReport getJasperReport()

    {

        return jasperReport;

    }





    public void setJasperReport(JasperReport jasperReport)

    {

        this.jasperReport = jasperReport;

    }





}

