package com.enterprisedb.dashboard.querytest;

import java.sql.*;

/**
 * Determine Table IO Detail Query Count
 * 
 * @author Sarah
 * @version 1.0
 */

public class TableIODetailQueryCount extends QueryCount

{

	public int getCount()

	{

		Connection conn = getConnection();

		String query = jasperReport.getProperty(QUERY_PROPERTY);

		PreparedStatement pst = null;

		try {

			pst = conn.prepareStatement(query);

			pst.setString(1, (String) parameters.get("schema"));

			ResultSet rs = pst.executeQuery();

			if (rs.next()) {

				return rs.getInt("record_count");

			}

		} catch (SQLException e) {

			e.printStackTrace();

		} finally {

			if (pst != null)

				try {

					pst.close();

				} catch (SQLException e) {

					e.printStackTrace();

				}

		}

		return -1;

	}

}
