package com.enterprisedb.dashboard.querytest;



import java.sql.*;



/**
 * Determine Views Query Count
 * @author Usman
 * @version 0.7
 */

public class ViewsQueryCount extends QueryCount

{

    public int getCount()

    {

        Connection conn = getConnection();

        String query = jasperReport.getProperty(QUERY_PROPERTY);

        PreparedStatement pst = null;

        try {

            pst = conn.prepareStatement(query);
            pst.setString(1, (String) parameters.get("schema"));
            ResultSet rs = pst.executeQuery();

            if (rs.next()) {

                return rs.getInt("record_count");

            }

        } catch (SQLException e) {

            e.printStackTrace();

        } finally {

            if (pst != null)

                try {

                    pst.close();

                } catch (SQLException e) {

                    e.printStackTrace();

                }

        }

        return -1;

    }

}

