package com.enterprisedb.dashboard.web;



import java.io.ByteArrayOutputStream;

import java.util.HashMap;

import java.util.Locale;

import java.util.Map;



import javax.servlet.ServletContext;



import net.sf.jasperreports.engine.JRExporterParameter;

import net.sf.jasperreports.engine.JasperExportManager;

import net.sf.jasperreports.engine.JasperPrint;

import net.sf.jasperreports.engine.export.JRHtmlExporter;

import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;

import net.sf.jasperreports.engine.export.JRXlsExporter;

import net.sf.jasperreports.engine.export.JRXlsExporterParameter;





public class ReportBean 

{

	protected ServletContext servletContext;

    protected Locale locale;

    protected JasperPrint jasperPrint;

    protected Map imagesMap;

    protected int pageIndex;

    protected String report;

    protected String error;

    protected String source;

    protected String database;
    
    protected String schema;

    protected String fromTxt;

    protected String toTxt;

    protected boolean overflow;

    protected boolean ignoreOverflow;



    public ReportBean() {

        jasperPrint = null;

        imagesMap = null;

        pageIndex = 0;

    }





    public JasperPrint getJasperPrint()

    {

        return jasperPrint;

    }





    public void setJasperPrint(JasperPrint jasperPrint)

    {

        this.jasperPrint = jasperPrint;

    }





    public void setServletContext(ServletContext servletContext) {

        this.servletContext = servletContext;

	}



    public void setLocale(Locale locale) {

        this.locale = locale;

	}



    public String getReport()

    {

        return report;

    }



    public void setReport(String report) {

    	this.report = report;

	}



    public Map getImagesMap() {

        return imagesMap;

	}



    public void setPageIndex(int pageIndex)

    {

        this.pageIndex = pageIndex;

    }



    public int getPageIndex() {

        return pageIndex;

    }



    public int getLastPage() {

        if (jasperPrint != null && jasperPrint.getPages() != null) {

            return jasperPrint.getPages().size() - 1;

        }

        return -1;

	}



    public void setFirstPage() {

        pageIndex = 0;

    }



    public void setPreviousPage() {

        if (pageIndex > 0) {

            pageIndex--;

        }

    }



    public void setNextPage() {

        if (pageIndex < getLastPage()) {

            pageIndex++;

        }

    }



    public void setLastPage() {

        pageIndex = getLastPage();

    }





    public String getError() {

        return error;

    }



    public void setSource(String source)

    {

        this.source = source;

    }



    public String getDatabase()

    {

        return database;

    }



    public void setDatabase(String database) {

        this.database = database;

    }


    public String getSchema()

    {

        return schema;

    }





    public void setSchema(String schema)

    {

        this.schema = schema;

    }
    public void setFrom(String from) {

        this.fromTxt = from;

    }



    public void setTo(String to) {

        this.toTxt = to;

    }



    public boolean isOverflow()

    {

        return overflow;

    }



    public void setOverflow(boolean overflow)

    {

        this.overflow = overflow;

    }





    public boolean isIgnoreOverflow()

    {

        return ignoreOverflow;

    }





    public void setIgnoreOverflow(boolean ignoreOverflow)

    {

        this.ignoreOverflow = ignoreOverflow;

    }





    public byte[] getPdf() {

        try {

            return JasperExportManager.exportReportToPdf(jasperPrint);

        } catch (Exception e) {

            e.printStackTrace();

        }



        return null;

    }



    public byte[] getXls() {

		ByteArrayOutputStream baos = new ByteArrayOutputStream();



    	JRXlsExporter exporter = new JRXlsExporter();

    	exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);

    	exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, baos);

    	exporter.setParameter(JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, Boolean.FALSE);

    	exporter.setParameter(JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, Boolean.FALSE);



    	try {

        	exporter.exportReport();



    		return baos.toByteArray();

        } catch (Exception e) {

            e.printStackTrace();

        }



        return null;

    }



    public String getHtml() {

        if (jasperPrint == null) {

            return "";

        }



        StringBuffer sbuffer = new StringBuffer();



		imagesMap = new HashMap();



        JRHtmlExporter exporter = new JRHtmlExporter();



        exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);

        exporter.setParameter(JRExporterParameter.OUTPUT_STRING_BUFFER, sbuffer);

        exporter.setParameter(JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, Boolean.FALSE);

		exporter.setParameter(JRHtmlExporterParameter.IMAGES_MAP, imagesMap);

		double random = Math.random();

		exporter.setParameter(JRHtmlExporterParameter.IMAGES_URI, "image?random=" + random + "&image=");



        exporter.setParameter(JRHtmlExporterParameter.HTML_HEADER, "<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td>");

        exporter.setParameter(JRHtmlExporterParameter.BETWEEN_PAGES_HTML, "");

        exporter.setParameter(JRHtmlExporterParameter.HTML_FOOTER, "</td></tr></table>");

        exporter.setParameter(JRExporterParameter.PAGE_INDEX, new Integer(pageIndex));

        exporter.setParameter(JRHtmlExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, Boolean.FALSE);



        try {

            exporter.exportReport();

        } catch (Exception e) {

            e.printStackTrace();

        }



        return sbuffer.toString();

    }

}

