package com.enterprisedb.dashboard.web.action;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

import com.enterprisedb.dashboard.agent.DashboardAgent;
import com.enterprisedb.dashboard.agent.DashboardAgentException;
import com.enterprisedb.dashboard.web.ReportBean;
import com.enterprisedb.dashboard.web.form.BufferCacheForm;

/**
 * This action generates Buffer Cache report
 * 
 * @author Sarah 
 * 
 */

public class BufferCacheAction extends GenericAction

{

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)

	{

		BufferCacheForm bufferCacheForm = (BufferCacheForm) form;

		HttpSession session = request.getSession();

		ActionMessages errors = new ActionErrors();

		boolean hasBufferCacheSupport = false;
		
		try {
			
			DashboardAgent.loadConfig(new File(getServlet().getServletContext()
					.getRealPath("/WEB-INF/configure.xml")));

			request.setAttribute("sources", getSources());

			Vector sources = getSources();

			String selectedSource = bufferCacheForm.getSource();
			if (selectedSource == null && sources.size() > 0) {
				selectedSource = (String) sources.get(0);
			}
			
			Connection conn = DashboardAgent.getSourceConnection(selectedSource);
			hasBufferCacheSupport = this.supportsBufferCache(conn);
			
		} catch (Exception e) {
			e.printStackTrace();
			errors.add("generic", new ActionMessage("error.generic"));
		}

		if (errors.size() > 0) {
			saveErrors(request, errors);
			return mapping.findForward("genericerror");
		}

		if ((request.getParameter("refresh") != null || request.getParameter("ignoreOverflow") != null) && hasBufferCacheSupport) {

			try {
				DashboardAgent.checkSourceConnection(bufferCacheForm.getSource());

			} catch (DashboardAgentException e) {
				e.printStackTrace();
				errors.add("database", new ActionMessage(
						"error.sourcedatabase", bufferCacheForm.getSource()));
			}
			if (errors.size() > 0) {
				saveErrors(request, errors);
				return mapping.findForward("genericerror");
			}

			ReportBean reportBean = new ReportBean();

			errors = fillReport(bufferCacheForm, reportBean);

			session.setAttribute("reportBean", reportBean);

			if (errors.size() > 0) {

				saveErrors(request, errors);

				saveMessages(request, errors);

				return mapping.findForward("success");

			}

		}

		else if (!handlePaging(request, (ReportBean) session.getAttribute("reportBean"))) {
			session.setAttribute("reportBean", null);
		}

		String href = "pdf?id=" + String.valueOf(Math.random());

		request.setAttribute("pdfHref", href);

		return mapping.findForward("success");

	}

	public ActionErrors fillReport(BufferCacheForm form, ReportBean reportBean) {

		ActionErrors errors = new ActionErrors();

		boolean ignoreOverflow = form.getIgnoreOverflow() != null;

		Connection connection = null;

		reportBean.setPageIndex(0);

		try {
			connection = DashboardAgent.getSourceConnection(form.getSource());
			
			File reportFile = new File(getServlet().getServletContext()
					.getRealPath("/reports/BufferCache.jasper"));

			JasperReport jasperReport = (JasperReport) JRLoader
					.loadObject(reportFile.getPath());

			Map parameters = new HashMap();

			parameters.put(JRParameter.REPORT_LOCALE, null);

			parameters.put("baseDir", new File(getServlet().getServletContext()
					.getRealPath("/")));

			if (form.getSource() != null) {
				parameters.put("source", form.getSource());
			}

			if (!ignoreOverflow) {
				boolean overflow = checkRecordCount(jasperReport, connection,
						parameters);
				if (overflow) {
					reportBean.setOverflow(true);
					return errors;
				}
			} else {
				reportBean.setOverflow(false);
				form.setIgnoreOverflow(null); // Struts does not set this to
				// null automatically between
				// requests

			}

			JasperPrint jasperPrint =

			JasperFillManager.fillReport(

			jasperReport,

			parameters,

			connection

			);

			reportBean.setJasperPrint(jasperPrint);

		} catch (Exception e) {
			// TODO: Uzi: Change to Dashboard specific exception
			e.printStackTrace();
			errors.add("generic", new ActionMessage("error.generic"));

		} finally {
			close(connection);
		}

		return errors;

	}
	
	private boolean supportsBufferCache(Connection conn) 
	{
		if(conn!=null) {
			try {
				Statement st = conn.createStatement();
				ResultSet rs = st.executeQuery("SELECT relname FROM pg_class WHERE relname LIKE '%pg_buffer%'");
				if(rs.next()) {
					return true;
				}
			}
			catch(Exception e) {
				e.printStackTrace();
			}
			finally {
				try {
					conn.close();
				} catch (SQLException e1) {
					e1.printStackTrace();
				}
			}
		}
		return false;
  	}
}
