package com.enterprisedb.dashboard.web.action;

import org.apache.struts.action.*;

import com.enterprisedb.dashboard.agent.DashboardAgent;
import com.enterprisedb.dashboard.agent.DashboardAgentException;
import com.enterprisedb.dashboard.web.*;
import com.enterprisedb.dashboard.web.form.*;

import javax.servlet.http.*;

import net.sf.jasperreports.engine.*;

import net.sf.jasperreports.engine.util.*;

import java.sql.*;

import java.io.*;

import java.util.*;

/**
 * This action generates Column Pribilages report
 * 
 * @author Usman
 * @version 0.7c
 */

public class ColumnPrivilegesAction extends GenericAction

{

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)

	{

		ColumnPrivilegesForm columnPrivilegesForm = (ColumnPrivilegesForm) form;

		HttpSession session = request.getSession();

		ActionMessages errors = new ActionErrors();

		try {

			// call dashboard agent here...
			DashboardAgent.loadConfig(new File(getServlet().getServletContext()
					.getRealPath("/WEB-INF/configure.xml")));
			// FIX 0.7c: Uzi: Bypassing reporting database...

			Vector sources = getSources();
			request.setAttribute("sources", sources);
			String selectedSource = columnPrivilegesForm.getSource();

			if (selectedSource == null && sources.size() > 0) {
				selectedSource = (String) sources.get(0);
			}

			// FIX 0.7c: Uzi: Bypassing reporting database...
			Vector users = getUsers(DashboardAgent
					.getSourceConnection(selectedSource));
			request.setAttribute("users", users);

			request.setAttribute("schemas", getSchemas(DashboardAgent 
					.getSourceConnection(selectedSource)));
		} catch (SQLException e) {

			e.printStackTrace();

			errors.add("database", new ActionMessage("error.database"));

		} catch (Exception e) {

			e.printStackTrace();

			errors.add("generic", new ActionMessage("error.generic"));

		}

		if (errors.size() > 0) {

			saveErrors(request, errors);

			return mapping.findForward("genericerror");

		}

		if (request.getParameter("refresh") != null
				|| request.getParameter("ignoreOverflow") != null)

		{
			try {
				DashboardAgent.checkSourceConnection(columnPrivilegesForm
						.getSource());
				// FIX 0.7c: Uzi: Bypassing reporting database
			} catch (DashboardAgentException e) {
				e.printStackTrace();
				errors.add("database", new ActionMessage(
						"error.sourcedatabase", columnPrivilegesForm
								.getSource()));
			}

			if (errors.size() > 0) {

				saveErrors(request, errors);
				return mapping.findForward("genericerror");

			}

			ReportBean reportBean = new ReportBean();

			errors = fillReport(columnPrivilegesForm, reportBean);

			session.setAttribute("reportBean", reportBean);

			if (errors.size() > 0) {

				saveErrors(request, errors);

				saveMessages(request, errors);

				return mapping.findForward("success");

			}

		}

		else if (!handlePaging(request, (ReportBean) session
				.getAttribute("reportBean")))

			session.setAttribute("reportBean", null);

		String href = "pdf?id=" + String.valueOf(Math.random());

		request.setAttribute("pdfHref", href);

		return mapping.findForward("success");

	}

	/**
	 * 
	 * @param form
	 * 
	 * @param reportBean
	 * 
	 */

	public ActionErrors fillReport(ColumnPrivilegesForm form,
			ReportBean reportBean)

	{

		ActionErrors errors = new ActionErrors();

		Connection connection = null;

		boolean ignoreOverflow = form.getIgnoreOverflow() != null;

		reportBean.setPageIndex(0);

		try {

			// FIX 0.7c: Uzi: Bypassing reporting database...
			connection = DashboardAgent.getSourceConnection(form.getSource());

			File reportFile = new File(getServlet().getServletContext()
					.getRealPath("/reports/ColumnPrivileges.jasper"));

			JasperReport jasperReport = (JasperReport) JRLoader
					.loadObject(reportFile.getPath());

			Map parameters = new HashMap();

			parameters.put(JRParameter.REPORT_LOCALE, null);

			parameters.put("baseDir", new File(getServlet().getServletContext()
					.getRealPath("/")));

			if (form.getSource() != null)

			{

				parameters.put("source", form.getSource());

			}

			if (form.getDatabase() != null)

			{

				parameters.put("database", form.getDatabase());

			}

			if (form.getUser() != null)

			{

				parameters.put("user", form.getUser());

			}

			if (!ignoreOverflow) {

				boolean overflow = checkRecordCount(jasperReport, connection,
						parameters);

				if (overflow) {

					reportBean.setOverflow(true);

					return errors;

				}

			}

			else {

				reportBean.setOverflow(false);

				form.setIgnoreOverflow(null); // Struts does not set this to
				// null automatically between
				// requests

			}

			JasperPrint jasperPrint =

			JasperFillManager.fillReport(

			jasperReport,

			parameters,

			connection

			);

			reportBean.setJasperPrint(jasperPrint);

		} catch (Exception e) {

			e.printStackTrace();

			errors.add("generic", new ActionMessage("error.generic"));

		} finally {

			close(connection);

		}

		return errors;

	}

	/**
	 * Obtain users of database
	 * 
	 * @param conn
	 *            java.sql.Connection
	 */

	private Vector getUsers(Connection conn) throws SQLException

	{

		Statement st = null;

		ResultSet rs = null;

		Vector users = new Vector();

		try {

			st = conn.createStatement();

			rs = st.executeQuery("select usename from pg_user");

			while (rs.next()) {

				users.add(rs.getString(1));

			}

		} finally {

			close(conn, st, rs);

		}

		return users;

	}

}
