package com.enterprisedb.dashboard.web.action;

import org.apache.struts.action.*;

import com.enterprisedb.dashboard.agent.DashboardAgent;
import com.enterprisedb.dashboard.agent.Source;
import com.enterprisedb.dashboard.querytest.*;
import com.enterprisedb.dashboard.web.*;

import java.text.*;

import java.sql.*;

import java.util.*;
import java.util.logging.Logger;

import net.sf.jasperreports.engine.*;

import javax.servlet.http.*;

/**
 * Generic Action class that other action classes depends upon
 * @author Ionut Nedelcu
 * @author Usman
 * 
 */

public class GenericAction extends Action

{

	protected static final SimpleDateFormat dateFormat = new SimpleDateFormat(
			"dd-M-yyyy HH:mm");
	private static final Logger logger = Logger.getLogger(GenericAction.class.getName());

	/**
	 * Load specific count class at runtime and determine records counting
	 * @param jasperReport
	 * @param connection
	 * @param parameters
	 * @return
	 */
	public boolean checkRecordCount(JasperReport jasperReport,
			Connection connection, Map parameters)

	{

		String className = jasperReport
				.getProperty(QueryCount.QUERYCLASS_PROPERTY);

		try {

			Class klass = Class.forName(className);

			QueryCount queryTest = (QueryCount) klass.newInstance();

			queryTest.setJasperReport(jasperReport);

			queryTest.setConnection(connection);

			queryTest.setParameters(parameters);

			int count = queryTest.getCount();

			return count > QueryCount.QUERY_MAXCOUNT;

		} catch (ClassNotFoundException e) {

			System.out.println("Class " + className
					+ " does not exist or is not in the class path");

		} catch (IllegalAccessException e) {

			e.printStackTrace();

		} catch (InstantiationException e) {

			e.printStackTrace();

		}

		return false;

	}


	public void close(Connection conn)

	{

		try {

			if (conn != null)

				conn.close();

		} catch (SQLException e) {

			e.printStackTrace();

		}

	}

	public void close(Connection conn, Statement st, ResultSet rs)

	{

		try {

			if (rs != null)

				rs.close();

		} catch (SQLException e) {

			e.printStackTrace();

		}

		try {

			if (st != null)

				st.close();

		} catch (SQLException e) {

			e.printStackTrace();

		}

		try {

			if (conn != null)

				conn.close();

		} catch (SQLException e) {

			e.printStackTrace();

		}

	}

	public boolean handlePaging(HttpServletRequest request,
			ReportBean reportBean)

	{

		if (

		request.getParameter("btnFirst") != null

		|| request.getParameter("btnFirst.x") != null

		)

		{

			reportBean.setFirstPage();

		}

		else if (

		request.getParameter("btnPrevious") != null

		|| request.getParameter("btnPrevious.x") != null

		)

		{

			reportBean.setPreviousPage();

		}

		else if (

		request.getParameter("btnNext") != null

		|| request.getParameter("btnNext.x") != null

		)

		{

			reportBean.setNextPage();

		}

		else if (

		request.getParameter("btnLast") != null

		|| request.getParameter("btnLast.x") != null

		)

		{

			reportBean.setLastPage();

		}

		else

			return false;

		return true;

	}

	/**
	 * 
	 * Gets a list of monitored sources as read from configure file...
	 *TODO: Change return type to Iterator
	 */

	public Vector getSources() 

	{
		Vector v = new Vector();
		for (Iterator i = DashboardAgent.getSourceIterator(); i.hasNext();) {
			Source src = (Source) i.next();
			v.add(src.getName());
		}
		logger.fine(v.toString());
		return v;
	}

	/**
	 * Get schemas of a database
	 * 
	 * @param connection
	 *            java.sql.Connection Connection object to database
	 */

	public Vector getSchemas(Connection connection) throws SQLException

	{
		if (connection == null)
			return new Vector();

		Statement st = null;
		ResultSet rs = null;

		Vector schemas = new Vector();
		try {

			String query = "SELECT schema_name FROM "
					+ "information_schema.schemata"
					+ " WHERE UPPER(schema_name) NOT IN('PG_CATALOG','INFORMATION_SCHEMA','SYS','DBO','PG_TOAST')"
					+ " AND UPPER(schema_name) NOT LIKE 'PG_TEMP%'";
			st = connection.createStatement();
			rs = st.executeQuery(query);

			while (rs.next()) {
				schemas.add(rs.getString(1));
			}
		} finally {
			close(connection, st, rs);
		}
		return schemas;

	}

}
