package com.enterprisedb.dashboard.web.action;

import java.io.File;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import com.enterprisedb.dashboard.agent.DashboardAgent;
import com.enterprisedb.dashboard.agent.DashboardAgentException;
import com.enterprisedb.dashboard.agent.IndexesJRDataSource;
import com.enterprisedb.dashboard.querytest.QueryCount;
import com.enterprisedb.dashboard.web.ReportBean;
import com.enterprisedb.dashboard.web.form.IndexesForm;

/**
 * This action generates Index reports
 * 
 * @author Sarah Khalid
 * @author Usman
 * @version 0.7c
 */

public class IndexesAction extends GenericAction

{

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)

	{

		IndexesForm indexesForm = (IndexesForm) form;

		HttpSession session = request.getSession();

		ActionMessages errors = new ActionErrors();

		try {
			// call dashboard agent here...
			DashboardAgent.loadConfig(new File(getServlet().getServletContext()
					.getRealPath("/WEB-INF/configure.xml")));
			Vector sources = getSources();
			request.setAttribute("sources", sources);

			String selectedSource = indexesForm.getSource();
			if (selectedSource == null && sources.size() > 0)
				selectedSource = (String) sources.get(0);
			
			request.setAttribute("schemas", getSchemas(DashboardAgent
					.getSourceConnection(selectedSource)));

		} catch (Exception e) {
			e.printStackTrace();
			errors.add("generic", new ActionMessage("error.generic"));
		}

		if (errors.size() > 0) {

			saveErrors(request, errors);

			return mapping.findForward("genericerror");

		}

		if (request.getParameter("submit") != null
				|| request.getParameter("ignoreOverflow") != null)

		{

			try {
				DashboardAgent.checkSourceConnection(indexesForm.getSource());
				// FIX 0.7c: Uzi: Bypassing reporting database...

			} catch (DashboardAgentException e) {
				errors.add("database", new ActionMessage(
						"error.sourcedatabase", indexesForm.getSource()));
			}

			if (errors.size() > 0) {

				saveErrors(request, errors);

				return mapping.findForward("genericerror");

			}

			ReportBean reportBean = new ReportBean();

			errors = fillReport(indexesForm, reportBean);

			session.setAttribute("reportBean", reportBean);

			if (errors.size() > 0) {

				saveErrors(request, errors);

				saveMessages(request, errors);

				return mapping.findForward("success");

			}

		}

		else if (!handlePaging(request, (ReportBean) session
				.getAttribute("reportBean")))

			session.setAttribute("reportBean", null);

		String href = "pdf?id=" + String.valueOf(Math.random());

		request.setAttribute("pdfHref", href);

		return mapping.findForward("success");

	}

	public ActionErrors fillReport(IndexesForm form, ReportBean reportBean) {

		ActionErrors errors = new ActionErrors();

		boolean ignoreOverflow = form.getIgnoreOverflow() != null;

		Connection connection = null;

		reportBean.setPageIndex(0);

		try {


			connection = DashboardAgent.getSourceConnection(form.getSource());

			File reportFile = new File(getServlet().getServletContext()
					.getRealPath("/reports/Indexes.jasper"));

			JasperReport jasperReport = (JasperReport) JRLoader
					.loadObject(reportFile.getPath());

			Map parameters = new HashMap();

			parameters.put(JRParameter.REPORT_LOCALE, null);

			parameters.put("baseDir", new File(getServlet().getServletContext()
					.getRealPath("/")));

			IndexesJRDataSource jrDS = new IndexesJRDataSource(
					DashboardAgent.getSource(form.getSource()), form.getSchema());

			
			if (form.getSource() != null)

			{

				parameters.put("source", form.getSource());

			}

			if (form.getDatabase() != null)

			{

				parameters.put("database", form.getDatabase());

			}
			if (form.getSchema() != null)

			{

				parameters.put("schema", form.getSchema());

			}
			
			if (!ignoreOverflow) {
				boolean overflow = jrDS.getCount() > QueryCount.QUERY_MAXCOUNT;
				if (overflow) {
					reportBean.setOverflow(true);
					return errors;
				}
			}

			else {

				reportBean.setOverflow(false);

				form.setIgnoreOverflow(null); // Struts does not set this to
				// null automatically between
				// requests

			}

			JasperPrint jasperPrint =

			JasperFillManager.fillReport(

			jasperReport,

			parameters,

			jrDS

			);

			reportBean.setJasperPrint(jasperPrint);
			
		} catch (Exception e) {

			e.printStackTrace();

			errors.add("generic", new ActionMessage("error.generic"));

		} finally {

			close(connection);

		}

		return errors;

	}

}
