package com.enterprisedb.dashboard.web.action;

import java.io.File;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

import com.enterprisedb.dashboard.agent.*;
import com.enterprisedb.dashboard.agent.DashboardAgentException;
import com.enterprisedb.dashboard.web.ReportBean;
import com.enterprisedb.dashboard.web.form.LocksStatusForm;

/**
 * This is the action file responsible for generating the Locks status Report
 * 
 * @author Sarah Khalid
 * @author Usman
 * @version 0.8
 */
public class LocksStatusAction extends GenericAction {

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response) {
		LocksStatusForm statusForm = (LocksStatusForm) form;
		HttpSession session = request.getSession();
		ActionMessages errors = new ActionErrors();

		try {
			// call dashboard agent here...
			DashboardAgent.loadConfig(new File(getServlet().getServletContext()
					.getRealPath("/WEB-INF/configure.xml")));
			request.setAttribute("sources", getSources());
			// FIX (Uzi): Sets a default database for first time hit
			if (statusForm.getSource() == null) {
				// set the first database from the sources...
				Iterator iter = DashboardAgent.getSourceIterator();
				if (iter.hasNext()) {
					Source _source = (Source) iter.next();
					statusForm.setSource(_source.getName());
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			errors.add("generic", new ActionMessage("error.generic"));
		}

		if (errors.size() > 0) {
			saveErrors(request, errors);
			return mapping.findForward("genericerror");
		}

		// FIX (Uzi): Show report even on first/direct hit ...

		try {
			DashboardAgent.checkSourceConnection(statusForm.getSource());
		} catch (DashboardAgentException e) {
			errors.add("database", new ActionMessage("error.sourcedatabase",
					statusForm.getSource()));
			saveErrors(request, errors);
			return mapping.findForward("genericerror");
		}
		String refreshInterval = request.getParameter("refreshInterval");
		if (refreshInterval == null) {
			refreshInterval = "10";
		}
		// FIX 0.7c:Uzi:Bypassing reporting database...
		ReportBean reportBean = new ReportBean();
		errors = fillReport(statusForm, reportBean);
		session.setAttribute("reportBean", reportBean);
		if (errors.size() > 0) {
			saveErrors(request, errors);
			saveMessages(request, errors);
			return mapping.findForward("success");
		}

		String href = "pdf?id=" + String.valueOf(Math.random());
		request.setAttribute("pdfHref", href);

		return mapping.findForward("success");

	}

	public ActionErrors fillReport(LocksStatusForm form, ReportBean reportBean) {

		ActionErrors errors = new ActionErrors();
		boolean ignoreOverflow = form.getIgnoreOverflow() != null;
		Connection connection = null;

		reportBean.setPageIndex(0);

		try {
			// FIX 0.7c: Uzi: Bypassing reporting database...
			connection = DashboardAgent.getSourceConnection(form.getSource());
			File reportFile = new File(getServlet().getServletContext()
					.getRealPath("/reports/LockStatus.jasper"));

			JasperReport jasperReport = (JasperReport) JRLoader
					.loadObject(reportFile.getPath());
			Map parameters = new HashMap();
			parameters.put(JRParameter.REPORT_LOCALE, null);
			parameters.put("baseDir", new File(getServlet().getServletContext()
					.getRealPath("/")));
			if (form.getSource() != null) {
				parameters.put("source", form.getSource());
				parameters.put("dbname", DashboardAgent.getSource(form.getSource()).getDatabase());
			}

			if (!ignoreOverflow) {

				boolean overflow = checkRecordCount(jasperReport, connection,
						parameters);
				if (overflow) {
					reportBean.setOverflow(true);
					return errors;
				}
			} else {
				reportBean.setOverflow(false);
				form.setIgnoreOverflow(null); // Struts does not set this to
				// null automatically between
				// requests
			}

			JasperPrint jasperPrint = JasperFillManager.fillReport(
					jasperReport, parameters, connection);
			reportBean.setJasperPrint(jasperPrint);
		} catch (Exception e) {
			e.printStackTrace();
			errors.add("generic", new ActionMessage("error.generic"));
		} finally {
			close(connection);
		}
		return errors;
	}

}