package com.enterprisedb.dashboard.web.action;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

import com.enterprisedb.dashboard.agent.DashboardAgent;
import com.enterprisedb.dashboard.agent.DashboardAgentException;
import com.enterprisedb.dashboard.web.ReportBean;
import com.enterprisedb.dashboard.web.form.PackagesForm;

/**
 * This action generates the Packages report
 * 
 * @author Sarah 
 * @version 1.0b
 * 
 */

public class PackagesAction extends GenericAction

{

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)

	{

		PackagesForm packagesForm = (PackagesForm) form;

		HttpSession session = request.getSession();

		ActionMessages errors = new ActionErrors();

		boolean hasPackageSupport = false;
		
		try {

			// call dashboard agent here...
			DashboardAgent.loadConfig(new File(getServlet().getServletContext()
					.getRealPath("/WEB-INF/configure.xml")));

			Vector schemas = getSources();
			request.setAttribute("sources", schemas);

			String selectedSource = packagesForm.getSource();

			if (selectedSource == null && schemas.size() > 0) {
				selectedSource = (String) schemas.get(0);
			}

			request.setAttribute("schemas", getSchemas(DashboardAgent
					.getSourceConnection(selectedSource)));
			
			Connection conn = DashboardAgent.getSourceConnection(selectedSource);
			hasPackageSupport = this.supportsPackages(conn);
			
		} catch (Exception e) {
			e.printStackTrace();
			errors.add("generic", new ActionMessage("error.generic"));
		}

		if (errors.size() > 0) {
			saveErrors(request, errors);
			return mapping.findForward("genericerror");
		}

		if ((request.getParameter("refresh") != null || request.getParameter("ignoreOverflow") != null) && hasPackageSupport) {

			try {
				DashboardAgent.checkSourceConnection(packagesForm.getSource());

			} catch (DashboardAgentException e) {
				e.printStackTrace();
				errors.add("database", new ActionMessage(
						"error.sourcedatabase", packagesForm.getSource()));
			}
			if (errors.size() > 0) {
				saveErrors(request, errors);
				return mapping.findForward("genericerror");
			}

			ReportBean reportBean = new ReportBean();

			errors = fillReport(packagesForm, reportBean);

			session.setAttribute("reportBean", reportBean);

			if (errors.size() > 0) {

				saveErrors(request, errors);

				saveMessages(request, errors);

				return mapping.findForward("success");

			}

		}

		else if (!handlePaging(request, (ReportBean) session.getAttribute("reportBean"))) {
			session.setAttribute("reportBean", null);
		}

		String href = "pdf?id=" + String.valueOf(Math.random());

		request.setAttribute("pdfHref", href);

		return mapping.findForward("success");

	}

	public ActionErrors fillReport(PackagesForm form, ReportBean reportBean) {

		ActionErrors errors = new ActionErrors();

		boolean ignoreOverflow = form.getIgnoreOverflow() != null;

		Connection connection = null;

		reportBean.setPageIndex(0);

		try {
			connection = DashboardAgent.getSourceConnection(form.getSource());

			File reportFile = new File(getServlet().getServletContext()
					.getRealPath("/reports/Packages.jasper"));

			JasperReport jasperReport = (JasperReport) JRLoader
					.loadObject(reportFile.getPath());

			Map parameters = new HashMap();

			parameters.put(JRParameter.REPORT_LOCALE, null);

			parameters.put("baseDir", new File(getServlet().getServletContext()
					.getRealPath("/")));

			if (form.getSource() != null) {
				parameters.put("source", form.getSource());
			}
			
			if (form.getSchema() != null) {
				parameters.put("schema", form.getSchema());
			}
			
			if (!ignoreOverflow) {
				boolean overflow = checkRecordCount(jasperReport, connection,
						parameters);
				if (overflow) {
					reportBean.setOverflow(true);
					return errors;
				}
			} else {
				reportBean.setOverflow(false);
				form.setIgnoreOverflow(null); // Struts does not set this to
				// null automatically between
				// requests

			}

			JasperPrint jasperPrint =

			JasperFillManager.fillReport(

			jasperReport,

			parameters,

			connection

			);
			reportBean.setJasperPrint(jasperPrint);
		} catch (Exception e) {
			e.printStackTrace();
			errors.add("generic", new ActionMessage("error.generic"));

		} finally {
			close(connection);
		}

		return errors;

	}
	private boolean supportsPackages(Connection conn) 
	{
		if(conn!=null) {
			try {
				Statement st = conn.createStatement();
				ResultSet rs = st.executeQuery("SELECT * FROM pg_class WHERE relname = 'edb_package'");
				if(rs.next()) {
					return true;
				}
			}
			catch(Exception e) {
				e.printStackTrace();
			}
			finally {
				try {
					conn.close();
				} catch (SQLException e1) {
					e1.printStackTrace();
				}
			}
		}
		return false;
  	}
}
