package com.enterprisedb.dashboard.web.action;

import org.apache.struts.action.*;

import com.enterprisedb.dashboard.agent.DashboardAgent;
import com.enterprisedb.dashboard.agent.DashboardAgentException;
import com.enterprisedb.dashboard.web.*;
import com.enterprisedb.dashboard.web.form.*;

import javax.servlet.http.*;

import net.sf.jasperreports.engine.*;
import net.sf.jasperreports.engine.util.*;
import java.sql.*;
import java.io.*;
import java.util.*;

/**
 * Action class for the database Settings Info Report
 * 
 * @author Sarah 
 * @version 0.9
 * 
 */

public class SettingsInfoAction extends GenericAction

{

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)

	{

		SettingsInfoForm settingsInfoForm = (SettingsInfoForm) form;

		HttpSession session = request.getSession();

		ActionMessages errors = new ActionErrors();

		try {

			// call dashboard agent here...
			DashboardAgent.loadConfig(new File(getServlet().getServletContext()
					.getRealPath("/WEB-INF/configure.xml")));

			request.setAttribute("sources", getSources());

			Vector sources = getSources();

			String selectedSource = settingsInfoForm.getSource();
			if (selectedSource == null && sources.size() > 0) {
				selectedSource = (String) sources.get(0);
			}

		} catch (Exception e) {
			e.printStackTrace();
			errors.add("generic", new ActionMessage("error.generic"));
		}

		if (errors.size() > 0) {

			saveErrors(request, errors);

			return mapping.findForward("genericerror");

		}

		if (request.getParameter("refresh") != null
				|| request.getParameter("ignoreOverflow") != null)

		{
			try {
				DashboardAgent.checkSourceConnection(settingsInfoForm.getSource());
			} catch (DashboardAgentException e) {
				e.printStackTrace();
				errors.add("database", new ActionMessage(
						"error.sourcedatabase", settingsInfoForm.getSource()));
			}
			if (errors.size() > 0) {
				saveErrors(request, errors);
				return mapping.findForward("genericerror");
			}

			ReportBean reportBean = new ReportBean();

			errors = fillReport(settingsInfoForm, reportBean);

			session.setAttribute("reportBean", reportBean);

			if (errors.size() > 0) {

				saveErrors(request, errors);

				saveMessages(request, errors);

				return mapping.findForward("success");

			}

		}

		else if (!handlePaging(request, (ReportBean) session
				.getAttribute("reportBean")))

			session.setAttribute("reportBean", null);

		String href = "pdf?id=" + String.valueOf(Math.random());

		request.setAttribute("pdfHref", href);

		return mapping.findForward("success");

	}

	public ActionErrors fillReport(SettingsInfoForm form, ReportBean reportBean)

	{

		ActionErrors errors = new ActionErrors();

		Connection connection = null;

		boolean ignoreOverflow = form.getIgnoreOverflow() != null;

		reportBean.setPageIndex(0);

		try {
			// FIX 0.7c(Uzi): ReArchitecturing - bypassing reporting database..
			connection = DashboardAgent.getSourceConnection(form.getSource())/* getConnection() */;

			File reportFile = new File(getServlet().getServletContext()
					.getRealPath("/reports/Settings.jasper"));

			JasperReport jasperReport = (JasperReport) JRLoader
					.loadObject(reportFile.getPath());

			Map parameters = new HashMap();

			parameters.put(JRParameter.REPORT_LOCALE, null);

			parameters.put("baseDir", new File(getServlet().getServletContext()
					.getRealPath("/")));

			if (form.getSource() != null)

			{

				parameters.put("source", form.getSource());

			}

			if (!ignoreOverflow) {

				boolean overflow = checkRecordCount(jasperReport, connection,
						parameters);

				if (overflow) {

					reportBean.setOverflow(true);

					return errors;

				}

			}

			else {

				reportBean.setOverflow(false);

				form.setIgnoreOverflow(null); // Struts does not set this to
				// null automatically between
				// requests

			}

			JasperPrint jasperPrint =

			JasperFillManager.fillReport(

			jasperReport,

			parameters,

			connection

			);

			reportBean.setJasperPrint(jasperPrint);

		} catch (DashboardAgentException e) {
			e.printStackTrace();
			errors.add("database", new ActionMessage("error.sourcedatabase",
					form.getSource()));
		} catch (Exception e) {

			e.printStackTrace();

			errors.add("generic", new ActionMessage("error.generic"));

		} finally {

			close(connection);

		}

		return errors;

	}

}
