package com.enterprisedb.dashboard.web.action;

import java.io.File;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

import com.enterprisedb.dashboard.agent.DashboardAgent;
import com.enterprisedb.dashboard.agent.SourceStatsJRDataSource;
import com.enterprisedb.dashboard.web.ReportBean;
import com.enterprisedb.dashboard.web.form.SourcesStatsForm;

/**
 * Action class for landing page. Uses custom written JRDataSource implimentation
 * @author Usman
 * @version 0.7c
 */

public class SourcesStatsAction extends GenericAction

{

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)

	{

		SourcesStatsForm sourceForm = (SourcesStatsForm) form;

		HttpSession session = request.getSession();

		ActionMessages errors = new ActionErrors();

		try {
			// call dashboard agent here...
			DashboardAgent.loadConfig(new File(getServlet().getServletContext()
					.getRealPath("/WEB-INF/configure.xml")));

		}

		catch (Exception e) {
			e.printStackTrace();
			errors.add("generic", new ActionMessage("error.generic"));
		}

		ReportBean reportBean = new ReportBean();

		errors = fillReport(sourceForm, reportBean);

		session.setAttribute("reportBean", reportBean);

		if (errors.size() > 0) {

			saveErrors(request, errors);

			saveMessages(request, errors);

			return mapping.findForward("success");

		}

		String href = "pdf?id=" + String.valueOf(Math.random());

		request.setAttribute("pdfHref", href);

		return mapping.findForward("success");

	}

	/**
	 * 
	 * @param form
	 * @param reportBean
	 * @return
	 */
	
	public ActionErrors fillReport(SourcesStatsForm form, ReportBean reportBean) {

		ActionErrors errors = new ActionErrors();

		reportBean.setPageIndex(0);

		try {


			File reportFile = new File(getServlet().getServletContext()
					.getRealPath("/reports/SourcesStats.jasper"));

			JasperReport jasperReport = (JasperReport) JRLoader
					.loadObject(reportFile.getPath());

			Map parameters = new HashMap();

			parameters.put(JRParameter.REPORT_LOCALE, null);

			parameters.put("baseDir", new File(getServlet().getServletContext()
					.getRealPath("/")));


			
			JasperPrint jasperPrint =

			JasperFillManager.fillReport(

			jasperReport,

			parameters,

			new SourceStatsJRDataSource(DashboardAgent.getSourceIterator())

			);

			reportBean.setJasperPrint(jasperPrint);

		} catch (Exception e) {

			e.printStackTrace();

			errors.add("generic", new ActionMessage("error.generic"));

		} 

		return errors;

	}

}
