package com.enterprisedb.dashboard.web.action;

import org.apache.struts.action.*;

import com.enterprisedb.dashboard.agent.DashboardAgent;
import com.enterprisedb.dashboard.agent.DashboardAgentException;
import com.enterprisedb.dashboard.web.*;
import com.enterprisedb.dashboard.web.form.*;

import javax.servlet.http.*;


import net.sf.jasperreports.engine.*;
import net.sf.jasperreports.engine.util.*;
import java.sql.*;
import java.io.*;
import java.util.*;

/**
 * This action generates constraints report
 * 
 * @author Usman
 */

public class TableConstraintsAction extends GenericAction

{

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)

	{

		TableConstraintsForm tableConstraintsForm = (TableConstraintsForm) form;

		HttpSession session = request.getSession();

		ActionMessages errors = new ActionErrors();

		try {

			// call dashboard agent here...
			DashboardAgent.loadConfig(new File(getServlet().getServletContext()
					.getRealPath("/WEB-INF/configure.xml")));

			Vector sources = getSources();
			request.setAttribute("sources", sources);

			String selectedSource = tableConstraintsForm.getSource();
			if (selectedSource == null && sources.size() > 0)
				selectedSource = (String) sources.get(0);
			// FIX 0.7c: Uzi: Bypassing reporting database
			request.setAttribute("schemas", getSchemas(DashboardAgent
					.getSourceConnection(selectedSource)));

			// TODO:(Uzi) Use Dashboard Exception...
		} catch (Exception e) {
			e.printStackTrace();
			errors.add("generic", new ActionMessage("error.generic"));
		}

		if (errors.size() > 0) {
			saveErrors(request, errors);
			return mapping.findForward("genericerror");
		}

		if (request.getParameter("refresh") != null
				|| request.getParameter("ignoreOverflow") != null) {
			try {
				DashboardAgent.checkSourceConnection(tableConstraintsForm
						.getSource());
			} catch (DashboardAgentException e) {
				e.printStackTrace();
				errors.add("database", new ActionMessage(
						"error.sourcedatabase", tableConstraintsForm
								.getSource()));
			}
			if (errors.size() > 0) {
				saveErrors(request, errors);
				return mapping.findForward("genericerror");
			}

			ReportBean reportBean = new ReportBean();

			errors = fillReport(tableConstraintsForm, reportBean);

			session.setAttribute("reportBean", reportBean);

			if (errors.size() > 0) {

				saveErrors(request, errors);

				return mapping.findForward("success");

			}

		}

		else if (!handlePaging(request, (ReportBean) session
				.getAttribute("reportBean")))

			session.setAttribute("reportBean", null);

		String href = "pdf?id=" + String.valueOf(Math.random());

		request.setAttribute("pdfHref", href);

		return mapping.findForward("success");

	}

	public ActionErrors fillReport(TableConstraintsForm form,
			ReportBean reportBean)

	{

		ActionErrors errors = new ActionErrors();

		Connection connection = null;

		boolean ignoreOverflow = form.getIgnoreOverflow() != null;

		reportBean.setPageIndex(0);

		try {
			//FIX 0.7c: Uzi: Bypassing reporting database...
			connection = DashboardAgent.getSourceConnection(form.getSource());

			File reportFile = new File(getServlet().getServletContext()
					.getRealPath("/reports/TableConstraints.jasper"));

			JasperReport jasperReport = (JasperReport) JRLoader
					.loadObject(reportFile.getPath());

			Map parameters = new HashMap();

			parameters.put(JRParameter.REPORT_LOCALE, null);

			parameters.put("baseDir", new File(getServlet().getServletContext()
					.getRealPath("/")));

			if (form.getSource() != null)

			{

				parameters.put("source", form.getSource());

			}

			if (form.getDatabase() != null)

			{

				parameters.put("database", form.getDatabase());

			}

			if (!ignoreOverflow) {

				boolean overflow = checkRecordCount(jasperReport, connection,
						parameters);

				if (overflow) {

					reportBean.setOverflow(true);

					return errors;

				}

			}

			else {

				reportBean.setOverflow(false);

				form.setIgnoreOverflow(null); // Struts does not set this to
				// null automatically between
				// requests

			}

			JasperPrint jasperPrint =

			JasperFillManager.fillReport(

			jasperReport,

			parameters,

			connection

			);

			reportBean.setJasperPrint(jasperPrint);

		} catch (Exception e) {

			e.printStackTrace();

			errors.add("generic", new ActionMessage("error.generic"));

		} finally {

			close(connection);

		}

		return errors;

	}

}
