package com.enterprisedb.dashboard.web.servlet;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.enterprisedb.dashboard.agent.DashboardAgent;
import com.enterprisedb.dashboard.agent.Source;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;

/**
 * PDF Servlet for i-Query PDF generation.
 * 
 * @author Sarah
 */
public class IQueryPdfServlet extends HttpServlet {

	/**
	 * Auto generated serial version UID
	 */
	private static final long serialVersionUID = 3919640423029420797L;

	/**
	 * Returns a PDF of i-Query execution
	 * 
	 * @see javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse)
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException {
		
		//Retrive the query written
		String source = request.getParameter("source");
		String iquery = request.getParameter("query");
		boolean status = true;		
		boolean invalidParameters = false;
		String html="";
		String warningMessages="<font size=\"2\" color=\"#000000\">";
//		this array hold html to be displayed in case of multiple resultsets
		ArrayList htmlList = new ArrayList();

		
		if(iquery.trim().length()==0) {
		    System.out.println("Invalid query");
            invalidParameters = true;
		}
		
		
		if(invalidParameters) {
 	        response.setContentType("text/html");

			PrintWriter out = response.getWriter();

			out.println("<html>");

			out.println("<body bgcolor=\"white\">");

			out.println("<span class=\"bold\">Invalid Query...</span>");

			out.println("</body>");

			out.println("</html>");
			return;
		
		}
		
		// step 1
		Document document = new Document(PageSize.A5);
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		
		Font font = FontFactory.getFont(FontFactory.HELVETICA, 6, Font.NORMAL, Color.BLACK);
		
		try {
			// step 2: we set the ContentType and create an instance of the
			// corresponding Writer

			PdfWriter.getInstance(document, baos);
			// step 3
			document.open();

			// step 4
			Source _source = DashboardAgent.getSource(source);
			if (_source != null) {
				String contents = "";
				//String query = "select pg_read_file(filename,CASE when len > 1048576 then len - 1048576 ELSE 0 end,len) from (select filename, pg_file_length(filename) AS len from pg_logdir_ls()   as abc(filetime timestamp, filename text)where filetime = (select max(filetime) from pg_logdir_ls() b(filetime timestamp, filename text))) as A ";
				Connection con = null;
				try {
					con = _source.getConnection();
					con.setAutoCommit(false);
					Statement stmt = con.createStatement();
				    //Business Rule: 'select' queries must not return results more than 2500
				   	stmt.setMaxRows(2500);
				    //execute generic sql query...
					long queryStartTime = 0;					
					ResultSet rs = stmt.executeQuery(iquery);
					queryStartTime = System.currentTimeMillis();
					status = stmt.execute(iquery);
					//retrive warnings...
				    SQLWarning warnings = stmt.getWarnings();
				    //Append the list of warning messages
				    
				    
					PdfPTable warningsTable = new PdfPTable(1);
					warningsTable.setWidthPercentage(100f);
					
				    while(warnings!=null){        
						PdfPCell cell = new PdfPCell(new Paragraph(warnings.toString(),font)); 
					    cell.setBackgroundColor(new Color(205, 205, 205)); 
					    cell.setHorizontalAlignment(Element.ALIGN_LEFT);
					    warningsTable.addCell(cell); 				    	       
					    warnings = warnings.getNextWarning();
			        }
				    document.add(warningsTable);
					
					long queryDiffTime = System.currentTimeMillis()- queryStartTime;//diff in ms

					//If the query returned a resultset,that is a SELECT statement
					if(status) {
						  //DashboardResultSetConverter converter = new DashboardResultSetConverter();
						  do{
						  	//Loop through all the returned ResultSets and their columns
							ResultSet rsInner = stmt.getResultSet();
							ResultSetMetaData rsmd = rsInner.getMetaData();

							PdfPTable table = new PdfPTable(rsmd.getColumnCount());
							table.setWidthPercentage(100);

							//Get the Column Names
							for (int i = 1; i <= rsmd.getColumnCount(); i++) {
								PdfPCell cell = new PdfPCell(new Paragraph(rsmd.getColumnName(i),font));
							    cell.setBorder(1);
							    cell.setBackgroundColor(new Color(156, 156, 156));
							    table.addCell(cell); 
							    
							}

							
							//Get the Column Values
							while (rsInner.next()) {
								for (int i = 1; i <= rsmd.getColumnCount(); i++) {
									Object obj = rsInner.getObject(i);
									String value = "";

									if(obj != null)
										value = obj.toString();
									
									PdfPCell cell = new PdfPCell(new Paragraph(value,font)); 
								    cell.setBackgroundColor(new Color(255, 255, 255)); 
								    cell.setHorizontalAlignment(Element.ALIGN_LEFT);
								    cell.setBorder(0);
								    table.addCell(cell); 
								}

							}

							document.add(table);

					  } while(stmt.getMoreResults());
						  
					}
					//If the statement was an INSERT or UPDATE statement
					else {
					  int count = stmt.getUpdateCount();
					  String message = "";
					  
					  if(count<=0)
					  	message = "Query returned successfully with no result in " + queryDiffTime + " ms.";
					  else
					  	message = "Query returned successfully: "+ count+" rows affected, "+ queryDiffTime +" ms execution time.";
					  
					  document.add(new Paragraph(message,font));
					}					
					rs.close();
					stmt.close();
				} catch (SQLException e) {
					contents = "Unable to obtain contents:" + e.getMessage();
				} finally {
					if (con != null) {
						try {
							con.close();
						} catch (SQLException e) {
							// unable to close connection ... do nothing here...
						}
					}
				}
				document.add(Chunk.NEWLINE);
				//System.out.println(contents);

			} else {
				document
						.add(new Paragraph("Invalid database source:" + source));
			}

			// document.add(new Paragraph(source));
			// document.add(new Paragraph(new Date().toString()));
		} catch (DocumentException de) {
			de.printStackTrace();
			System.err.println("document: " + de.getMessage());
		} finally {
			// step 5: we close the document (the outputstream is also closed
			// internally)
			document.close();
		}
		// headers...
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control",
				"must-revalidate, post-check=0, pre-check=0");
		response.setHeader("Pragma", "public");
		// setting the content type
		response.setContentType("application/pdf");

		// write ByteArrayOutputStream to the ServletOutputStream
		ServletOutputStream out = response.getOutputStream();
		byte[] stuff = baos.toByteArray();
		// the contentlength is needed for MSIE!!!
		response.setContentLength(stuff.length);
		out.write(stuff, 0, stuff.length);
		out.flush();
		out.close();
	}
}