package com.enterprisedb.dashboard.web.servlet;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.enterprisedb.dashboard.agent.DashboardAgent;
import com.enterprisedb.dashboard.agent.Source;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfWriter;

/**
 * PDF Servlet for Logs file generation. Use iText PDF engine.
 * 
 * @author Usman
 */
public class LogsPdfServlet extends HttpServlet {

	/**
	 * Auto generated serial version UID
	 */
	private static final long serialVersionUID = 3919640423029420797L;

	/**
	 * Returns a PDF of database logs
	 * 
	 * @see javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse)
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException {

		// we retrieve the presentationtype
		String source = request.getParameter("source");
		String logFileName = request.getParameter("logFileName");
		String smax = request.getParameter("max");
		String smin = request.getParameter("min");
		String ssize = request.getParameter("size");
		
		int max = 0;
		int min = 0;
		int size = 0;
		boolean invalidParameters = false;
		try {
		     max = Integer.parseInt(smax);
		}catch(NumberFormatException nfe) {
                       System.out.println(nfe);
		       invalidParameters = true;
		}
		try {
                    min = Integer.parseInt(smin);
		}catch(NumberFormatException nfe) {
		     System.out.println(nfe);
                     invalidParameters = true;
		}
		try {

                    size = Integer.parseInt(ssize);
		}catch(NumberFormatException nfe) {
		 System.out.println(nfe);
                     invalidParameters = true;
		}
		if( logFileName==null) {
		    System.out.println("Null File");
                        invalidParameters = true;
		}
		
		
		if(invalidParameters) {
 	                response.setContentType("text/html");

			PrintWriter out = response.getWriter();

			out.println("<html>");

			out.println("<body bgcolor=\"white\">");

			out.println("<span class=\"bold\">Invalid Parameters...</span>");

			out.println("</body>");

			out.println("</html>");
			return;
		
		}
		
		// step 1
		Document document = new Document();
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		try {
			// step 2: we set the ContentType and create an instance of the
			// corresponding Writer

			// PdfWriter.getInstance(document, response.getOutputStream());

			PdfWriter.getInstance(document, baos);
			// step 3
			document.open();

			// step 4
			Source _source = DashboardAgent.getSource(source);
			if (_source != null) {
				String contents = "";
				//String query = "select pg_read_file(filename,CASE when len > 1048576 then len - 1048576 ELSE 0 end,len) from (select filename, pg_file_length(filename) AS len from pg_logdir_ls()   as abc(filetime timestamp, filename text)where filetime = (select max(filetime) from pg_logdir_ls() b(filetime timestamp, filename text))) as A ";

				String query = "select pg_read_file(current_setting('log_directory')||'/'||'"+ logFileName+"',"+
				"case when "+ min +" <= -1 then 0 else "+min+" end,"+
				"case when "+max+">=" + size+1+" then "+size+" else "+max+" end) ";
				Connection con = null;
				try {
					con = _source.getConnection();

					Statement stmt = con.createStatement();
					ResultSet rs = stmt.executeQuery(query);

					while (rs.next()) {
						document
								.add(new Paragraph(rs.getString("pg_read_file")));
					}
					rs.close();
					stmt.close();
				} catch (SQLException e) {
					contents = "Unable to obtain contents:" + e.getMessage();
				} finally {
					if (con != null) {
						try {
							con.close();
						} catch (SQLException e) {
							// unable to close connection ... do nothing here...
						}
					}
				}
				document.add(Chunk.NEWLINE);
				System.out.println(contents);

			} else {
				document
						.add(new Paragraph("Invalid database source:" + source));
			}

			// document.add(new Paragraph(source));
			// document.add(new Paragraph(new Date().toString()));
		} catch (DocumentException de) {
			de.printStackTrace();
			System.err.println("document: " + de.getMessage());
		} finally {
			// step 5: we close the document (the outputstream is also closed
			// internally)
			document.close();
		}

		// headers...
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control",
				"must-revalidate, post-check=0, pre-check=0");
		response.setHeader("Pragma", "public");
		// setting the content type
		response.setContentType("application/pdf");

		// write ByteArrayOutputStream to the ServletOutputStream
		ServletOutputStream out = response.getOutputStream();
		byte[] stuff = baos.toByteArray();
		// the contentlength is needed for MSIE!!!
		response.setContentLength(stuff.length);
		out.write(stuff, 0, stuff.length);
		out.flush();
		out.close();
	}
}