package com.enterprisedb.dashboard.web.servlet;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;

/**
 * PDF Servlet for Query Profiler PDF generation.
 * 
 * @author Sarah
 */
public class QueryProfilerPdfServlet extends HttpServlet {

	/**
	 * Auto generated serial version UID
	 */
	private static final long serialVersionUID = 3919640423029420797L;

	/**
	 * Returns a PDF of Query Profiler execution
	 * 
	 * @see javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse)
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException {
		
		//Retrive the query written
		String query = request.getParameter("query");
		boolean status = true;		
		Connection con = null;
		boolean invalidParameters = false;
		String html="";
		String warningMessages="<font size=\"2\" color=\"#000000\">";
//		this array hold html to be displayed in case of multiple resultsets
		ArrayList htmlList = new ArrayList();

		
		if(query.trim().length()==0) {
		    System.out.println("Invalid query");
            invalidParameters = true;
		}
		
		
		if(invalidParameters) {
 	        response.setContentType("text/html");

			PrintWriter out = response.getWriter();

			out.println("<html>");

			out.println("<body bgcolor=\"white\">");

			out.println("<span class=\"bold\">Invalid Query...</span>");

			out.println("</body>");

			out.println("</html>");
			return;
		
		}
		
		// step 1
		Document document = new Document(PageSize.A5);
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		String contents = "";
		
		//Define our fonts here
		Font fontQuery = FontFactory.getFont(FontFactory.COURIER, 6, Font.NORMAL, Color.BLACK); 	//font for printing sql queries
		Font fontNormal = FontFactory.getFont(FontFactory.HELVETICA, 6, Font.NORMAL, Color.BLACK); 	//font for everything else
		
		try {
			// step 2: we set the ContentType and create an instance of the
			try {
	
			PdfWriter.getInstance(document, baos);
			// step 3
			document.open();

			// step 4
			Context initContext = null;
			initContext = new InitialContext();
			Context envContext = (Context) initContext.lookup("java:/comp/env");
			DataSource ds = (DataSource) envContext.lookup("DashboardDS");
			con = ds.getConnection();

			} catch (NamingException e) {
				e.printStackTrace();
			}

			if(con!=null) {
				con.setAutoCommit(false);
				Statement stmt = con.createStatement();
				ResultSet rs = stmt.executeQuery(query);
				status = stmt.execute(query);
	
				do{
				  	//Loop through all the returned ResultSets and their columns
					ResultSet rsInner = stmt.getResultSet();
					ResultSetMetaData rsmd = rsInner.getMetaData();
	
					PdfPTable table = new PdfPTable(rsmd.getColumnCount());
					table.setWidthPercentage(100);
					
					float[] cellWidths = {0.1f,0.1f,0.1f,0.7f};
					
					table.setWidths(cellWidths);
					
					//Build the column header here
					PdfPCell cellHeaderCount = new PdfPCell(new Paragraph("Count", fontNormal));
					cellHeaderCount.setBackgroundColor(new Color(156, 156, 156));
					cellHeaderCount.setBorder(1);
					
					PdfPCell cellTotalExecTime = new PdfPCell(new Paragraph("Total Execution Time", fontNormal));
					cellTotalExecTime.setBackgroundColor(new Color(156, 156, 156));
					cellTotalExecTime.setBorder(1);
					
					PdfPCell cellAverageExecTime = new PdfPCell(new Paragraph("Average Execution Time", fontNormal));
					cellAverageExecTime.setBackgroundColor(new Color(156, 156, 156));
					cellAverageExecTime.setBorder(1);

					PdfPCell cellStatement = new PdfPCell(new Paragraph("Statement", fontNormal));
					cellStatement.setBackgroundColor(new Color(156, 156, 156));
					cellStatement.setBorder(1);

					
					table.addCell(cellHeaderCount);
					table.addCell(cellTotalExecTime);
					table.addCell(cellAverageExecTime);
					table.addCell(cellStatement);
					
					//Get the Column Values
					boolean odd = true;
				
					
					//Format the duration to 3 decimal places
					DecimalFormat durationFormat = new DecimalFormat();
					durationFormat.setMaximumFractionDigits(3);
					durationFormat.setDecimalSeparatorAlwaysShown(false);
					
					while (rsInner.next()) {
						for (int i = 1; i <= rsmd.getColumnCount(); i++) {
							String value = "";	
							Object obj = rsInner.getObject(i);
							if(obj instanceof BigDecimal) {
								value = durationFormat.format(Double.parseDouble(obj.toString()));
							}
							else {
								value = obj.toString();
							}
							PdfPCell cell = new PdfPCell(new Paragraph(value, rsmd.getColumnName(i).equals("statement") ? fontQuery : fontNormal)); 
							cell.setHorizontalAlignment(Element.ALIGN_LEFT);
						    cell.setBorder(0);
						    table.addCell(cell); 
						}
					}
					document.add(table);
	
			  } while(stmt.getMoreResults());
			
				rs.close();
				stmt.close();
	
				document.add(Chunk.NEWLINE);
				//System.out.println(contents);
			} //if
		 
		} catch (DocumentException de) {
			de.printStackTrace();
			System.err.println("document: " + de.getMessage());						
		} catch (SQLException e) {
			contents = "Unable to obtain contents:" + e.getMessage();
		} 
		finally {
			if (con != null) {
				try {
					con.close();
					document.close();
				} 
				catch (Exception e) {
///*					if(e instanceof SQLException) {
//						//System.out.println("SQL Exception");
//					}
//					else {
//						//System.out.println("Document Exception");
//					}*/
				}
			}
		}

		// headers...
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control",
				"must-revalidate, post-check=0, pre-check=0");
		response.setHeader("Pragma", "public");
		// setting the content type
		response.setContentType("application/pdf");

		// write ByteArrayOutputStream to the ServletOutputStream
		ServletOutputStream out = response.getOutputStream();
		byte[] stuff = baos.toByteArray();
		// the contentlength is needed for MSIE!!!
		response.setContentLength(stuff.length);
		out.write(stuff, 0, stuff.length);
		out.flush();
		out.close();
	}
}