package com.enterprisedb.dashboard.web.servlet;



import java.io.IOException;

import java.io.PrintWriter;



import javax.servlet.ServletException;

import javax.servlet.ServletOutputStream;

import javax.servlet.http.HttpServlet;

import javax.servlet.http.HttpServletRequest;

import javax.servlet.http.HttpServletResponse;

import com.enterprisedb.dashboard.web.ReportBean;








/**

 * @author Teodor Danciu (teodord@users.sourceforge.net)

 * @version $Id: XlsServlet.java,v 1.1.1.1 2005/11/11 13:56:41 babar Exp $

 */

public class XlsServlet extends HttpServlet

{





	/**

	 *

	 */

	public void service(

		HttpServletRequest request,

		HttpServletResponse response

		) throws IOException, ServletException

	{

		byte[] bytes = null;



		ReportBean reportBean = (ReportBean)request.getSession().getAttribute("reportBean");

		if (reportBean != null)

		{

			bytes = reportBean.getXls();

		}



		if (bytes != null && bytes.length > 0)

		{

			response.setContentType("application/vnd.ms-excel");

			response.setHeader("Content-Disposition", "inline; filename=\"file.xls\"");

			response.setContentLength(bytes.length);

			ServletOutputStream ouputStream = response.getOutputStream();

			

			try

			{

				ouputStream.write(bytes, 0, bytes.length);

				ouputStream.flush();

			}

			catch (IOException e)

			{

				if (ouputStream != null)

				{

					try

					{

						ouputStream.close();

					}

					catch (IOException ex)

					{

					}

				}

			}

		}

		else

		{

			response.setContentType("text/html");

			PrintWriter out = response.getWriter();

			out.println("<html>");

			out.println("<body bgcolor=\"white\">");

			out.println("<span class=\"bold\">Empty response.</span>");

			out.println("</body>");

			out.println("</html>");

		}

	}





}

