<%@ page language="java" buffer="8kb" autoFlush="true" isThreadSafe="true" info="Info string" isErrorPage="false"  %>
<%@ page import="java.util.*, java.sql.*,com.enterprisedb.dashboard.agent.*" %>
<%!
static {
        try {
			Class.forName("com.edb.Driver");
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		}
}
String source_name = null;
%>
<% 
DashboardAgent.loadConfig(new java.io.File(getServletConfig().getServletContext().getRealPath("/WEB-INF/configure.xml")));
//get Source database information from DashboardAgent
source_name = request.getParameter("source");
Source _source = DashboardAgent.getSource(source_name);
String query = "SELECT name,setting FROM pg_settings WHERE UPPER(name) LIKE 'STATS%'"; //request.getParameter("query")
if(query == null) {
 query = "";
} 
//this html will be our result...
String html="";
String warningMessages="<font size=\"2\" color=\"#000000\">";
//this array hold html to be displayed in case of multiple resultsets
ArrayList htmlList = new ArrayList();
//lets trim the query and remove any trailing whitespaces
query = query.trim();
boolean status = true;
//we only want to continue if we have something in query parameter and source exist

 //if _source = null, pull first source
if(_source == null) {
 		Iterator iter = DashboardAgent.getSourceIterator(); 
		if(iter.hasNext()) {
		   _source = (Source)iter.next();
		    source_name = _source.getName();
		}
}

//FIX 0.7b #8 (Uzi): Do not update stats in database if we are in read only mode...
//update parameters state in database ...
if(_source != null && !_source.isReadOnly()) {
if(request.getParameter("_refresh") != null && request.getParameter("_refresh").length()<=0) {

  Enumeration paramNames = request.getParameterNames();
  while(paramNames.hasMoreElements()) {
      String parm = (String)paramNames.nextElement();
	  //we don't want to handle stats_reset_on_server_start and stats_start_collector
      if(parm.startsWith("dash_") && !(parm.equalsIgnoreCase("dash_stats_reset_on_server_start") || parm.equalsIgnoreCase("dash_stats_start_collector"))) {
	     //this is our parameter
		 String parameter = parm.substring(5);//get the actual parameter name
		 String value = request.getParameter(parm);
		 String newSetting = "";
		 
		 newSetting = value.equalsIgnoreCase("on") ? "true" : "false";
			
		 String updateSettings = "ALTER DATABASE " + _source.getDatabase() + " SET " + parameter + "=" + newSetting;
		//Comment this out in production
		 //System.out.println(updateSettings);
		 
		 Connection con = null;
		 try {
		 con = _source.getConnection();
    	 Statement stmt = con.createStatement();
		 stmt.execute(updateSettings);
		 stmt.close();
		 }catch(SQLException sqe) {
		  System.err.println(sqe);
		 }finally {
		   if(con != null) {
              try{
	           con.close();
	          }catch(SQLException sqe){
	           //do nothing here...
	          }
           }//if
		 }//finally
	  }else if(parm.equalsIgnoreCase("collected_stat") &&  request.getParameter(parm) != null && request.getParameter(parm).equalsIgnoreCase("collected_stat")) {
	  
		Connection con = null;
		 try {
		 con = _source.getConnection();
    	 Statement stmt = con.createStatement();
		 stmt.execute("select pg_stat_reset()");
		 System.out.println("select pg_stat_reset()");//TODO: comment it out in production environment...
		 stmt.close();
		 }catch(SQLException sqe) {
		  System.err.println(sqe);
		 }finally {
		   if(con != null) {
              try{
	           con.close();
	          }catch(SQLException sqe){
	           //do nothing here...
	          }
           }//if
		 }//finally		
	  }
  }//while
  
  
  
}//if
}//readOnly...



if(query.length()>0 && _source != null) {


  Connection con = null;
  try{
    //execute query...
    con = _source.getConnection();
    Statement stmt = con.createStatement();
    //Business Rule: 'select' queries must not return results more than 2500
   	//stmt.setMaxRows(2500);
	//stmt.setQueryTimeout(4); //wait for x seconds before query timeout...
    //execute generic sql query...
	long queryStartTime = System.currentTimeMillis();	
    status = stmt.execute(query);
	long queryDiffTime = System.currentTimeMillis()- queryStartTime;//diff in ms
    
	//retrive warnings...
	SQLWarning warnings = stmt.getWarnings();
	StringBuffer warningsStringBuffer = new StringBuffer();
	while(warnings!=null){        
		warningsStringBuffer.append(warnings.toString());
		warningsStringBuffer.append("<br>");        
        warnings = warnings.getNextWarning();
    }
	warningMessages += warningsStringBuffer.toString();

    //it was a "select" query...
	if(status) {
      //we have a result set
	  DashboardResultSetConverter converter = new DashboardResultSetConverter();
	  do{
	    //convert resultset to HTML table
		//html = converter.formattedResultSet(stmt.getResultSet());
		StringBuffer htmBuf = new StringBuffer();
		htmBuf.append("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">"+
                "<tr bgcolor=\"#999999\"><td width=\"75%\">Parameters</td><td align=\"right\" width=\"25%\">Status</td></tr>");
		ResultSet rs = stmt.getResultSet();
		while(rs.next()) {
		  String name = rs.getString("name");
		  String setting = rs.getString("setting");
		  String disabled = (_source.isReadOnly()||name.equalsIgnoreCase("stats_reset_on_server_start") || name.equalsIgnoreCase("stats_start_collector"))?"DISABLED":"";				
          htmBuf.append("<tr><td>"+name+"</td><td align=\"right\"><input name=\""+ name+"\" type=\"checkbox\" onClick=\"toggle(this)\" value=\""+ 
		       setting+"\" "+ (setting.equalsIgnoreCase("on")?"checked":"")+" "+ disabled+"><input type=\"hidden\" name=\"dash_"+name+"\" value=\""+setting+"\"></td></tr>");
		}		
        htmBuf.append("</table>");
		html = htmBuf.toString();
		htmlList.add(html);//add resultset to array in case we have more then one resultset
		warningMessages += "<font size=\"1\" color=\"#000000\">Total query runtime: "+queryDiffTime+" ms.<br>"+ converter.getRecords()+" rows retrieved.</font><br>";
	  }while(stmt.getMoreResults());
    }else {
	//it was a DML query...
	  int count = stmt.getUpdateCount();
	  if( count <=0) {
	     warningMessages += "<font size=\"1\" color=\"#000000\">Query returned successfully with no result in "+ queryDiffTime +" ms.</font><br>";
      }else {
		  warningMessages += "<font size=\"1\" color=\"#000000\">Query returned successfully: "+ count+" rows affected, "+ queryDiffTime +" ms execution time.</font><br>";
	  }
    }
 
   }catch(SQLException sqe){
   warningMessages += "<font size=\"2\" color=\"#FF0000\">" + sqe.getMessage()+"</font><br>";  
   status = false;//defaults to "Messages Window"
   }finally{
       if(con != null) {
           try{
	           con.close();
	       }catch(SQLException sqe){
	           //do nothing here...
	       }
       }
   }
   	warningMessages += "</font>";
}
%>
<jsp:include page="header.jsp"> 
<jsp:param name="title" value="iQuery Executor"/>
</jsp:include>
<script language="JavaScript" type="text/JavaScript">
<!--
function toggle(cb) { //v2.0
var f = document.form1;
if(cb.checked) {
   f.elements['dash_' + cb.name].value = 'ON';
}else {
f.elements['dash_' + cb.name].value = 'OFF';
}   
//alert(f.elements['dash_' + cb.name].value); 
}
//-->
</script>
&nbsp;&nbsp;<font class="title">Configuration</font>
<hr size="1" color="#000000">
<table width="100%" border="0" align="left" cellpadding="0" cellspacing="0">
  <tr> 
    <td align="left" valign="top">
	
	<form name="form1" method="post" action="">
	    <table width="60%" border="0" cellspacing="0" cellpadding="0" align="left">
          <tr> 
            <td colspan="2"><table width="469" border="0" align="left" cellpadding="2" cellspacing="3">
                <tr> 
                  <td width="57" align="left" valign="middle"><div align="left">Database</div></td>
                  <td width="395" colspan="2" align="right" valign="top"> <div align="left"> 
                      <select name="source" id="source" style="width:60%;" onChange="this.form.refresh.click()">
                        <%
		  for(Iterator iter = DashboardAgent.getSourceIterator(); iter.hasNext();) {
		     Source __source = (Source)iter.next();
			 String dbName = __source.getName();
		  %>
                        <option value="<%=dbName%>" <%=((source_name!=null && source_name.equalsIgnoreCase(dbName))?"selected":"")%>><%=dbName%></option>
                        <%
		  }
		  %>
                      </select>
                      <input name="refresh" type="submit" id="refresh" value="Refresh" onClick="document.form1._refresh.value='yes'">
                      <input name="_refresh" type="hidden" value="">
                    </div></td>
                </tr>
              </table>
			  </td>
          </tr>
		  <tr>
		  	<td colspan="2">
				<%
					if(source_name!=null) {
				%>			 
				<table width="100%" border="0" cellspacing="3" cellpadding="3">
				  <tr>
					<td>
					<% if(DashboardAgent.getSource(source_name).isReadOnly()) { %> 
					  <font size="1" color="#FF0000" face="Arial, Helvetica, sans-serif"><%="&nbsp;&nbsp;- The database " + source_name + " is configured in read-only mode."%></font><br>
					<% } //end if%>
					</td>
				  </tr>
				</table>
				<%
				 }//if
				%>
			</td>
		  </tr>
          <tr> 
            <td width="3%">&nbsp; </td>
            <td width="97%"><table width="46%" border="0" align="left" cellpadding="0" cellspacing="0">
                <!-- The result...whatever it is -->
                <%
	       for(int i=0; i<htmlList.size(); i++) {
	             String result = (String)htmlList.get(i);
	        %>
                <tr> 
                  <td align="center" valign="top"><%=result%></td>
                </tr>
                <%
               }//for
           %>
		    <tr> 
                  <td align="center" valign="top"> <hr size="1" color="#000000"></td>
                </tr>
             </table></td>
          </tr>
          <tr> 
            <td colspan="2"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr align="center"> 
                  <td colspan="2"><div align="left"> 
                      <table width="100%" border="0" cellspacing="0" cellpadding="0">
                        <tr> 
                          <td width="14%" valign="top">&nbsp;</td>
                          <td width="86%"><% if(!_source.isReadOnly()) {%>Reset Collected Stats 
                            <input name="collected_stat" type="checkbox" id="collected_stat" value="collected_stat">
							<%}%> 
                          </td>
                        </tr>
                      </table>
                    </div></td>
                </tr>
                <tr align="center"> 
                  <td width="54%"><% if(!_source.isReadOnly()) {%><input name="Submit" type="submit" value="Apply"><%}%> 
                  </td>
                  <td width="46%">&nbsp;</td>
                </tr>
              </table></td>
          </tr>
        </table>
		<%
		if(request.getParameter("source") == null) {
				Iterator iter = DashboardAgent.getSourceIterator(); 
				if(iter.hasNext()) {
				   _source = (Source)iter.next();
					source_name = _source.getName();
				}
		}
		%>
		
		
      </form>


</td>
  </tr>
  <tr> 
    <td colspan="2"> <jsp:include page="menu_end.jsp"/></td>
  </tr>
</table>
	 

