<%@ page language="java" buffer="8kb" autoFlush="true" isThreadSafe="true" info="Info string" isErrorPage="false"  %>
<%@ page import="java.util.*, java.sql.*,com.enterprisedb.dashboard.agent.*" %>
<%!
static {
        try {
			Class.forName("com.edb.Driver");
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		}
}
String source_name = null;
%>
<% 
DashboardAgent.loadConfig(new java.io.File(getServletConfig().getServletContext().getRealPath("/WEB-INF/configure.xml")));
//get Source database information from DashboardAgent
source_name = request.getParameter("source");
Source _source = DashboardAgent.getSource(source_name);
String query = request.getParameter("query");
//always populated with currently selected source, for the first page hit it picks the first item from the drop down list
String currentDbName = null; 

if(query == null) {
 query = "";
} 
//this html will be our result...
String html="";
String warningMessages="<font size=\"2\" color=\"#000000\">";
//this array hold html to be displayed in case of multiple resultsets
ArrayList htmlList = new ArrayList();
//lets trim the query and remove any trailing whitespaces
query = query.trim();
boolean status = true;
//we only want to continue if we have something in query parameter and source exist
if(query.length()>0 && _source != null) {
  Connection con = null;
  try{
    //execute query...
    con = _source.getConnection();
    Statement stmt = con.createStatement();
    //Business Rule: 'select' queries must not return results more than 2500
   	stmt.setMaxRows(2500);
	//stmt.setQueryTimeout(4); //wait for x seconds before query timeout...
    //execute generic sql query...
	long queryStartTime = 0;	
    //FIX 0.8a (UZI) Add (?s) in RE
	if(_source.isReadOnly() && query.matches("(?is)(ABORT|ALTER|ANALYZE|BEGIN|UPDATE|CHECKPOINT|CLUSTER|COMMENT|COMMIT|COPY|CREATE|DECLARE|DELETE|DROP|GRANT|REVOKE|INSERT|LOAD|LOCK|REINDEX|RESET|ROLLBACK|SAVEPOINT|SET|TRUNCATE|VACUUM).*")) {
	   status = false;
	   warningMessages += "<font size=\"2\" color=\"#FF0000\">Database is configured in read only mode. This operation is not allowed.</font><br>";
	}else {
	   queryStartTime = System.currentTimeMillis();
	   status = stmt.execute(query);
	   //retrive warnings...
	    SQLWarning warnings = stmt.getWarnings();
	    StringBuffer warningsStringBuffer = new StringBuffer();
	    while(warnings!=null){        
		  warningsStringBuffer.append(warnings.toString());
		  warningsStringBuffer.append("<br>");        
          warnings = warnings.getNextWarning();
        }
	
	    warningMessages += warningsStringBuffer.toString();
		long queryDiffTime = System.currentTimeMillis()- queryStartTime;//diff in ms

		if(status) {
		  //we have a result set
		  DashboardResultSetConverter converter = new DashboardResultSetConverter();
		  do{
			//convert resultset to HTML table
			html = converter.formattedResultSet(stmt.getResultSet());
			htmlList.add(html);//add resultset to array in case we have more then one resultset
			warningMessages += "<font size=\"1\" color=\"#000000\">Total query runtime: "+queryDiffTime+" ms.<br>"+ converter.getRecords()+" rows retrieved.</font><br>";
			if(converter.getRecords()==0) status = false; //defaults to Messages tab
		  }while(stmt.getMoreResults());
		  //TODO: fetch number of records retrieved
		 
		 
		  
		}else {
		  int count = stmt.getUpdateCount();
		  if( count <=0) {
			 warningMessages += "<font size=\"1\" color=\"#000000\">Query returned successfully with no result in "+ queryDiffTime +" ms.</font><br>";
		  }else {
			  warningMessages += "<font size=\"1\" color=\"#000000\">Query returned successfully: "+ count+" rows affected, "+ queryDiffTime +" ms execution time.</font><br>";
		  }
		}
	}   
	
 
   }catch(SQLException sqe){
   warningMessages += "<font size=\"2\" color=\"#FF0000\">" + sqe.getMessage()+"</font><br>";  
   status = false;//defaults to "Messages Window"
   }finally{
       if(con != null) {
           try{
	           con.close();
	       }catch(SQLException sqe){
	           //do nothing here...
	       }
       }
   }
   	warningMessages += "</font>";
}
%>
<style type="text/css">
<!--
.sectHead {
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	color: #FFFFFF;
	background-color: #3B6588;
	background-position: left;
	text-align: left;
}
.even {
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	color: #000000;
	background-color: #C5D4E4;
	text-align: left;
}
.odd {
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	color: #000000;
	background-color: #EEEEEE;
	text-align: left;
}
.layoutMain {
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	background-color: #03487F;
}

      .tab{
         color: navy;
         background-color: white;
         border: thin solid navy;
         position: absolute;
         width: 140;
         text-align: center;
         font: 9pt Verdana,sans-serif;
         z-index: 2;
         padding: 3;
         cursor: pointer;
         cursor: hand;
      }
      .panel{
	position: absolute;
	width: 95%;
	z-index: 1;
	height: 85%;
	visibility: hidden;
	font: 12pt Verdana,sans-serif;
	color: navy;
	border: thin solid navy;
	padding: 0;
	overflow: auto;

      }

-->
</style>
<jsp:include page="header.jsp"> 
<jsp:param name="title" value="iQuery Executor"/>
</jsp:include>
<script language="JavaScript">
   var currentPanel;
   
   function showPanel(panelNum) {
      //hide visible panel, show selected panel, 
      //set tab
      if (currentPanel != null) {
         hidePanel();
      }
      document.getElementById 
         ('panel'+panelNum).style.visibility = 'visible';
         currentPanel = panelNum;
         setState(panelNum);
   }
   
   function hidePanel() {
      //hide visible panel, unhilite tab
      document.getElementById
        ('panel'+currentPanel).style.visibility = 
         'hidden';
      document.getElementById
        ('tab'+currentPanel).style.backgroundColor = 
        '#ffffff';
      document.getElementById
        ('tab'+currentPanel).style.color = 'navy';
   }
   
   function setState(tabNum) {
      if (tabNum==currentPanel) {
         document.getElementById 
           ('tab'+tabNum).style.backgroundColor = 
           '#ddddff';
         document.getElementById
           ('tab'+tabNum).style.color = 'red';
      }
      else {
         document.getElementById
           ('tab'+tabNum).style.backgroundColor = 
           '#ffffff';
         document.getElementById
           ('tab'+tabNum).style.color = 'navy';
      }
   }
   
   function hover(tab) {
      tab.style.backgroundColor = 'ddddff';
   }

function OnSubmitForm()
{
  if(document.pressed == 'pdf')
  {
   document.form1.action ="iquery.pdf";
  }
  else
  if(document.pressed == 'Submit')
  {
    document.myform.action ="";
  }
  return true;
}

</script>
&nbsp;&nbsp;<i>i</i><font class="title">Query</font>
<hr size="1" color="#000000">
<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr> 
    <td align="left" valign="top"><form name="form1" method="post" action="" id="form1" onSubmit="return OnSubmitForm();">
        <table border="0" align="left" cellpadding="0" cellspacing="0">
          <tr> 
            <td align="left" valign="middle"><div align="right">Database</div></td>
            <td align="right" valign="top"> <div align="left"> 
                <select name="source" id="source" style="width:45%;" onChange="this.form.submit.click()">
                  <%
		  for(Iterator iter = DashboardAgent.getSourceIterator(); iter.hasNext();) {
		     Source __source = (Source)iter.next();
			 String dbName = __source.getName();

		  %>
                  <option value="<%=dbName%>"  <%=((source_name!=null && source_name.equalsIgnoreCase(dbName))?"selected":"")%>><%=dbName%></option>
			<%
		  } 
		 %>
                </select>
              </div></td>
          </tr>
          <tr> 
            <td width="70" align="left" valign="top"><div align="right">Query</div></td>
            <td width="397" align="left" valign="top"> 
                <textarea name="query" cols="60" rows="5" id="query"><%=query%></textarea>
			</td>
          </tr>
          <tr> 
            <td align="left" valign="top">&nbsp;</td>
            <td align="left" valign="top"><font color="#999999" size="2">Note: Results are restricted to 
                2500 records maximum.</font> </td>
          </tr>
          <tr align="center"> 
            <td>&nbsp;</td>
            <td><input type="submit" name="Submit" value="Submit" id="submit"></td>
          </tr>
        </table><a href="javascript:doSubmit();">
		<INPUT TYPE="image" src="images/pdf.gif" name="pdf" onClick="document.pressed=this.value" VALUE="pdf"></a>
      </form></td>
  </tr>
  <tr> 
    <td> 
<div style="background-color: transparent; position: relative; width: 100%; height: 300px; left: 20px;"> 
        <div id="tab1" class="tab" style="left:0px; top:0px;" 
      onClick = "showPanel(1);" 
      onMouseOver="hover(this);" 
      onMouseOut="setState(1)">Data output</div>
        <div id="tab2" class="tab" style="left:150px; top:0px;" 
      onClick = "showPanel(2);" 
      onMouseOver="hover(this);" 
      onMouseOut="setState(2)">Messages</div>
        <div id="panel1" class="panel" 	style="top: 22px;left: 0px;"> 
          <table width="100%" border="0" cellspacing="0" cellpadding="0">
            <%
	       for(int i=0; i<htmlList.size(); i++) {
	             String result = (String)htmlList.get(i);
	        %>
            <tr> 
              <td align="center" valign="top"><%=result%></td>
            </tr>
            <%
               }//for
           %>
          </table>
        </div>
        <div id="panel2" class="panel" style="top: 22px;left: 0px;"><%=warningMessages%></div>
      </div>	 
</td>
  </tr>
</table>
<%
if(request.getParameter("source") == null) {
 		Iterator iter = DashboardAgent.getSourceIterator(); 
		if(iter.hasNext()) {
		   _source = (Source)iter.next();
		    source_name = _source.getName();
		}
}
%>

<%
	if(source_name!=null) {
%>			 
<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td>
	<% if(DashboardAgent.getSource(source_name).isReadOnly()) { %> 
      <font size="1" color="#FF0000" face="Arial, Helvetica, sans-serif"><%="&nbsp;&nbsp;- The database " + source_name + " is configured in read-only mode."%></font><br>
	<% } //end if%>
	</td>
  </tr>
</table>
<%
 }//if
%>
<script type="text/javascript">
<!--
showPanel(<%= status?"1":"2" %>);
// -->

</script>
<jsp:include page="menu_end.jsp"/>