<%@ page language="java" buffer="8kb" autoFlush="true" isThreadSafe="true" info="Info string" isErrorPage="false"  %>
<%@ page import="java.util.*, java.text.*, java.sql.*,com.enterprisedb.dashboard.agent.*,javax.naming.*, javax.sql.DataSource, java.io.*" %>
<%!
static {
        try {
			Class.forName("com.edb.Driver");
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		}
}

static boolean in_process=false;
boolean includeInserts = true;
boolean includeUpdates = true;
boolean includeDeletes = true;
boolean includeSelects = true;
boolean includeOthers  = false;
boolean truncateTable = false;
boolean post81 = false;
String source_name = null;
Source mgmtsvr_source = null;
String mgmtsvr_config_file = null;
Connection mgmtsrvConn = null;
static boolean initialized = false;
//this array hold html to be displayed in case of errors
ArrayList htmlList = null;
ArrayList queryLoggingList = null;
String loggingEnabledResult = ""; //message for displaying if query logging is enabled or not
%>
<% try { %>
<%
	//Get connection for the mgmsrv for the edb_stmt_dump table
	//The DashboardDS environment entry is defined in web.xml. The jboss-web.xml points this entry to java:/DefaultDS
	//which is actually defined in enterprisedb-ds.xml for EnterpriseDB Management Server
	

		Context initContext = null;
		try {
			initContext = new InitialContext();
			Context envContext = (Context) initContext.lookup("java:/comp/env");
			DataSource ds = (DataSource) envContext.lookup("DashboardDS");
			mgmtsrvConn = ds.getConnection();
			mgmtsrvConn.setAutoCommit(false);

		} catch (NamingException e) {
			htmlList.add("<font size=\"2\" color=\"#FF0000\">" + e.getMessage()+"</font><br>");
		} catch (SQLException e) {
			htmlList.add("<font size=\"2\" color=\"#FF0000\">" + e.getMessage()+"</font><br>");
		}
%>


<% 
DashboardAgent.loadConfig(new java.io.File(getServletConfig().getServletContext().getRealPath("/WEB-INF/configure.xml")));
//get Source database information from DashboardAgent
source_name = request.getParameter("source");
Source _source = DashboardAgent.getSource(source_name);

String loggingEnabledQuery = "SELECT name,setting FROM pg_settings WHERE UPPER(name) = 'LOG_MIN_DURATION_STATEMENT'"; 

String logFileName = "";
String modification = "";
long size = 0;
long queryLimit = 100; 
long no_of_runs ;
long start_offset = 0; 
long f = 0 ;
long limit = 0;
long  iteration_size = 3145728 ; //We will do 3 MB batches
ResultSet rsReportData = null;
String sql = null;
Connection con = null;
ArrayList logFileList = new ArrayList();
ArrayList logSizeList = new ArrayList();
ArrayList logModificationList = new ArrayList();
//Format the duration to 3 decimal places
DecimalFormat durationFormat = new DecimalFormat();
durationFormat.setMaximumFractionDigits(3);
durationFormat.setDecimalSeparatorAlwaysShown(false);
//this html will be our result...
//String logFileContents="";
String warningMessages="<font size=\"2\" color=\"#000000\">";

//This includes different user parameters for parsing various types of queries
boolean status = false;
//Default the group by expression for query to the statement
String  groupByExpression = "total_execution_time";

htmlList = new ArrayList();
 //if _source = null, pull first source
if(_source == null) {
 		Iterator iter = DashboardAgent.getSourceIterator(); 
		if(iter.hasNext()) {
		   _source = (Source)iter.next();
		   source_name = _source.getName();
		}
}

//we only want to continue if we have something in query parameter and source exist
if(_source != null) {
  try{
    //execute query...
    con =_source.getConnection();
	
	//we only want to execute if our version 8.1...
	DatabaseMetaData mtDB = con.getMetaData();
			
	int dbMajorVersion = mtDB.getDatabaseMajorVersion();
	int dbMinorVersion = mtDB.getDatabaseMinorVersion();
	
	if(dbMajorVersion>=8 && dbMinorVersion>=1)
		post81=true;
	else
		post81=false;
	
	//only proceed if we are dealing with 8.1 database...
	if(post81) {
		status = true;
		Statement lfStatement = con.createStatement();
		ResultSet rslf = lfStatement.executeQuery("select filename,"+
		"(pg_stat_file(current_setting('log_directory')||'/'||filename)).modification as modification, "+
		"(pg_stat_file(current_setting('log_directory')||'/'||filename)).size as size " + 
		"from pg_ls_dir(current_setting('log_directory')) as filename "+
		"order by modification desc");
		while(rslf.next()) {
		    logFileList.add(rslf.getString(1));
			long ls =rslf.getLong(3); 
			logSizeList.add(new Long(ls));
			logModificationList.add(rslf.getString(2));
		}	    
		rslf.close();
		lfStatement.close();
		
		logFileName = request.getParameter("logFileName") ;
		if(logFileName == null || !request.getParameter("_source").equalsIgnoreCase(source_name)) {
		//pick the first Log from from our list...
		   if(logFileList.size() > 0) {
		       logFileName = (String)logFileList.get(0);
		   }
		}
		
					
		//After the user has submitted the form for the first time check which types of queries and top N queries the user wants to view
		if((request.getParameter("_refresh") != null && request.getParameter("_refresh").equals("yes")) || request.getParameter("reparse")!=null) {
			//1. Check for Insert statements
			includeInserts = request.getParameter("chkInserts")!=null && request.getParameter("chkInserts").equalsIgnoreCase("chkInserts") ? true : false;
		
			//2. Check for Update Statements
			includeUpdates = request.getParameter("chkUpdates")!=null && request.getParameter("chkUpdates").equalsIgnoreCase("chkUpdates") ? true : false;
		
			//3. Check for Delete Statements
			includeDeletes = request.getParameter("chkDeletes")!=null && request.getParameter("chkDeletes").equalsIgnoreCase("chkDeletes") ? true : false;			
			
			//4. Check for Select Statements
			includeSelects = request.getParameter("chkSelects")!=null && request.getParameter("chkSelects").equalsIgnoreCase("chkSelects") ? true : false;			
			
			//5. Check for all Other Statements
			includeOthers = request.getParameter("chkOthers")!=null && request.getParameter("chkOthers").equalsIgnoreCase("chkOthers") ? true : false;			
						
			//Check for top N queries 
			queryLimit = request.getParameter("numQueries")!=null && request.getParameter("numQueries").trim().length() >0 ? Integer.parseInt(request.getParameter("numQueries")) : 100;
			
			//Group by the selected drop down or default to the statement if empty
			groupByExpression = request.getParameter("selectGroupBy")!=null ? request.getParameter("selectGroupBy") : "number_of_executions"; 
			
			//Whether to just truncate the table 
			truncateTable = request.getParameter("truncTable")!=null && request.getParameter("truncTable").equalsIgnoreCase("yes") ? true : false;
			
		} //end if(_refresh)
			
			//System.out.println(request.getParameter("reparse"));
			//if(request.getParameter("_refresh")!=null && request.getParameter("_refresh").equals("yes")) {
			sql = null;
			if(request.getParameter("_refresh")!=null && request.getParameter("_refresh").equals("yes") && !truncateTable) {
				//System.out.println("Reparse");
				int x = logFileList.indexOf(logFileName);
				size = ((Long)logSizeList.get(x)).longValue();
				modification = (String)logModificationList.get(x);
				f = 0;
				start_offset=0;
				
				while (limit != size) {	
						  
				  //start_offset = (f * 1048576) ; // set offset to start of next 1 MB
				  
				  if (( size - start_offset ) > iteration_size) {
					  limit = iteration_size ; 
				  }
				  else
				  {
					  limit = size ;
				  }
				  //Read 1 MB starting from Offset
			  
			  String query = "SELECT pg_read_file(current_setting('log_directory')||'/'||'"+ logFileName+"', " + start_offset + ", " + limit + ");";
			  Statement stmt = con.createStatement();
			  ResultSet rs = stmt.executeQuery(query);
		
			  //Do the query parsing once we read the contents	
			  if(rs.next() && _source!=null) {
				String logFileContents = rs.getString("pg_read_file");
				//chop off last LOG statement coz it might be partial...will read it off in the next cycle as the start
				String logFileContents_2 = new String(logFileContents.substring(0,logFileContents.lastIndexOf("LOG:"))) ;
	
				start_offset = ((start_offset+limit )-(logFileContents.length() - logFileContents.lastIndexOf("LOG:")));
				stmt.close();
				rs.close();
				
				String[] logLines = logFileContents.split("\n"); //Split on the basis of each new line
					if(f==0) {
						truncateTable(mgmtsrvConn);
					}
					parseDumpLogFile(logLines);	
					f++;
					sql = getSelectQuery(includeSelects, includeInserts, includeUpdates, includeDeletes, includeOthers, groupByExpression, queryLimit);
			} //if rs.next
		  } //while
		} //if request.getParameter("reparse")
		else if(request.getParameter("reparse")!=null && request.getParameter("reparse").equals("no")){
			sql = getSelectQuery(includeSelects, includeInserts, includeUpdates, includeDeletes, includeOthers, groupByExpression, queryLimit);					
		}
		//If a log file was selected from the drop down truncate the table and empty out the existing sql query
		if (truncateTable){
			sql = null;
			truncateTable(mgmtsrvConn);
	   }
	   
	   	//Enabling/disabling Query Logging
		String name = "";
		String setting = "";
	
		//Check if the user has pressed the Apply button for enabling/disabling Query Logging		
		if(request.getParameter("dash_log_min_duration_statement")!=null && request.getParameter("applysettings") != null && request.getParameter("applysettings").equals("yes")) {
			 String value = request.getParameter("dash_log_min_duration_statement");
			 name = "log_min_duration_statement";
			 setting = value.equalsIgnoreCase("on") ? "0" : "-1";
	
			 String updateSettings = "ALTER DATABASE " + _source.getDatabase() + " SET log_min_duration_statement = " + setting;

			//System.out.println(updateSettings);
			
			 try {
				if(con==null)
					 con = _source.getConnection();
				 Statement stmt = con.createStatement();
				 stmt.execute(updateSettings);
				 stmt.close();
				 }catch(SQLException sqe) {
				  htmlList.add("<font size=\"2\" color=\"#FF0000\">" + sqe.getMessage()+"</font><br>");
				 }
			} //end if
			else {
			//check if query logging is enabled or not
			Statement queryLoggingStmt = con.createStatement();
			ResultSet rsQueryLogging = queryLoggingStmt.executeQuery(loggingEnabledQuery);
	
	
			if(rsQueryLogging.next()) {
				name = rsQueryLogging.getString("name");
				setting = rsQueryLogging.getString("setting");
			} //end if
		  } // end else	   	     
		  if(_source!=null)
			  queryLoggingHtml(name,setting,_source.isReadOnly());
    }//post_81
	
   }catch(SQLException sqe){
   htmlList.add("<font size=\"2\" color=\"#FF0000\">" + sqe.getMessage()+"</font><br>");  
   status = false;
   }
   finally {
   	if(con!=null)
		try {
			con.close();
		}
		catch(Exception exp) { htmlList.add("<font size=\"2\" color=\"#FF0000\">" + exp.getMessage()+"</font><br>"); }
   }

}
%>

<%!
//This function generates the HTML for the Query Logging enabling/disabling option at the top of the page
public void queryLoggingHtml(String name, String setting, boolean readOnly)
{ 
	loggingEnabledResult = setting.equalsIgnoreCase("0") ? "Query Logging is currently enabled" : "Query Logging is currently disabled";
	//String readOnlyResult = readOnly ? "<tr><td colspan=\"2\"><font size=\"1\" color=\"#FF0000\" face=\"Arial, Helvetica, sans-serif\">&nbsp;- The database " + source_name + " is configured in read-only mode.
	queryLoggingList = new ArrayList();
	StringBuffer htmBuf = new StringBuffer();
	htmBuf.append("<table width=\"220\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
	String disabled = readOnly ? "DISABLED":"";				
	htmBuf.append("<tr><td>Query Logging</td><td align=\"right\"><input name=\""+ name +"\" type=\"checkbox\" onClick=\"toggle(this)\" value=\""+ 
	   setting+"\" "+ (setting.equalsIgnoreCase("0")?"CHECKED":"") +" "+ disabled+"><input type=\"hidden\" name=\"dash_log_min_duration_statement\" value=\""+setting+"\"></td>"+
	   "<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type=\"submit\" id=\"apply\" value=\"Apply\"  onClick=\"document.form1.applysettings.value='yes'\"></td></tr>" + "<tr><td></td></tr>");
	   		
	htmBuf.append("</table>");

	queryLoggingList.add(htmBuf.toString());
}

public void truncateTable(Connection mgmtsrvConn)
{
	if(mgmtsrvConn!=null) {
		try {
			Statement truncateStatement = mgmtsrvConn.createStatement();
			truncateStatement.execute("TRUNCATE TABLE edb_stmt_dump");
            truncateStatement.close();
		}
		catch(SQLException sqe) { htmlList.add("<font size=\"2\" color=\"#FF0000\">There was an error truncating the edb_stmt_dump table</font><br>"); } 
	}
}

public String getSelectQuery(boolean includeSelects, boolean includeInserts, boolean includeUpdates, 
							 boolean includeDeletes, boolean includeOthers, String groupByExpression, long queryLimit)
{
	String sql = 	" SELECT count(*) as number_of_executions, sum(stmt_duration) as total_execution_time, "
				+	" AVG(stmt_duration) as avg_execution_time, stmt as statement "
				+	" FROM edb_stmt_dump"
				+ 	" WHERE stmt_type IN (";
				
	//This is to prevent the application from crashing in the event we don't enter any type of statement to parse
	if(!includeSelects && !includeInserts && !includeUpdates && !includeDeletes && !includeOthers)
		sql += "'T'"; //Place a dummy value to return nothing
			
	if(includeSelects)
		sql += (includeInserts || includeDeletes || includeUpdates || includeOthers) ? "'S'," : "'S'";						
	if(includeUpdates) 
		sql += (includeInserts || includeDeletes || includeOthers) ? "'U'," : "'U'";
	if(includeDeletes)
		sql += (includeInserts || includeOthers) ? "'D'," : "'D'";
	if(includeInserts)
		sql += includeOthers ? "'I'," : "'I'";
	if(includeOthers)
		sql += "'O'";		
	
	sql += ")";
	if (!includeOthers) {
	sql +=  " AND stmt NOT LIKE ('% FROM pg_%') "+
			" AND stmt NOT LIKE ('% from pg_%') "+
          	" AND stmt NOT LIKE ('%select edb_procoid_debug(%') "+
          	" AND stmt NOT LIKE ('%pg_read_file(%') "+
          	" AND stmt NOT LIKE ('1]%') " ;
	}
	sql += " GROUP BY stmt, stmt_type ";
	sql += " ORDER BY " + groupByExpression + " desc ";
	sql += " LIMIT " + queryLimit + ";";
	//System.out.println("sql..."+sql);
	return sql;
}

public void parseDumpLogFile(String[] logLines)
{
	//String[] logLines = fileContents.split("\n"); //Split on the basis of each new line			
	int currentLineNumber=0;
	
	if(mgmtsrvConn!=null && logLines.length>0) {
		try {
			//TODO: TURN AUTOCOMMIT OFF HERE
			PreparedStatement stmtInsert = mgmtsrvConn.prepareStatement("INSERT INTO edb_stmt_dump(stmt,stmt_duration,stmt_type) VALUES(?,?,?)");
						
			do {
				String currentLine = logLines[currentLineNumber];
				//we only want to parse the log lines that have an actual SQL statement and its respective duration and ignore any comments
				if(currentLine.indexOf("duration:")!=-1 && currentLine.indexOf("statement:")!=-1 && currentLine.indexOf("LOG:")!=-1  && currentLine.indexOf("--")==-1) {
					boolean blnRead=true;
		
					//If the query is split over multiple lines append the query to the previous line
					while(blnRead && currentLineNumber+1<logLines.length) {
						String nextLine = logLines[currentLineNumber+1];
						if((nextLine.indexOf("\t")!=-1)) {								
							blnRead=true;
							currentLine+=nextLine;
							currentLineNumber++;							
						}
						else {
							blnRead = false;
						}
					} //end while
					//System.out.println("test..."+currentLine);
					double duration = 0.0;
					String type = "";
					String statement = "";
					//System.out.println("Current Line: " + currentLine);							
					try {
						duration = Double.parseDouble((currentLine.substring(currentLine.indexOf("duration")+10,currentLine.indexOf("ms"))).trim());
						statement = (currentLine.substring(currentLine.lastIndexOf("statement")+11)).trim();
					}//try
					catch(NumberFormatException exp) { exp.printStackTrace(); }
										
					if(statement.toUpperCase().indexOf("PREPARE")!=-1) {
						statement = statement.substring(statement.indexOf("PREPARE: ")+9,statement.lastIndexOf("]") == -1 ? statement.length() : statement.lastIndexOf("]")).trim();
					}
		
					if(statement.toUpperCase().indexOf("SELECT")!=-1 && includeSelects) {
						type = "S";
					}
					else if(statement.toUpperCase().indexOf("UPDATE")!=-1 && includeUpdates) {
						type = "U";
					}	
					else if(statement.toUpperCase().indexOf("INSERT")!=-1 && includeInserts) {															
						type = "I";
					}
					else if(statement.toUpperCase().indexOf("DELETE")!=-1 && includeDeletes){								
						type = "D";
					}
					else if(statement.toUpperCase().indexOf("SELECT")==-1  && statement.toUpperCase().indexOf("DELETE")==-1 && statement.toUpperCase().indexOf("INSERT")==-1 && statement.toUpperCase().indexOf("UPDATE")==-1) {
						
						type = "O";
					}
	
					stmtInsert.setString(1,statement);
					stmtInsert.setDouble(2,duration);
					stmtInsert.setString(3,type);
					stmtInsert.addBatch();
		
					//End of Insert
				} //end if
				currentLineNumber++;								
			} //end do			
			while(currentLineNumber<logLines.length);
		
			stmtInsert.executeBatch();
			//mgmtsrvConn.setAutoCommit(true);
			mgmtsrvConn.commit();
			stmtInsert.close();
			stmtInsert.close();
			
		} catch(SQLException sqe) { htmlList.add("<font size=\"2\" color=\"#FF0000\">There was an error dumping the log file data</font><br>"); }
	} //end if	
}
%>
<script language="Javascript">
//reset the mutex to show no processing is being done
function reset_mutex()
{
in_process=false;
}
//-------------------------------------------------------------------
// isBlank(value)
//   Returns true if value is blank, false otherwise
//-------------------------------------------------------------------

function isBlank(val){
    if(val==null){
	   return true;
	}
	for(var i=0;i<val.length;i++){
	    if((val.charAt(i)!=' ')&&(val.charAt(i)!="\t")&&(val.charAt(i)!="\n")&&(val.charAt(i)!="\r")){
		    return false;
		}
	}
	return true;
}
//-------------------------------------------------------------------
// isDigit(value)
//   Returns true if value is a 1-character digit
//-------------------------------------------------------------------
function isDigit(num) {
	if (num.length>1){return false;}
	var string="1234567890";
	if (string.indexOf(num)!=-1){return true;}
	return false;
}

//-------------------------------------------------------------------
// isInteger(value)
//   Returns true if value contains all digits
//-------------------------------------------------------------------
function isInteger(val){
	//if (isBlank(val)){return false;}
	if(!isBlank(val)) {
		for(var i=0;i<val.length;i++){
			if(!isDigit(val.charAt(i))){return false;}
			}
		}
	return true;
}

function submitForm()
{
	document.form1.aSubmit.click();
	document.form1.numQueries.value = null;
}

function OnSubmitForm(){
  if(isInteger(document.form1.numQueries.value)) {
	  if(document.pressed == 'pdf')
	  {
	  	document.pressed = "";
	   	document.form1.action ="query_profiler.pdf";
	  }
	  else if(document.pressed == 'logFileName')
	  {
	 	 document.myform.action ="query_parser.jsp?trunc=true";	
	  }
	  else if(document.pressed == 'Submit')
	  {
		document.myform.action ="";
	  }
	  return true;
  }
  else 
  	return false;
}
function truncateTable() {
	document.form1.truncTable.value = 'yes';
	document.form1.aSubmit.click();
}

function toggle(cb) { //v2.0
var f = document.form1;
if(cb.checked) {
   f.elements['dash_' + cb.name].value = 'ON';
}else {
f.elements['dash_' + cb.name].value = 'OFF';
}   
//alert(f.elements['dash_' + cb.name].value); 
}
</script>
<jsp:include page="header.jsp"> 
<jsp:param name="title" value="Query Profiler"/>
</jsp:include>
<form name="form1" method="post" action="" onsubmit="return OnSubmitForm();">
&nbsp;&nbsp;<font class="title">Query Profiler</font>
  <table width="1155" border="0" align="left" cellpadding="2" cellspacing="2">
    <tr> 
      <td width="1141" align="left" valign="top" colspan="3"><hr size="1" color="#000000"></td>
    </tr>
    <tr> 
      <td width="133" align="left" valign="top">&nbsp;Server &amp; Port</td>
      <td width="258" align="right" valign="top"> <div align="left"> 
	  
	  <select name="source" id="select" onChange="this.form.aSubmit.click()">
                        <%
		  for(Iterator iter = DashboardAgent.getSourceIterator(); iter.hasNext();) {
		     Source __source = (Source)iter.next();
			 String dbName = __source.getName();
		  %>
                        <option value="<%=dbName%>" <%=((source_name!=null && source_name.equalsIgnoreCase(dbName))?"selected":"")%>><%=dbName%></option>
                        <%
		  }
		  %>
                      </select>
 
        </div>
        <input name="_source" type="hidden" value="<%=source_name%>"></td>
      <td width="744" align="left" valign="top"> &nbsp;&nbsp;&nbsp;
		</td>
    </tr>
   <tr>
  	  <td colspan="3" valign="top" width="1147">
		<table width="100%" border="0" align="left" cellpadding="2" cellspacing="0">
		<tr> 
		  <% String result = (String)queryLoggingList.get(0); %>
		  <td align="left" valign="top"><%=result%></td>
		  <td>&nbsp;</td>
		</tr>
		<tr>
			<td colspan="2"><font size="1" color="#FF0000" face="Arial, Helvetica, sans-serif">&nbsp;<%=loggingEnabledResult%></font></td>
		</tr>
		  <tr>
			<td colspan="2">
			<% if(DashboardAgent.getSource(source_name).isReadOnly()) { %> 
			  <font size="1" color="#FF0000" face="Arial, Helvetica, sans-serif"><%="&nbsp;The database " + source_name + " is configured in read-only mode."%></font><br>
			<% } //end if%>
			</td>
		  </tr>		
	   <tr>
	    	<td colspan="2"><hr size="1" color="#000000"></td>
	   </tr>
	</table>
	</td>
  </tr>
    <%
		 if(post81) {
	%>
    <tr> 
      <td align="left" valign="middle" width="133">&nbsp;Log Name:</td>
      <td align="right" valign="top" width="258"><div align="left"> 
          <select name="logFileName" size="1" onChange="javascript:truncateTable();">
            <%for(int j=0;j<logFileList.size();j++) { String _logFile = (String)logFileList.get(j); %>
            <option value="<%=_logFile%>" <%=_logFile.equalsIgnoreCase(logFileName)?"selected":""%>><%=_logFile%></option>
            <%}%>
          </select>
          <input name="_logFileName" type="hidden" value="<%=logFileName%>">
        </div></td>
      <td align="left" valign="top" width="744">
      <input name="aSubmit" type="submit" id="aSubmit" value="Parse Log &amp; Run Report"  onClick="document.form1._refresh.value='yes'">&nbsp; &nbsp; <a href="javascript:doSubmit();" target="_blank"> 
        <input type="image" src="images/pdf.gif" name="I1" onClick="document.pressed=this.value" value="pdf" width="16" height="16"></a></td>
    </tr>
    <tr> 
      <td align="left" valign="middle" width="133">&nbsp;Query Limit</td>
      <td align="right" valign="top" width="258"><div align="left"> 
          <input name="numQueries" type="text" id="numQueries" size="10" maxlength="4" value=<%=queryLimit+""%>>
        </div></td>
      <td align="left" valign="top" width="744"> 
      <input name="refresh" type="submit" id="refresh" value="Refresh &amp; Run Report     "  onClick="document.form1.reparse.value='no'"></td>
    </tr>
    <tr> 
      <td colspan="2" align="left" valign="top" width="397"> 
	    <div align="left"> 
          <table width="395" border="0">
            <tr> 
              <td width="130">Include Inserts</td>
              <td width="255"><input name="chkInserts" type="checkbox" value="chkInserts" <%=includeInserts ? "CHECKED" : ""%>> </td>
            </tr>
            <tr> 
              <td width="130">Include Updates</td>
              <td width="255"><input name="chkUpdates" type="checkbox" value="chkUpdates" <%=includeUpdates ? "CHECKED" : "" %>> </td>
            </tr>
            <tr> 
              <td width="130">Include Deletes</td>
              <td width="255"><input name="chkDeletes" type="checkbox" value="chkDeletes" <%=includeDeletes ? "CHECKED" : ""%>> </td>
            </tr>
            <tr> 
              <td width="130">Include Selects</td>
              <td width="255"><input name="chkSelects" type="checkbox" value="chkSelects" <%=includeSelects ? "CHECKED" : "" %>> </td>
            </tr>
            <tr> 
              <td width="130">Include Others</td>
              <td width="255"><input name="chkOthers" type="checkbox" value="chkOthers" <%=includeOthers? "CHECKED" : "" %>> </td>
            </tr>
            <tr> 
              <td width="130">Order By</td>
              <td width="255"><select name="selectGroupBy" id="selectGroupBy">
                  <option value="total_execution_time" <%=groupByExpression.equals("total_execution_time") ? "SELECTED" : ""%>>Total 
                  Execution Time</option>
                  <option value="number_of_executions" <%=groupByExpression.equals("number_of_executions") ? "SELECTED" : ""%>>Statement 
                  Count</option>
                  <option value="avg_execution_time" <%=groupByExpression.equals("avg_execution_time") ? "SELECTED" : ""%>>Average 
                  Execution Time</option>
                </select></td>
            </tr>
            <tr> 
              <td width="130">&nbsp; </td>
              <td width="255"> <input type="hidden" name="query" id="query" value="<%=sql%>"> 
                <input name="reparse" type="hidden" value=""> <input type="hidden" name="truncTable" id="truncTable"  value=""> 
				<input name="applysettings" type="hidden" value="" id="applysettings">
				<input name="_refresh" type="hidden" value="">
              </td>
            </tr>
          </table>
        </div>
        </td>
      <% } //end if post81%>
      <td align="left" valign="bottom" width="744">&nbsp; 
      <p>&nbsp;</p>
      <p>&nbsp;</p>
      <p>&nbsp;</p>
      <p>&nbsp;</td>
    </tr>
	<tr> 
      <td valign="top" colspan="3" width="1147">
	    <table width="100%" border="0">
  	<tr>
		<td>
		<table width="100%" border="0" cellspacing="0" cellpadding="0">
  		<tr> 
   		 <td valign="top"> 
		 <table width="100%" border="0" cellspacing="0" cellpadding="0">
			  <!-- The result...whatever it is -->
			  <%
				if(post81) {
					if(mgmtsrvConn!=null && sql!=null) {
						Statement stmtSelect = mgmtsrvConn.createStatement();
						try {				
							rsReportData = stmtSelect.executeQuery(sql);
			  %>
	
			  <tr>
				<td colspan="2">
					<table class="queryList">
						<tr>
							<td colspan="5"><font size="3"><b>Results</b></font></td>
						</tr>
						<tr>
							<th>Rank</th>					
							<th>Count</th>
							<th>Total <br>Execution Time(ms)</th>						
							<th>Average <br>Execution Time(ms)</th>												
							<th>Query</th>
						</tr>
						<% 
							int 	counter = 1; 
							
							while(rsReportData.next()) { %>
						<% 
							int 	totalStatementCount 		= 	rsReportData.getInt("number_of_executions");//	sortedStatements[i].getValue().getLogStatementCount();
							double 	totalStatementDuration 		= 	rsReportData.getDouble("total_execution_time");
							double 	averageStatementDuration 	= 	rsReportData.getDouble("avg_execution_time");	
							String 	sqlStatement				= 	rsReportData.getString("statement");
								
						%>
						<% if(counter%2==0) { %>
							<tr class="row0">					
								<td class="center top"><%=counter%></td>
								<td class="relevantInformation top center"><%=totalStatementCount%></div></td>						
								<td class="relevantInformation top center"><%=durationFormat.format(totalStatementDuration)%></div></td>
								<td class="relevantInformation top center"><%=durationFormat.format(averageStatementDuration)%></div></td>
								<td class="code"><%=sqlStatement%></td>									
						   </tr>
						 <% } else { %>
							<tr class="row1">						
								<td class="center top"><%=counter%></td>
								<td class="relevantInformation top center"><%=totalStatementCount%></div></td>																					
								<td class="relevantInformation top center"><%=durationFormat.format(totalStatementDuration)%></div></td>
								<td class="relevantInformation top center"><%=durationFormat.format(averageStatementDuration)%></div></td>
								<td class="code"><%=sqlStatement%></td>									
						   </tr>							 
						 <% } 
							counter++; //increment the rank counter  
						%>

						<% } //end while%>					
					</table>
					<%
					} catch(SQLException sq) { htmlList.add("<font size=\"2\" color=\"#FF0000\">" + sq.getMessage()+"</font><br>"); }			
					finally{
						stmtSelect.close();
						
					   }
					 }				
					%>	
				</td>
			  </tr>
			  <tr> 
				<td align="left" valign="top">&nbsp;&nbsp;</td>
				<%
						if(status) {
				%>
				<td  align="left" valign="top">
				  <br>
				<%
				  }else {
			   %>
				<td width="2%" align="left" valign="top"><div align="left"><font color="#FF0000" size="2"></font></div></td>
				<%
				 }//else status
			   %>
			  </tr>
			  <%
				   } else {
			   %>
			  <tr> 
				<td align="left" valign="top">&nbsp;</td>
				<td align="left" valign="top"><font color="#FF0000" size="2" face="Arial, Helvetica, sans-serif">&nbsp;&nbsp;&nbsp;&nbsp;You 
				  must be running EnterpriseDB/PostgreSQL 8.1 to run Query Profiler.</font></td>
			  </tr>
			  <%
				 }
			   %>
			</table>
		    </td>
		  </tr>
		</table>
		</td>
	</tr>
  </table>	  
  <!-- End inner table -->
	  </td>
	</tr>
	
	<tr>
		<td colspan="2" width="397">
		 <table border="0" width="100%">
		    <%
	       for(int i=0; i<htmlList.size(); i++) {
	            String error = (String)htmlList.get(i);
	        %>
                <tr> 
                  <td align="center" valign="top"><%=error%></td>
                </tr>
                <%
               }//for
           %>
		   </table>
		</td>
		<td width="744">&nbsp;</td>
	</tr>
	
	<tr>
		<td colspan="3" width="1147">
		<jsp:include page="menu_end.jsp"/>
		</td>
	</tr>
  </table>

  </form>
<%}
catch(Exception ex){htmlList.add("<font size=\"2\" color=\"#FF0000\">" + ex.getMessage()+"</font><br>");}
finally {
	if(mgmtsrvConn!=null)
		try {
			mgmtsrvConn.close();
		}
		catch(SQLException sqe) {
			htmlList.add("<font size=\"2\" color=\"#FF0000\">" + sqe.getMessage()+"</font><br>");
		}
}
%>


<%
in_process=false;
%>