/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.util;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.NodeDBConnectionInfo;
import com.edb.gridsql.metadata.SysLogin;
import com.edb.gridsql.util.DbGateway;
import com.edb.gridsql.util.PasswordPrompt;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Vector;

public class CreateMdDb {
    private static String osUsername;
    private static String osPassword;
    private static String fileListString;
    private static Vector<String> fileList;
    private static boolean isManual;
    private static HashMap<String, String> valueMap;
    private static final String[] createStatements;
    private static Connection conn;

    public static void main(String[] stringArray) throws IOException {
        fileList = new Vector();
        try {
            CreateMdDb.processArgs(stringArray);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            System.err.println("Parameters:  [-i initscript] [-m] [-u username] [-p password]");
            System.exit(1);
        }
        NodeDBConnectionInfo nodeDBConnectionInfo = MetaData.getMetadataDBConnectionInfo();
        DbGateway dbGateway = new DbGateway();
        if (!isManual) {
            dbGateway.createDbOnNodes(valueMap, new NodeDBConnectionInfo[]{nodeDBConnectionInfo});
        } else {
            dbGateway.populateValueMap(nodeDBConnectionInfo, valueMap);
        }
        if (fileList.size() > 0 && !isManual) {
            try {
                dbGateway.wait(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int i = 0; i < fileList.size(); ++i) {
                String string = fileList.elementAt(i);
                valueMap.put("inputfile", string);
                try {
                    dbGateway.execScriptOnNodes(valueMap, new NodeDBConnectionInfo[]{nodeDBConnectionInfo});
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("Error executing script: " + exception.getMessage());
                }
            }
        }
        conn = CreateMdDb.getConnection(dbGateway);
        CreateMdDb.createSchema(dbGateway);
        CreateMdDb.createInitialUser(osUsername, osPassword);
        System.exit(0);
    }

    private static void checkDriver(String string) {
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XDBServerException("Couln't find driver class: " + string);
        }
    }

    private static Connection getConnection(DbGateway dbGateway) {
        Connection connection = null;
        CreateMdDb.checkDriver(Property.get((String)"xdb.metadata.jdbcdriver", (String)Props.XDB_DEFAULT_JDBCDRIVER));
        String string = Property.get((String)"xdb.metadata.jdbcstring", (String)Props.XDB_DEFAULT_JDBCSTRING);
        string = ParseCmdLine.substitute((String)string, valueMap);
        try {
            connection = DriverManager.getConnection(string);
        }
        catch (SQLException sQLException) {
            try {
                connection = DriverManager.getConnection(string, Property.get((String)"xdb.metadata.dbusername", (String)Props.XDB_DEFAULT_DBUSER), Property.get((String)"xdb.metadata.dbpassword", (String)Props.XDB_DEFAULT_DBPASSWORD));
                connection.setAutoCommit(false);
            }
            catch (SQLException sQLException2) {
                throw new XDBServerException("Could not connect to the database server", (Exception)sQLException2);
            }
        }
        if (connection == null) {
            throw new XDBServerException("Could not initialize connection.: Please check if the underlyingdatabase is running on the System");
        }
        return connection;
    }

    private static void createSchema(DbGateway dbGateway) {
        int n = 0;
        try {
            Statement statement = conn.createStatement();
            for (n = 0; n < createStatements.length; ++n) {
                statement.executeUpdate(createStatements[n]);
                System.out.println("Executed Statement: " + createStatements[n].toString());
            }
            conn.commit();
        }
        catch (SQLException sQLException) {
            System.err.println("Could not execute: statement : " + createStatements[n]);
            System.err.println(sQLException.getErrorCode() + " :  " + sQLException.getMessage());
            try {
                conn.rollback();
            }
            catch (SQLException sQLException2) {
                sQLException.setNextException(sQLException2);
                throw new XDBServerException("The Rollback  also failed - Please check your connection after executionfailuer", (Exception)sQLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createInitialUser(String object, String string) {
        Object object2;
        Object object3;
        if (object == null) {
            object = System.getProperty("user.name");
            System.out.print("Enter username [" + (String)object + "]: ");
            object3 = new BufferedReader(new InputStreamReader(System.in));
            try {
                object2 = ((BufferedReader)object3).readLine().trim();
                if (((String)object2).length() > 0) {
                    object = object2;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new XDBServerException("I/O error while reading user input", (Exception)iOException);
            }
        }
        while (string == null) {
            try {
                string = PasswordPrompt.getPassword("Enter new password for " + (String)object + ": ");
                if (string.equals(object3 = PasswordPrompt.getPassword("Confirm password for " + (String)object + ":  "))) continue;
                string = null;
                System.out.print("Passwords do not match");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new XDBServerException("I/O error while reading user input", (Exception)iOException);
            }
        }
        try {
            int n;
            object2 = conn.createStatement();
            ResultSet resultSet = object2.executeQuery("SELECT max(userid) FROM xsysusers");
            try {
                resultSet.next();
                n = resultSet.getInt(1) + 1;
            }
            finally {
                resultSet.close();
            }
            PreparedStatement preparedStatement = conn.prepareStatement("INSERT INTO xsysusers (userid, username, userpwd, usertype) VALUES (?, ?, ?, ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, (String)object);
            preparedStatement.setString(3, SysLogin.encryptPassword((String)string));
            preparedStatement.setString(4, "DBA");
            if (preparedStatement.executeUpdate() != 1) {
                XDBServerException xDBServerException = new XDBServerException("Failed to insert row into \"xsysusers\"");
                throw xDBServerException;
            }
            conn.commit();
            System.out.println("User " + (String)object + " is created");
        }
        catch (SQLException sQLException) {
            System.err.println("Failed to create initial user");
            sQLException.printStackTrace();
        }
    }

    public static void processArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].compareTo("-i") == 0) {
                fileListString = stringArray[++i];
                continue;
            }
            if (stringArray[i].compareTo("-u") == 0) {
                osUsername = stringArray[++i];
                valueMap.put("osusername", osUsername);
                continue;
            }
            if (stringArray[i].compareTo("-p") == 0) {
                osPassword = stringArray[++i];
                valueMap.put("ospassword", osPassword);
                continue;
            }
            if (stringArray[i].compareTo("-m") == 0) {
                isManual = true;
                continue;
            }
            throw new XDBServerException("unknown argument " + stringArray[i]);
        }
        String string = fileListString;
        int n = 0;
        if (string != null) {
            while (!isManual && n < string.length()) {
                int n2 = string.indexOf(",", n);
                String string2 = n2 >= 0 ? string.substring(n, n2) : string.substring(n);
                File file = new File(string2);
                if (!file.exists()) {
                    throw new XDBServerException("File " + string2 + " not found.");
                }
                fileList.addElement(string2);
                if (n2 < 0) break;
                n = n2 + 1;
            }
        }
    }

    static {
        isManual = false;
        valueMap = new HashMap();
        createStatements = new String[]{"create table xsystablespaces ( tablespaceid int not null, tablespacename varchar(255) not null, ownerid int not null, primary key(tablespaceid))", "create unique index idx_xsystablespaces_1 on xsystablespaces (tablespacename)", "create table xsystablespacelocs ( tablespacelocid int not null, tablespaceid int not null, filepath varchar(1024) not null, nodeid int not null, primary key(tablespacelocid))", "create unique index idx_xsystablespacelocs_1 on xsystablespacelocs (tablespaceid, nodeid)", "alter table xsystablespacelocs add foreign key (tablespaceid) references xsystablespaces (tablespaceid)", "create table xsysusers ( userid int not null, username char(30) not null, userpwd char(32) not null, usertype char(8) not null, primary key (userid) )", "create unique index idx_xsysusers_1 on xsysusers (username)", "create table xsysdatabases ( dbid int not null, dbname varchar(128) not null, primary key (dbid))", "create unique index idx_xsysdatabases_1 on xsysdatabases (dbname)", "create table xsysdbnodes ( dbnodeid int not null, dbid int not null, nodeid int not null, primary key (dbid, nodeid))", "create unique index idx_dbnodes1 on xsysdbnodes (dbnodeid)", "alter table xsysdbnodes add foreign key (dbid) references xsysdatabases (dbid)", "create table xsystables ( tableid int not null, dbid integer not null, tablename char(128) not null, numrows bigint not null, partscheme smallint not null,  partcol char(128),     parthash int, owner int, parentid int, tablespaceid int, clusteridx varchar(80), primary key (tableid))", "alter table xsystables add foreign key (dbid) references xsysdatabases (dbid)", "alter table xsystables add foreign key (parentid) references xsystables (tableid)", "alter table xsystables add foreign key (tablespaceid) references xsystablespaces (tablespaceid)", "create table xsystabparts ( partid int not null, tableid integer not null, dbid integer not null, nodeid int not null, primary key (partid))", "alter table xsystabparts add foreign key (tableid) references xsystables (tableid)", "alter table xsystabparts add foreign key (dbid, nodeid) references xsysdbnodes (dbid, nodeid)", "create table xsystabparthash ( parthashid int not null, tableid integer not null, dbid integer not null, hashvalue integer not null, nodeid int not null, primary key (parthashid))", "alter table xsystabparthash add foreign key (tableid) references xsystables (tableid)", "alter table xsystabparthash add foreign key (dbid, nodeid) references xsysdbnodes (dbid, nodeid)", "create table xsyscolumns ( colid int not null, tableid int not null, colseq smallint not null, colname varchar(128) not null, coltype smallint not null, collength int, colscale smallint, colprecision smallint, isnullable smallint not null, isserial smallint, defaultexpr varchar(255), checkexpr varchar(255), selectivity float, nativecoldef varchar(255),  primary key (colid))", "alter table xsyscolumns add foreign key (tableid) references xsystables (tableid)", "create unique index idx_xsyscolumns_1 on xsyscolumns (tableid, colseq)", "create table xsysindexes ( idxid int not null, idxname varchar(80) not null, tableid int not null, keycnt smallint not null, idxtype char(1),    tablespaceid int, usingtype varchar(80) , wherepred varchar(1024) , issyscreated smallint not null , primary key (idxid))", "alter table xsysindexes add foreign key (tableid) references xsystables (tableid)", "alter table xsysindexes add foreign key (tablespaceid) references xsystablespaces (tablespaceid)", "create table xsysindexkeys ( idxkeyid int not null, idxid int not null, idxkeyseq int not null, idxascdesc smallint not null ,  colid int not null, coloperator varchar(80), primary key (idxkeyid))", "alter table xsysindexkeys add foreign key (idxid) references xsysindexes (idxid)", "alter table xsysindexkeys add foreign key (colid) references xsyscolumns (colid)", "create unique index idx_xsysindexkeys_1 on xsysindexkeys (idxid, idxkeyseq)", "create table xsysconstraints ( constid int not null, constname varchar(128),   tableid int not null, consttype char(1) not null,  idxid int, issoft smallint not null , primary key (constid))", "alter table xsysconstraints add foreign key (tableid) references xsystables (tableid)", "alter table xsysconstraints add foreign key (idxid) references xsysindexes (idxid)", "create table xsysreferences ( refid int not null, constid int not null, reftableid int not null, refidxid int not null,   primary key (refid))", "alter table xsysreferences add foreign key (constid) references xsysconstraints (constid)", "alter table xsysreferences add foreign key (reftableid) references xsystables (tableid)", "alter table xsysreferences add foreign key (refidxid) references xsysindexes (idxid)", "create table xsysforeignkeys ( fkeyid int not null, refid int not null, fkeyseq int not null, colid int not null, refcolid int not null, primary key (fkeyid))", "alter table xsysforeignkeys add foreign key (refid) references xsysreferences (refid)", "alter table xsysforeignkeys add foreign key (colid) references xsyscolumns (colid)", "alter table xsysforeignkeys add foreign key (refcolid) references xsyscolumns (colid)", "create unique index idx_xsysforeignkeys_1 on xsysforeignkeys (refid, fkeyseq)", "create table xsystabprivs ( privid int not null, userid int, tableid int not null, selectpriv char(1) not null, insertpriv char(1) not null, updatepriv char(1) not null, deletepriv char(1) not null, referencespriv char(1) not null, indexpriv char(1) not null, alterpriv char(1) not null, primary key (privid))", "alter table xsystabprivs add foreign key (userid) references xsysusers (userid)", "alter table xsystabprivs add foreign key (tableid) references xsystables (tableid)", "create unique index idx_xsystabprivs_1 on xsystabprivs (userid, tableid)", "alter table xsystables add foreign key (owner) references xsysusers (userid)", "create table xsysviews ( viewid int not null, dbid int not null, viewname varchar(255), viewtext varchar(7500), primary key(viewid))", "create unique index idx_xsysviews_1 on xsysviews (viewid)", "create table xsysviewscolumns (viewcolid int not null, viewid int not null, viewcolseqno int not null,viewcolumn varchar(255),coltype smallint not null, collength int, colscale smallint, colprecision smallint, primary key (viewcolid))", "create table xsysviewdeps   (viewid int not null, columnid int not null, tableid int not null) ", "create unique index idx_sysviewscols_1 on xsysviewscolumns (viewid, viewcolseqno)", "alter table xsysviewscolumns add foreign key (viewid) references xsysviews (viewid)", "alter table xsysviewdeps add foreign key (viewid) references xsysviews (viewid)", "alter table xsysviews add foreign key (dbid) references xsysdatabases (dbid)", "create table xsyschecks ( checkid int not null, constid int not null, seqno int not null, checkstmt varchar(8000), primary key (checkid))", "create unique index idx_xsyschecks_1 on xsyschecks (constid, seqno)", "alter table xsyschecks add foreign key (constid) references xsysconstraints (constid)"};
    }
}

