/*
 * Decompiled with CFR 0.152.
 */
package com.edb.jdbc3;

import com.edb.core.Utils;
import com.edb.util.GT;
import com.edb.util.PSQLException;
import java.sql.SQLException;
import java.sql.Savepoint;

public class PSQLSavepoint
implements Savepoint {
    private boolean _isValid = true;
    private boolean _isNamed;
    private int _id;
    private String _name;

    public PSQLSavepoint(int id) {
        this._isNamed = false;
        this._id = id;
    }

    public PSQLSavepoint(String name) {
        this._isNamed = true;
        this._name = name;
    }

    public int getSavepointId() throws SQLException {
        if (!this._isValid) {
            throw new PSQLException(GT.tr("Cannot reference a savepoint after it has been released."));
        }
        if (this._isNamed) {
            throw new PSQLException(GT.tr("Cannot retrieve the id of a named savepoint."));
        }
        return this._id;
    }

    public String getSavepointName() throws SQLException {
        if (!this._isValid) {
            throw new PSQLException(GT.tr("Cannot reference a savepoint after it has been released."));
        }
        if (!this._isNamed) {
            throw new PSQLException(GT.tr("Cannot retrieve the name of an unnamed savepoint."));
        }
        return this._name;
    }

    public void invalidate() {
        this._isValid = false;
    }

    public String getPGName() throws SQLException {
        if (!this._isValid) {
            throw new PSQLException(GT.tr("Cannot reference a savepoint after it has been released."));
        }
        if (this._isNamed) {
            return Utils.appendEscapedIdentifier(null, this._name).toString();
        }
        return "JDBC_SAVEPOINT_" + this._id;
    }
}

