/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.constraintchecker;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.constraintchecker.AbstractConstraintChecker;
import com.edb.gridsql.engine.IExecutable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysConstraint;
import com.edb.gridsql.metadata.SysForeignKey;
import com.edb.gridsql.metadata.SysReference;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.parser.Parser;
import com.edb.gridsql.parser.SqlSelect;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteForeignReferenceChecker
extends AbstractConstraintChecker {
    private static final XLogger logger = XLogger.getLogger(DeleteForeignReferenceChecker.class);
    private static final String TABLE_ALIAS1 = "t1";
    private static final String TABLE_ALIAS2 = "t2";

    public DeleteForeignReferenceChecker(SysTable sysTable, XDBSessionContext xDBSessionContext) {
        super(sysTable, xDBSessionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<SysColumn> scanConstraints(Collection<SysColumn> collection, Collection collection2) {
        try {
            HashSet<SysColumn> hashSet = new HashSet<SysColumn>();
            Vector<SysReference> vector = this.targetTable.getSysReferences();
            for (SysReference sysReference : vector) {
                if (!sysReference.getDistributedCheck()) continue;
                Vector vector2 = sysReference.getForeignKeys();
                for (SysForeignKey sysForeignKey : vector2) {
                    SysColumn sysColumn = this.targetTable.getSysColumn(sysForeignKey.getRefcolid());
                    if (collection.contains(sysColumn)) continue;
                    hashSet.add(sysColumn);
                }
                collection2.add(sysReference);
            }
            HashSet<SysColumn> hashSet2 = hashSet;
            Object var12_11 = null;
            return hashSet2;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<IExecutable, AbstractConstraintChecker.ViolationCriteria> prepareConstraint(Object object) throws Exception {
        try {
            Object object2;
            SysConstraint sysConstraint = ((SysReference)object).getConstraint();
            AbstractConstraintChecker.ViolationCriteria violationCriteria = new AbstractConstraintChecker.ViolationCriteria();
            violationCriteria.violationType = 2;
            violationCriteria.message = sysConstraint.toString();
            SysTable sysTable = sysConstraint.getSysTable();
            StringBuffer stringBuffer = new StringBuffer("SELECT 1 FROM ");
            stringBuffer.append(this.tempTable.getTableName()).append(" ").append(TABLE_ALIAS1);
            stringBuffer.append(" LEFT JOIN ");
            stringBuffer.append(sysTable.getTableName()).append(" ").append(TABLE_ALIAS2);
            stringBuffer.append(" ON ");
            Vector vector = ((SysReference)object).getForeignKeys();
            for (SysForeignKey object32 : vector) {
                object2 = sysTable.getSysColumn(object32.getColid());
                SysColumn sysColumn = this.targetTable.getSysColumn(object32.getRefcolid());
                stringBuffer.append(TABLE_ALIAS1).append(".").append(sysColumn.getColName()).append("=");
                stringBuffer.append(TABLE_ALIAS2).append(".").append(((SysColumn)object2).getColName()).append(" AND ");
            }
            stringBuffer.setLength(stringBuffer.length() - 4);
            stringBuffer.append("WHERE ");
            for (SysColumn sysColumn : sysTable.getRowID()) {
                stringBuffer.append(TABLE_ALIAS2).append(".").append(sysColumn.getColName()).append(" IS NOT NULL AND ");
            }
            stringBuffer.setLength(stringBuffer.length() - 5);
            Parser parser = new Parser(this.client);
            parser.parseStatement(stringBuffer.toString());
            SqlSelect sqlSelect = (SqlSelect)parser.getSqlObject();
            sqlSelect.addSkipPermissionCheck(this.targetTable.getTableName());
            sqlSelect.addSkipPermissionCheck(sysTable.getTableName());
            sqlSelect.prepare();
            object2 = Collections.singletonMap(sqlSelect, violationCriteria);
            Object var12_14 = null;
            return object2;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            throw throwable;
        }
    }
}

