/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine;

import com.edb.gridsql.common.ActivityLog;
import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.communication.message.NodeMessage;
import com.edb.gridsql.communication.message.SendRowsMessage;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBBaseException;
import com.edb.gridsql.exception.XDBMessageMonitorException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MessageMonitor {
    private static final XLogger logger = XLogger.getLogger(MessageMonitor.class);
    private static final long TIMEOUT_RATE = Property.getLong("xdb.messagemonitor.timeout.rate", 4L);
    private static final long TIMEOUT_MILLIS = Property.getLong("xdb.messagemonitor.timeout.millis", 3600000L);
    private long timeout;
    private List<Integer> sourceList = null;
    private ArrayList<NodeMessage> messages = null;
    private long startWaiting = 0L;
    private NodeMessage abort = null;
    private int currentRequestId;
    private XDBSessionContext client;

    public MessageMonitor(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.timeout = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMonitor(int n, Collection collection) throws XDBServerException {
        if (collection != null) {
            this.abort = null;
            this.timeout = 0L;
            this.currentRequestId = n;
            this.sourceList = new ArrayList<Integer>(collection.size());
            for (Object e : collection) {
                this.sourceList.add(e instanceof DBNode ? ((DBNode)e).getNode().getNodeid() : ((Integer)e).intValue());
            }
        } else {
            XDBServerException xDBServerException = new XDBServerException("Monitor already tracks messages");
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
        this.messages = new ArrayList(this.sourceList.size());
    }

    public synchronized NodeMessage[] waitForMessages() throws XDBServerException {
        return this.waitForMessages(this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized NodeMessage[] waitForMessages(long l) throws XDBServerException {
        if (this.startWaiting > 0L) {
            XDBServerException xDBServerException = new XDBServerException("Someone already waits for messages");
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
        if (this.sourceList == null) {
            XDBServerException xDBServerException = new XDBServerException("Monitor was not set up to track messages");
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
        this.startWaiting = System.currentTimeMillis();
        try {
            while (!this.sourceList.isEmpty()) {
                long l2 = l + this.startWaiting - System.currentTimeMillis();
                if (l > 0L && l2 < 0L) {
                    XDBMessageMonitorException xDBMessageMonitorException = new XDBMessageMonitorException(0, "Timeout expired (" + l + ")", this.sourceList);
                    logger.throwing(xDBMessageMonitorException);
                    throw xDBMessageMonitorException;
                }
                if (this.abort != null) {
                    XDBBaseException xDBBaseException = this.abort.getCause();
                    XDBMessageMonitorException xDBMessageMonitorException = xDBBaseException != null ? new XDBMessageMonitorException(xDBBaseException, this.sourceList) : new XDBMessageMonitorException(this.abort.getSourceNodeID(), "Error has occurred", this.sourceList);
                    this.abort = null;
                    logger.throwing(xDBMessageMonitorException);
                    throw xDBMessageMonitorException;
                }
                try {
                    this.wait(l2 > 0L ? l2 : 0L);
                    if (l != 0L) continue;
                    l = Math.max((System.currentTimeMillis() - this.startWaiting) * TIMEOUT_RATE, TIMEOUT_MILLIS);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            NodeMessage[] nodeMessageArray = this.messages.toArray(new NodeMessage[this.messages.size()]);
            return nodeMessageArray;
        }
        finally {
            this.sourceList = null;
            this.messages = null;
            this.startWaiting = 0L;
            this.timeout = 0L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized NodeMessage[] checkMessages() throws XDBServerException {
        if (this.sourceList == null) {
            XDBServerException xDBServerException = new XDBServerException("Monitor was not set up to track messages");
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
        if (this.startWaiting == 0L) {
            this.startWaiting = System.currentTimeMillis();
        }
        try {
            if (this.abort != null) {
                XDBBaseException xDBBaseException = this.abort.getCause();
                XDBMessageMonitorException xDBMessageMonitorException = xDBBaseException != null ? new XDBMessageMonitorException(xDBBaseException, this.sourceList) : new XDBMessageMonitorException(this.abort.getSourceNodeID(), "Error has occurred", this.sourceList);
                this.abort = null;
                logger.throwing(xDBMessageMonitorException);
                throw xDBMessageMonitorException;
            }
            if (this.sourceList.isEmpty()) {
                NodeMessage[] nodeMessageArray = this.messages.toArray(new NodeMessage[this.messages.size()]);
                this.sourceList = null;
                this.messages = null;
                this.startWaiting = 0L;
                this.timeout = 0L;
                return nodeMessageArray;
            }
            if (this.timeout > 0L && this.startWaiting + this.timeout < System.currentTimeMillis()) {
                XDBMessageMonitorException xDBMessageMonitorException = new XDBMessageMonitorException(0, "Timeout expired (" + this.timeout + ")", this.sourceList);
                logger.throwing(xDBMessageMonitorException);
                throw xDBMessageMonitorException;
            }
            if (this.timeout != 0L) return null;
            if (this.messages.isEmpty()) return null;
            this.timeout = Math.max((System.currentTimeMillis() - this.startWaiting) * TIMEOUT_RATE, TIMEOUT_MILLIS);
            return null;
        }
        catch (Exception exception) {
            this.sourceList = null;
            this.messages = null;
            this.startWaiting = 0L;
            this.timeout = 0L;
            if (!(exception instanceof XDBServerException)) throw new XDBServerException("Exception has been thrown", exception);
            throw (XDBServerException)exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void register(NodeMessage nodeMessage) {
        if (this.sourceList != null && nodeMessage.getRequestId() == this.currentRequestId) {
            if (nodeMessage.getMessageType() == 46) {
                ActivityLog.startShipRows(this.client.getStatementId(), nodeMessage.getSourceNodeID(), ((SendRowsMessage)nodeMessage).getDestNodeForRows());
            } else if (nodeMessage.getMessageType() == 47) {
                ActivityLog.endShipRows(this.client.getStatementId(), nodeMessage.getSourceNodeID(), ((SendRowsMessage)nodeMessage).getDestNodeForRows(), ((SendRowsMessage)nodeMessage).getNumRowsSent());
            } else if (this.sourceList.remove(new Integer(nodeMessage.getSourceNodeID()))) {
                this.messages.add(nodeMessage);
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean abort(NodeMessage nodeMessage) {
        if (nodeMessage.getRequestId() == this.currentRequestId) {
            this.abort = nodeMessage;
            this.notifyAll();
        }
        boolean bl = this.abort != null;
        return bl;
    }

    public int getRequestId() {
        return this.currentRequestId;
    }
}

