/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine.loader;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.engine.loader.DataProcessorThread;
import com.edb.gridsql.engine.loader.DataReaderAndProcessorBuffer;
import com.edb.gridsql.engine.loader.ILoaderConfigInformation;
import com.edb.gridsql.engine.loader.INodeWriter;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextProcessorThread
extends DataProcessorThread<byte[]> {
    protected final byte[] nullValueTemplate;
    protected byte[] outputRow;
    protected int[] columnEnds;
    protected int colCount;

    public TextProcessorThread(ILoaderConfigInformation iLoaderConfigInformation, int n, DataReaderAndProcessorBuffer<byte[]> dataReaderAndProcessorBuffer) throws Exception {
        super(iLoaderConfigInformation, n, dataReaderAndProcessorBuffer);
        this.nullValueTemplate = this.NULLValue.getBytes();
        this.columnEnds = new int[this.getColumnCount()];
    }

    @Override
    protected String getValue(int n) {
        int n2 = n == 1 ? 0 : this.columnEnds[n - 2] + 1;
        String string = new String(this.outputRow, n2, this.columnEnds[n - 1] - n2);
        return string.equals(this.NULLValue) ? null : string;
    }

    @Override
    protected void insertGeneratedValues(Map<Integer, String> map) throws Exception {
        int[] nArray = new int[this.colCount + map.size()];
        TreeMap<Integer, byte[]> treeMap = new TreeMap<Integer, byte[]>();
        int n = 0;
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            byte[] byArray = this.encodeValue(entry.getValue());
            treeMap.put(entry.getKey(), entry.getValue().getBytes());
            n += byArray.length + 1;
        }
        Object object = new byte[this.outputRow.length + n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (Map.Entry entry : treeMap.entrySet()) {
            boolean bl;
            boolean bl2 = bl = (Integer)entry.getKey() - n3 + n2 == this.colCount;
            if (n2 < (Integer)entry.getKey() - n3 + n2) {
                int n6 = this.columnEnds[(Integer)entry.getKey() - n3 + n2 - 1] - n4;
                if (!bl) {
                    ++n6;
                }
                System.arraycopy(this.outputRow, n4, object, n5, n6);
                int n7 = n5 - n4;
                while (n2 < (Integer)entry.getKey()) {
                    nArray[n3++] = this.columnEnds[n2++] + n7;
                }
                n4 += n6;
                n5 += n6;
            }
            if (bl) {
                object[n5++] = (byte)this.separator;
            }
            byte[] byArray = (byte[])entry.getValue();
            System.arraycopy(byArray, 0, object, n5, byArray.length);
            nArray[n3++] = n5 += byArray.length;
            if (bl) continue;
            object[n5++] = (byte)this.separator;
        }
        if (n2 < this.colCount) {
            int n8 = this.columnEnds[this.colCount - 1] - n4;
            System.arraycopy(this.outputRow, n4, object, n5, n8);
            int n9 = n5 - n4;
            while (n2 < this.colCount) {
                nArray[n3++] = this.columnEnds[n2++] + n9;
            }
        }
        this.columnEnds = nArray;
        this.outputRow = (byte[])object;
        this.colCount += map.size();
    }

    protected byte[] encodeValue(String string) {
        return string == null ? this.nullValueTemplate : ParseCmdLine.escape(string, this.separator, false).getBytes();
    }

    @Override
    protected void outputRow(INodeWriter iNodeWriter) throws IOException {
        iNodeWriter.writeRow(this.outputRow, 0, this.suppresSendingNodeId ? this.columnEnds[this.colCount - 2] : this.columnEnds[this.colCount - 1]);
    }

    @Override
    protected boolean parseRow() throws Exception {
        this.colCount = 0;
        this.outputRow = (byte[])this.getNextRowValue();
        if (this.outputRow == null) {
            return false;
        }
        int n = 0;
        int n2 = this.find(this.outputRow, (byte)this.separator, n);
        while (n2 > -1) {
            n = n2 + 1;
            boolean bl = false;
            for (int i = n2 - 1; i >= 0 && this.outputRow[i] == 92; --i) {
                bl = !bl;
            }
            if (!bl) {
                this.columnEnds[this.colCount++] = n2;
                if (this.colCount == this.getColumnCount()) {
                    throw new Exception("Extra data found after last column");
                }
            }
            n2 = this.find(this.outputRow, (byte)this.separator, n);
        }
        this.columnEnds[this.colCount++] = this.outputRow.length;
        return true;
    }

    protected int find(byte[] byArray, byte by, int n) {
        for (int i = n; i < byArray.length; ++i) {
            if (by != byArray[i]) continue;
            return i;
        }
        return -1;
    }
}

