/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.optimizer;

import com.edb.gridsql.exception.ColumnNotFoundException;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.optimizer.IRebuildString;
import com.edb.gridsql.optimizer.QueryCondition;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.RelationNode;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.ExpressionType;
import com.edb.gridsql.parser.handler.IdentifierHandler;

public class AttributeColumn
implements IRebuildString {
    private String tableName = "";
    public String columnName = "";
    private String tableAlias = "";
    public String columnAlias = "";
    public String tempColumnAlias = "";
    public ExpressionType columnType = new ExpressionType();
    public RelationNode relationNode;
    public int columnGenre = 1;
    public static final int PERMANENT = 2;
    public static final int MAPPED = 4;
    public static final int ORPHAN = 8;
    QueryTree parentQueryTree;
    QueryCondition ParentQueryCondition = null;

    public QueryCondition getParentQueryCondition() {
        return this.ParentQueryCondition;
    }

    public void setParentQueryCondition(QueryCondition queryCondition) {
        this.ParentQueryCondition = queryCondition;
    }

    public ExpressionType getColumnType(SysDatabase sysDatabase) throws IllegalArgumentException, ColumnNotFoundException {
        if (this.columnType != null && this.columnType.type != 0) {
            return this.columnType;
        }
        if (this.tableName == null || this.columnName == null) {
            throw new XDBServerException(ErrorMessageRepository.TABLE_COLUMN_NOT_FILLED, 0, ErrorMessageRepository.TABLE_COLUMN_NOT_FILLED_CODE);
        }
        if (sysDatabase != null) {
            this.setColInfo(sysDatabase);
            return this.columnType;
        }
        throw new IllegalArgumentException("Database is NULL");
    }

    public void setColumnGenere() {
        if (this.relationNode != null && this.relationNode.getNodeType() == 4) {
            this.columnGenre |= 4;
        } else if (this.relationNode == null) {
            this.columnGenre |= 8;
        }
    }

    private void setColInfo(SysDatabase sysDatabase) throws ColumnNotFoundException {
        this.setColumnGenere();
        if ((this.columnGenre & 4) == 0 && (this.columnGenre & 8) == 0) {
            SysColumn sysColumn = sysDatabase.getSysTable(this.tableName).getSysColumn(this.columnName);
            if (sysColumn == null) {
                throw new ColumnNotFoundException(this.columnName, this.tableName);
            }
            this.columnType.type = sysColumn.getColType();
            this.columnType.length = sysColumn.getColLength();
            this.columnType.precision = sysColumn.getColPrecision();
            this.columnType.scale = sysColumn.getColScale();
        } else if ((this.columnGenre & 4) == 4) {
            SqlExpression sqlExpression = this.relationNode.getMatchingSqlExpression(this);
            this.columnType = sqlExpression.getExprDataType();
        } else {
            if ((this.columnGenre & 8) == 8) {
                if (this.relationNode != null) {
                    this.tableName = this.relationNode.getTableName();
                    SysColumn sysColumn = sysDatabase.getSysTable(this.tableName).getSysColumn(this.columnName);
                    this.columnType.type = sysColumn.getColType();
                    this.columnType.length = sysColumn.getColLength();
                    this.columnType.precision = sysColumn.getColPrecision();
                    this.columnType.scale = sysColumn.getColScale();
                }
                return;
            }
            String string = ErrorMessageRepository.ILLEGAL_COLUMN_TYPE;
            throw new XDBServerException(string + "(" + this.columnName + ")", 0, ErrorMessageRepository.ILLEGAL_COLUMN_TYPE_CODE);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEquivalent(AttributeColumn attributeColumn) {
        if (attributeColumn.tableAlias.length() > 0) {
            if (this.tableAlias.length() <= 0) return false;
            if (!attributeColumn.tableAlias.equalsIgnoreCase(this.tableAlias)) {
                return false;
            }
        } else {
            if (this.tableName.length() <= 0) return false;
            if (!attributeColumn.tableName.equalsIgnoreCase(this.tableName)) {
                return false;
            }
        }
        if (this.columnName.length() <= 0) return false;
        return attributeColumn.columnName.equalsIgnoreCase(this.columnName);
    }

    public String rebuildString() {
        if (this.columnAlias.length() > 0) {
            return IdentifierHandler.quote(this.tableAlias) + "." + IdentifierHandler.quote(this.columnAlias);
        }
        return IdentifierHandler.quote(this.tableAlias) + "." + IdentifierHandler.quote(this.columnName);
    }

    public void setMyParentTree(QueryTree queryTree) {
        if (this.parentQueryTree == null) {
            this.parentQueryTree = queryTree;
        }
    }

    public SysTable getSysTable(SysDatabase sysDatabase) throws IllegalArgumentException, XDBServerException {
        if (sysDatabase == null) {
            throw new IllegalArgumentException("Database is NULL");
        }
        if (this.tableName == null) {
            throw new XDBServerException(ErrorMessageRepository.TABLE_NOT_FOUND, 0, ErrorMessageRepository.TABLE_NOT_FOUND_CODE);
        }
        return sysDatabase.getSysTable(this.tableName);
    }

    public SysColumn getSysColumn(SysDatabase sysDatabase) throws IllegalArgumentException, XDBServerException {
        if (sysDatabase == null) {
            throw new IllegalArgumentException("Database is NULL");
        }
        if (this.tableName == null || this.columnName == null) {
            throw new XDBServerException(ErrorMessageRepository.TABLE_COLUMN_NOT_FILLED, 0, ErrorMessageRepository.TABLE_COLUMN_NOT_FILLED_CODE);
        }
        return sysDatabase.getSysTable(this.tableName).getSysColumn(this.columnName);
    }

    public QueryTree getMyParentTree() {
        return this.parentQueryTree;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void setTableAlias(String string) {
        this.tableAlias = string;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }
}

