/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.optimizer;

import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.engine.io.DataTypes;
import com.edb.gridsql.exception.ColumnNotFoundException;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.NotAlphaNumericException;
import com.edb.gridsql.exception.NotNumericException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.ExpressionType;
import com.edb.gridsql.parser.handler.DataTypeHandler;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.StringTokenizer;

public class FunctionAnalysis {
    public static final int SOUNDEXCOLLEN = 4;
    public static final int MAX_INET_CIDR_TEXT_LEN = 50;

    public static ExpressionType analyzeAverageParameter(SqlExpression sqlExpression, SysDatabase sysDatabase) {
        if (sqlExpression.getExprType() != 32) {
            throw new XDBServerException(ErrorMessageRepository.ILLEGAL_EXPRESSION_OBJECT_NULL, 0, ErrorMessageRepository.ILLEGAL_EXPRESSION_OBJECT_NULL_CODE);
        }
        ExpressionType expressionType = null;
        if (sqlExpression.getFunctionParams().size() > 0) {
            SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
            expressionType = SqlExpression.setExpressionResultType(sqlExpression2, sysDatabase);
            if (!(expressionType.isNumeric() || expressionType.isBit() || expressionType.isCharacter())) {
                throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + "( " + sqlExpression2.getExprString() + " )", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
            }
            ExpressionType expressionType2 = new ExpressionType();
            switch (expressionType.type) {
                case -5: 
                case 4: 
                case 5: {
                    expressionType2.setExpressionType(2, 32, 0, 0);
                    break;
                }
                case 6: {
                    expressionType2.setExpressionType(8, 32, 0, 0);
                    break;
                }
                default: {
                    expressionType2 = expressionType;
                }
            }
            return expressionType2;
        }
        return expressionType;
    }

    public static ExpressionType analyzeCountParameter(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(-5, 40, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeLengthParameter(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(4, 0, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeDateTruncParameter(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(93, 26, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeAgeParameter(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(122, -1, -1, -1);
        return expressionType;
    }

    public static ExpressionType analyzeDatePartParameter(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(4, 0, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeExtractParameter(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(4, 0, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeIsFiniteParameter(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(16, 0, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeNowParameter(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(93, 26, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeTimeOfDayParameter(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(12, 50, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeHour_Min_SecParameter(SqlExpression sqlExpression, SysDatabase sysDatabase) {
        ExpressionType expressionType = new ExpressionType();
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        if (!FunctionAnalysis.isTime(sqlExpression2, sysDatabase) && !FunctionAnalysis.isTimeStamp(sqlExpression2, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_TIME_TIMESTAMP + " ( " + sqlExpression.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_TIME_TIMESTAMP_CODE);
        }
        expressionType.setExpressionType(4, 10, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeAddTime_SubTimeParameter(SqlExpression sqlExpression, SysDatabase sysDatabase) {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(1);
        if (FunctionAnalysis.isTime(sqlExpression2, sysDatabase)) {
            SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(0);
            ExpressionType expressionType = new ExpressionType();
            if (FunctionAnalysis.isTime(sqlExpression3, sysDatabase)) {
                expressionType.setExpressionType(92, 8, 0, 0);
                return expressionType;
            }
            if (FunctionAnalysis.isTimeStamp(sqlExpression3, sysDatabase)) {
                expressionType.setExpressionType(93, 26, 0, 0);
                return expressionType;
            }
            throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_TIME_TIMESTAMP + " ( " + sqlExpression3.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_TIME_TIMESTAMP_CODE);
        }
        throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_TIME_TIMESTAMP + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_TIME_TIMESTAMP_CODE);
    }

    public static ExpressionType analyzeAddDate_SubDateParameter(SqlExpression sqlExpression, SysDatabase sysDatabase) {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(1);
        if (sqlExpression2.getExprDataType() == null) {
            SqlExpression.setExpressionResultType(sqlExpression2, sysDatabase);
        }
        if (!sqlExpression2.getExprDataType().isNumeric()) {
            throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_NUMERIC + " ( " + sqlExpression.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_NUMERIC_CODE);
        }
        SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(0);
        ExpressionType expressionType = new ExpressionType();
        if (FunctionAnalysis.isDate(sqlExpression3, sysDatabase)) {
            expressionType.setExpressionType(91, 8, 0, 0);
            return expressionType;
        }
        if (FunctionAnalysis.isTimeStamp(sqlExpression3, sysDatabase)) {
            expressionType.setExpressionType(93, 26, 0, 0);
            return expressionType;
        }
        throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_TIME_TIMESTAMP + " ( " + sqlExpression3.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_TIME_TIMESTAMP_CODE);
    }

    public static ExpressionType analyzeDateParameter(SqlExpression sqlExpression, SysDatabase sysDatabase) {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        if (FunctionAnalysis.isDate(sqlExpression2, sysDatabase) || FunctionAnalysis.isTimeStamp(sqlExpression2, sysDatabase)) {
            ExpressionType expressionType = new ExpressionType();
            expressionType.setExpressionType(91, 8, 0, 0);
            return expressionType;
        }
        throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_TIME_TIMESTAMP + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_TIME_TIMESTAMP_CODE);
    }

    public static ExpressionType analyzeToDateParameter(SqlExpression sqlExpression, SysDatabase sysDatabase) {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(1);
        if (sqlExpression2.getExprDataType() == null || sqlExpression2.getExprDataType().type == 0) {
            SqlExpression.setExpressionResultType(sqlExpression2, sysDatabase);
        }
        if (sqlExpression2.getExprType() == 2 && sqlExpression2.getExprDataType().type != 12 && sqlExpression2.getExprDataType().type != 1 && sqlExpression2.getExprDataType().type != 91 && sqlExpression2.getExprDataType().type != 93) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        if (!FunctionAnalysis.isCharacter(sqlExpression3, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression3.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(93, 26, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeDateDiff(SqlExpression sqlExpression, SysDatabase sysDatabase) {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(1);
        if ((FunctionAnalysis.isDate(sqlExpression2, sysDatabase) || FunctionAnalysis.isTimeStamp(sqlExpression2, sysDatabase)) && (FunctionAnalysis.isDate(sqlExpression3, sysDatabase) || FunctionAnalysis.isTimeStamp(sqlExpression3, sysDatabase))) {
            ExpressionType expressionType = new ExpressionType();
            expressionType.setExpressionType(6, 32, 0, 0);
            return expressionType;
        }
        throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_TIME_TIMESTAMP + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_TIME_TIMESTAMP_CODE);
    }

    public static ExpressionType analyzeDayName_MonthName_Parameter(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        if (FunctionAnalysis.isDate(sqlExpression2, sysDatabase) || FunctionAnalysis.isTimeStamp(sqlExpression2, sysDatabase)) {
            ExpressionType expressionType = new ExpressionType();
            expressionType.setExpressionType(1, 20, 0, 0);
            return expressionType;
        }
        throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_DATE_TIMESTAMP + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_DATE_TIMESTAMP_CODE);
    }

    public static ExpressionType analyzeDayOfMonth_DayOfWeek_DayOfYear_Month_Year_WeekOfYear_Parameter(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        if (FunctionAnalysis.isDate(sqlExpression2, sysDatabase) || FunctionAnalysis.isTimeStamp(sqlExpression2, sysDatabase)) {
            ExpressionType expressionType = new ExpressionType();
            expressionType.setExpressionType(4, 10, 0, 0);
            return expressionType;
        }
        throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_DATE_TIMESTAMP + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_DATE_TIMESTAMP_CODE);
    }

    public static ExpressionType analyzeTimeStamp(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        int n = sqlExpression.getFunctionParams().size();
        ExpressionType expressionType = new ExpressionType();
        if (n == 1) {
            SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
            if (FunctionAnalysis.isTimeStamp(sqlExpression2, sysDatabase)) {
                expressionType.setExpressionType(93, 26, 0, 0);
                return expressionType;
            }
            throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_DATE_TIMESTAMP + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_DATE_TIMESTAMP_CODE);
        }
        if (n == 2) {
            SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(0);
            SqlExpression sqlExpression4 = sqlExpression.getFunctionParams().get(1);
            if (FunctionAnalysis.isDate(sqlExpression3, sysDatabase)) {
                if (FunctionAnalysis.isTime(sqlExpression4, sysDatabase)) {
                    expressionType.setExpressionType(93, 26, 0, 0);
                    return expressionType;
                }
                throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_TIME + " ( " + sqlExpression3.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_TIME_CODE);
            }
            throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_DATE + " ( " + sqlExpression3.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_DATE_CODE);
        }
        throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
    }

    public static ExpressionType analyzeTime(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        if (FunctionAnalysis.isTime(sqlExpression2, sysDatabase) || FunctionAnalysis.isTimeStamp(sqlExpression2, sysDatabase)) {
            ExpressionType expressionType = new ExpressionType();
            expressionType.setExpressionType(91, 8, 0, 0);
            return expressionType;
        }
        throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_TIME_TIMESTAMP + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_TIME_TIMESTAMP_CODE);
    }

    public static ExpressionType analyzeMax_MinParameter(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        if (sqlExpression2.getExprDataType() == null || sqlExpression2.getExprDataType().type == 0) {
            SqlExpression.setExpressionResultType(sqlExpression2, sysDatabase);
        }
        if (sqlExpression2.getExprDataType().type == 122) {
            ExpressionType expressionType = new ExpressionType();
            expressionType.setExpressionType(12, 50, 0, 0);
            return expressionType;
        }
        return sqlExpression2.getExprDataType();
    }

    public static ExpressionType analyzeAbsParameter(SqlExpression sqlExpression, SysDatabase sysDatabase) throws XDBServerException {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        if (FunctionAnalysis.isNumeric(sqlExpression2, sysDatabase)) {
            return sqlExpression2.getExprDataType();
        }
        throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_NUMERIC + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_NUMERIC_CODE);
    }

    public static ExpressionType analyzeSumParameter(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        if (sqlExpression.getExprType() != 32) {
            throw new XDBServerException(ErrorMessageRepository.ILLEGAL_EXPRESSION_OBJECT_NULL, 0, ErrorMessageRepository.ILLEGAL_EXPRESSION_OBJECT_NULL_CODE);
        }
        ExpressionType expressionType = new ExpressionType();
        ExpressionType expressionType2 = null;
        if (sqlExpression.getFunctionParams().size() > 0) {
            SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
            expressionType2 = SqlExpression.setExpressionResultType(sqlExpression2, sysDatabase);
            if (!(expressionType2.isNumeric() || expressionType2.isBit() || expressionType2.isCharacter())) {
                throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
            }
            switch (expressionType2.type) {
                case 4: 
                case 5: {
                    expressionType.setExpressionType(-5, 40, 0, 0);
                    break;
                }
                case -5: {
                    expressionType.setExpressionType(2, 32, 0, 0);
                    break;
                }
                case 6: {
                    expressionType.setExpressionType(8, 32, 0, 0);
                    break;
                }
                case 16: {
                    expressionType.setExpressionType(4, 0, 0, 0);
                    break;
                }
                default: {
                    expressionType = expressionType2;
                }
            }
            return expressionType;
        }
        return expressionType2;
    }

    public static ExpressionType analyzeCeil_Floor_Sign(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        if (FunctionAnalysis.isNumeric(sqlExpression2, sysDatabase)) {
            return sqlExpression2.getExprDataType();
        }
        throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_NUMERIC + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_NUMERIC_CODE);
    }

    public static ExpressionType analyzeExp_LN_POWER_ASIN_ATAN_COS_COT_DEGREES_RADIANS_SIN_TAN_ACOS_LOG10_SQRT_COSH(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        if (FunctionAnalysis.isNumeric(sqlExpression2, sysDatabase)) {
            ExpressionType expressionType = new ExpressionType();
            expressionType.setExpressionType(6, 32, 0, 0);
            return expressionType;
        }
        throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_NUMERIC + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_NUMERIC_CODE);
    }

    public static ExpressionType analyzeLog_Float_ATAN2(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(1);
        if (!FunctionAnalysis.isNumeric(sqlExpression2, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_NUMERIC + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_NUMERIC_CODE);
        }
        if (FunctionAnalysis.isNumeric(sqlExpression3, sysDatabase)) {
            ExpressionType expressionType = new ExpressionType();
            expressionType.setExpressionType(6, 32, 0, 0);
            return expressionType;
        }
        throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_NUMERIC + " ( " + sqlExpression3.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_NUMERIC_CODE);
    }

    public static ExpressionType analyzeTrunc(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        SqlExpression sqlExpression3 = null;
        if (sqlExpression.getFunctionParams().size() == 2) {
            sqlExpression3 = sqlExpression.getFunctionParams().get(1);
        }
        if (!FunctionAnalysis.isNumeric(sqlExpression2, sysDatabase) && !FunctionAnalysis.isMacaddr(sqlExpression2, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_NUMERIC_MACADDR + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_NUMERIC_MACADDR_CODE);
        }
        if (sqlExpression3 == null || FunctionAnalysis.isNumeric(sqlExpression3, sysDatabase)) {
            ExpressionType expressionType = new ExpressionType();
            if (FunctionAnalysis.isMacaddr(sqlExpression2, sysDatabase)) {
                expressionType.setExpressionType(119, -1, -1, -1);
            } else {
                expressionType.setExpressionType(6, 32, 0, 0);
            }
            return expressionType;
        }
        throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_NUMERIC + " ( " + sqlExpression3.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_NUMERIC_CODE);
    }

    public static ExpressionType analyzeNullIf(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(sqlExpression2.getExprDataType().type, sqlExpression2.getExprDataType().length, sqlExpression2.getExprDataType().precision, sqlExpression2.getExprDataType().scale);
        return expressionType;
    }

    public static ExpressionType analyzeSetBitByte(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(1);
        SqlExpression sqlExpression4 = sqlExpression.getFunctionParams().get(2);
        if (!FunctionAnalysis.isCharacter(sqlExpression2, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        if (!FunctionAnalysis.isNumeric(sqlExpression3, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_NUMERIC + " ( " + sqlExpression3.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_NUMERIC_CODE);
        }
        if (!FunctionAnalysis.isNumeric(sqlExpression4, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_NUMERIC + " ( " + sqlExpression4.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_NUMERIC_CODE);
        }
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(2004, -1, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeGetBitByte(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(1);
        if (!FunctionAnalysis.isCharacter(sqlExpression2, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        if (!FunctionAnalysis.isNumeric(sqlExpression3, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_NUMERIC + " ( " + sqlExpression3.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_NUMERIC_CODE);
        }
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(4, 22, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeToChar(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(1);
        if (!(FunctionAnalysis.isDate(sqlExpression2, sysDatabase) || FunctionAnalysis.isTimeStamp(sqlExpression2, sysDatabase) || FunctionAnalysis.isNumeric(sqlExpression2, sysDatabase))) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        if (!FunctionAnalysis.isCharacter(sqlExpression3, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression3.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(12, 4000, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeToNumber(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(1);
        if (!FunctionAnalysis.isCharacter(sqlExpression2, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        if (!FunctionAnalysis.isCharacter(sqlExpression3, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression3.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(2, 22, 5, 0);
        return expressionType;
    }

    public static ExpressionType analyzeAddMonth(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(1);
        if (!FunctionAnalysis.isTime(sqlExpression2, sysDatabase) && !FunctionAnalysis.isTimeStamp(sqlExpression2, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        if (!FunctionAnalysis.isNumeric(sqlExpression3, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression3.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(93, 26, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeJustify(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        sqlExpression.getFunctionParams().get(0);
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(93, 26, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeMonthsBetween(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(1);
        if (!FunctionAnalysis.isTime(sqlExpression2, sysDatabase) && !FunctionAnalysis.isTimeStamp(sqlExpression2, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        if (!FunctionAnalysis.isTime(sqlExpression3, sysDatabase) && !FunctionAnalysis.isTimeStamp(sqlExpression3, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression3.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(2, 22, 5, 0);
        return expressionType;
    }

    public static ExpressionType analyzeNextDay(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(1);
        if (!FunctionAnalysis.isTime(sqlExpression2, sysDatabase) && !FunctionAnalysis.isTimeStamp(sqlExpression2, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        if (!FunctionAnalysis.isCharacter(sqlExpression3, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression3.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(93, 26, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeRegexpReplace(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        Object object;
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(1);
        SqlExpression sqlExpression4 = sqlExpression.getFunctionParams().get(2);
        if (!FunctionAnalysis.isCharacter(sqlExpression2, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        if (!FunctionAnalysis.isCharacter(sqlExpression3, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression3.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        if (!FunctionAnalysis.isCharacter(sqlExpression4, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression4.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        if (sqlExpression.getFunctionParams().size() == 4 && !FunctionAnalysis.isCharacter((SqlExpression)(object = sqlExpression.getFunctionParams().get(3)), sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + ((SqlExpression)object).rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        object = new ExpressionType();
        ((ExpressionType)object).setExpressionType(12, 4000, 0, 0);
        return object;
    }

    public static ExpressionType analyzeBitAnd(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        if (!FunctionAnalysis.isNumeric(sqlExpression2, sysDatabase) && !FunctionAnalysis.isBit(sqlExpression2, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        if (sqlExpression2.getExprDataType() == null) {
            sqlExpression2.setExprDataType(SqlExpression.setExpressionResultType(sqlExpression2, sysDatabase));
        }
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(sqlExpression2.getExprDataType().type, sqlExpression2.getExprDataType().length, sqlExpression2.getExprDataType().precision, sqlExpression2.getExprDataType().scale);
        return expressionType;
    }

    public static ExpressionType analyzeBoolAnd(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        sqlExpression.getFunctionParams().get(0);
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(16, -1, -1, -1);
        return expressionType;
    }

    public static ExpressionType analyzeLeft_Right(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(1);
        if (FunctionAnalysis.isNumeric(sqlExpression2, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_NUMERIC + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_NUMERIC_CODE);
        }
        if (FunctionAnalysis.isNumeric(sqlExpression3, sysDatabase)) {
            ExpressionType expressionType = new ExpressionType();
            expressionType.setExpressionType(6, 32, 0, 0);
            return expressionType;
        }
        throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_NUMERIC + " ( " + sqlExpression3.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_NUMERIC_CODE);
    }

    public static ExpressionType analyzeGreatest_Least(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        if (FunctionAnalysis.isNumeric(sqlExpression2, sysDatabase)) {
            ExpressionType expressionType = new ExpressionType();
            expressionType.setExpressionType(6, 38, 38, 0);
            return expressionType;
        }
        ExpressionType expressionType = new ExpressionType();
        int n = 0;
        for (SqlExpression sqlExpression3 : sqlExpression.getFunctionParams()) {
            int n2 = sqlExpression3.getExprDataType().length;
            if (n2 <= n) continue;
            n = n2;
        }
        expressionType.setExpressionType(1, n, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeCoalesce(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        ExpressionType expressionType = null;
        for (SqlExpression sqlExpression2 : sqlExpression.getFunctionParams()) {
            if (sqlExpression2.getExprDataType() == null || sqlExpression2.getExprDataType().type == 0) continue;
            if (FunctionAnalysis.isNumeric(sqlExpression2, sysDatabase)) {
                if (expressionType == null) {
                    expressionType = sqlExpression2.getExprDataType();
                    continue;
                }
                expressionType = ExpressionType.MergeNumericTypes(expressionType, sqlExpression2.getExprDataType());
                continue;
            }
            if (FunctionAnalysis.isDate(sqlExpression2, sysDatabase) || FunctionAnalysis.isTimeStamp(sqlExpression2, sysDatabase)) {
                ExpressionType expressionType2 = new ExpressionType();
                expressionType2.setExpressionType(91, 8, 0, 0);
                return expressionType2;
            }
            ExpressionType expressionType3 = new ExpressionType();
            int n = 0;
            for (SqlExpression sqlExpression3 : sqlExpression.getFunctionParams()) {
                int n2 = sqlExpression3.getExprDataType().length;
                if (n2 <= n) continue;
                n = n2;
            }
            expressionType3.setExpressionType(12, n, 0, 0);
            return expressionType3;
        }
        return expressionType;
    }

    public static ExpressionType analyzeRound(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        ExpressionType expressionType = new ExpressionType();
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        boolean bl = FunctionAnalysis.isNumeric(sqlExpression2, sysDatabase);
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = bl2 = FunctionAnalysis.isTimeStamp(sqlExpression2, sysDatabase) || FunctionAnalysis.isDate(sqlExpression2, sysDatabase);
        }
        if (!bl && !bl2) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        if (sqlExpression.getFunctionParams().size() == 2) {
            SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(1);
            if (bl2) {
                expressionType.setExpressionType(93, 26, 0, 0);
                return expressionType;
            }
            boolean bl4 = FunctionAnalysis.isNumeric(sqlExpression3, sysDatabase);
            if (!bl4) {
                throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_NUMERIC + " ( " + sqlExpression3.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_NUMERIC_CODE);
            }
        }
        if (bl) {
            switch (sqlExpression2.getExprDataType().type) {
                case 6: 
                case 7: 
                case 8: {
                    expressionType.setExpressionType(8, 32, 0, 0);
                    break;
                }
                default: {
                    expressionType.setExpressionType(2, 32, 0, 0);
                    break;
                }
            }
        } else {
            expressionType.setExpressionType(93, 26, 0, 0);
        }
        return expressionType;
    }

    public static ExpressionType analyzePI(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(6, 32, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeSetSeed(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(4, 10, 10, 0);
        return expressionType;
    }

    public static ExpressionType analyzeNUM(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(6, 32, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeMod(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        if (sqlExpression.getExprDataType() == null) {
            expressionType.setExpressionType(6, 32, 0, 0);
        } else {
            expressionType = sqlExpression.getExprDataType();
        }
        for (int i = 0; i < sqlExpression.getFunctionParams().size(); ++i) {
            SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(i);
            if (!sqlExpression2.getExprDataType().isInExactNumeric()) continue;
            SqlExpression sqlExpression3 = new SqlExpression();
            sqlExpression3.setExprType(32);
            sqlExpression3.setFunctionId(106);
            sqlExpression3.setFunctionName("::");
            sqlExpression3.getFunctionParams().add(sqlExpression2);
            int n = sqlExpression2.getExprDataType().length;
            sqlExpression3.setExpTypeOfCast(new DataTypeHandler(2, 0, 2 * n, n));
            sqlExpression.getFunctionParams().set(i, sqlExpression3);
        }
        return expressionType;
    }

    public static ExpressionType analyzeVarianceOrStddev(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        if (sqlExpression.getFunctionParams().get(0).getExprType() == 6) {
            expressionType.setExpressionType(8, 32, 0, 0);
        } else {
            expressionType.setExpressionType(2, 32, 0, 0);
        }
        return expressionType;
    }

    public static ExpressionType analyzeCoRegFunc(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(1);
        if (!FunctionAnalysis.isNumeric(sqlExpression2, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        if (!FunctionAnalysis.isNumeric(sqlExpression3, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression3.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(8, 32, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeRegrCount(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(1);
        if (!FunctionAnalysis.isNumeric(sqlExpression2, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        if (!FunctionAnalysis.isNumeric(sqlExpression3, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression3.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(-5, 32, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeAscii_Upper_Lower_Soundex_InitCap(SqlExpression sqlExpression, SysDatabase sysDatabase) {
        ExpressionType expressionType = new ExpressionType();
        if (sqlExpression.getFunctionId() == 98) {
            expressionType.setExpressionType(12, 4, 10, 0);
        } else if (sqlExpression.getFunctionId() == 64 || sqlExpression.getFunctionId() == 73 || sqlExpression.getFunctionId() == 99 || sqlExpression.getFunctionId() == 60) {
            SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
            if (FunctionAnalysis.isNumeric(sqlExpression2, sysDatabase)) {
                FunctionAnalysis.convertNumericToChar(sqlExpression2);
            }
            expressionType.setExpressionType(12, sqlExpression2.getExprDataType().length, 10, 0);
        }
        return expressionType;
    }

    public static ExpressionType analyzeMapchar(SqlExpression sqlExpression, SysDatabase sysDatabase) {
        ExpressionType expressionType = new ExpressionType();
        if (sqlExpression.getFunctionId() == 101) {
            int n = sqlExpression.getFunctionParams().size();
            int n2 = 0;
            SqlExpression sqlExpression2 = null;
            switch (n) {
                case 0: {
                    throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
                }
                case 1: {
                    sqlExpression2 = sqlExpression.getFunctionParams().get(0);
                    if (FunctionAnalysis.isNumeric(sqlExpression2, sysDatabase)) {
                        FunctionAnalysis.convertNumericToChar(sqlExpression2);
                    }
                    n2 = sqlExpression2.getExprDataType().length;
                    expressionType.setExpressionType(12, n2, 0, 0);
                    break;
                }
                case 2: {
                    sqlExpression2 = sqlExpression.getFunctionParams().get(1);
                    sqlExpression2.rebuildExpression();
                    if (sqlExpression2.getExprDataType().type == 1) {
                        sqlExpression2 = sqlExpression.getFunctionParams().get(0);
                        if (FunctionAnalysis.isNumeric(sqlExpression2, sysDatabase)) {
                            FunctionAnalysis.convertNumericToChar(sqlExpression2);
                        }
                        n2 = sqlExpression2.getExprDataType().length;
                        expressionType.setExpressionType(12, n2, 0, 0);
                        break;
                    }
                    sqlExpression2 = sqlExpression.getFunctionParams().get(1);
                    n2 = Integer.parseInt(sqlExpression2.getConstantValue());
                    expressionType.setExpressionType(12, n2, 0, 0);
                    break;
                }
                case 3: {
                    sqlExpression2 = sqlExpression.getFunctionParams().get(1);
                    n2 = Integer.parseInt(sqlExpression2.getConstantValue());
                    expressionType.setExpressionType(12, n2, 0, 0);
                    break;
                }
                default: {
                    throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
                }
            }
        }
        return expressionType;
    }

    public static ExpressionType analyzeLfill(SqlExpression sqlExpression, SysDatabase sysDatabase) {
        ExpressionType expressionType = new ExpressionType();
        if (sqlExpression.getFunctionId() == 100) {
            int n = sqlExpression.getFunctionParams().size();
            switch (n) {
                case 0: 
                case 1: {
                    throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
                }
                case 3: {
                    SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(2);
                    if (!FunctionAnalysis.isNumeric(sqlExpression2, sysDatabase)) {
                        throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_NUMERIC + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_NUMERIC_CODE);
                    }
                }
                case 2: {
                    SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(0);
                    if (FunctionAnalysis.isNumeric(sqlExpression3, sysDatabase)) {
                        FunctionAnalysis.convertNumericToChar(sqlExpression3);
                    }
                    int n2 = sqlExpression3.getExprDataType().length;
                    expressionType.setExpressionType(12, n2, 0, 0);
                    break;
                }
                default: {
                    throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
                }
            }
        }
        return expressionType;
    }

    public static ExpressionType analyzeConcat(SqlExpression sqlExpression, SysDatabase sysDatabase) {
        ExpressionType expressionType = new ExpressionType();
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(1);
        try {
            if (FunctionAnalysis.isNumeric(sqlExpression2, sysDatabase)) {
                FunctionAnalysis.convertNumericToChar(sqlExpression2);
            }
            if (FunctionAnalysis.isNumeric(sqlExpression3, sysDatabase)) {
                FunctionAnalysis.convertNumericToChar(sqlExpression3);
            }
        }
        catch (XDBServerException xDBServerException) {
            throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
        }
        int n = sqlExpression2.getExprDataType().length + sqlExpression3.getExprDataType().length;
        expressionType.setExpressionType(1, n, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeStrPos(SqlExpression sqlExpression, SysDatabase sysDatabase) {
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(1);
        if (!FunctionAnalysis.isCharacter(sqlExpression2, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        if (!FunctionAnalysis.isCharacter(sqlExpression3, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression3.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(4, 0, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeBtrim(SqlExpression sqlExpression, SysDatabase sysDatabase) {
        ExpressionType expressionType = new ExpressionType();
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        int n = sqlExpression2.getExprDataType().length;
        expressionType.setExpressionType(1, n + 1, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeToASCII(SqlExpression sqlExpression, SysDatabase sysDatabase) {
        SqlExpression sqlExpression2;
        ExpressionType expressionType = new ExpressionType();
        SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(0);
        if (!FunctionAnalysis.isCharacter(sqlExpression3, sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression3.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        if (sqlExpression.getFunctionParams().size() == 2 && !FunctionAnalysis.isCharacter(sqlExpression2 = sqlExpression.getFunctionParams().get(1), sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        expressionType.setExpressionType(12, sqlExpression3.getExprDataType().length, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeNVL(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        expressionType.setExpressionType(sqlExpression2.getExprDataType().type, sqlExpression2.getExprDataType().length, sqlExpression2.getExprDataType().precision, sqlExpression2.getExprDataType().scale);
        return expressionType;
    }

    public static ExpressionType analyzeChr(SqlExpression sqlExpression, SysDatabase sysDatabase) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(1, 2, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeConvert(SqlExpression sqlExpression, SysDatabase sysDatabase) {
        ExpressionType expressionType = new ExpressionType();
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        int n = sqlExpression2.getExprDataType().length;
        expressionType.setExpressionType(1, n * 2 + 1, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeDecode(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        if (sqlExpression.getFunctionParams().size() == 2) {
            expressionType.setExpressionType(2004, -1, 0, 0);
            return expressionType;
        }
        for (int i = 1; i < sqlExpression.getFunctionParams().size(); i += 2) {
            if (sqlExpression2.getExprType() != 2 || !sqlExpression2.getConstantValue().equalsIgnoreCase(sqlExpression.getFunctionParams().get(i).getConstantValue())) continue;
            SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(++i);
            expressionType.setExpressionType(sqlExpression3.getExprDataType().type, sqlExpression3.getExprDataType().length, sqlExpression3.getExprDataType().precision, sqlExpression3.getExprDataType().scale);
            return expressionType;
        }
        SqlExpression sqlExpression4 = sqlExpression.getFunctionParams().get(sqlExpression.getFunctionParams().size() - 1);
        expressionType.setExpressionType(sqlExpression4.getExprDataType().type, sqlExpression4.getExprDataType().length, sqlExpression4.getExprDataType().precision, sqlExpression4.getExprDataType().scale);
        return expressionType;
    }

    public static ExpressionType analyzeEncode(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(12, 4000, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeMd5(SqlExpression sqlExpression, SysDatabase sysDatabase) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(1, 32, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeQuote(SqlExpression sqlExpression, SysDatabase sysDatabase) {
        ExpressionType expressionType = new ExpressionType();
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        int n = sqlExpression2.getExprDataType().length;
        expressionType.setExpressionType(1, n + 3, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeRepeat(SqlExpression sqlExpression, SysDatabase sysDatabase) {
        ExpressionType expressionType = new ExpressionType();
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(1);
        int n = sqlExpression2.getExprDataType().length;
        n = sqlExpression3.getExprType() == 2 ? sqlExpression2.getExprDataType().length * Integer.parseInt(sqlExpression3.getConstantValue()) : 256;
        expressionType.setExpressionType(1, n, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeToHex(SqlExpression sqlExpression, SysDatabase sysDatabase) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(1, 16, 0, 0);
        return expressionType;
    }

    public static void convertNumericToChar(SqlExpression sqlExpression) {
        switch (sqlExpression.getExprDataType().type) {
            case -7: 
            case 4: 
            case 5: {
                sqlExpression.getExprDataType().length = 11;
                sqlExpression.getExprDataType().type = 1;
                break;
            }
            case 6: 
            case 7: {
                sqlExpression.getExprDataType().length += 6;
                sqlExpression.getExprDataType().type = 1;
                break;
            }
            case 2: 
            case 3: {
                sqlExpression.getExprDataType().length = sqlExpression.getExprDataType().precision + 2;
                sqlExpression.getExprDataType().type = 1;
                break;
            }
            case 8: {
                sqlExpression.getExprDataType().length = 33;
                sqlExpression.getExprDataType().type = 1;
                break;
            }
            default: {
                throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + "( " + sqlExpression.getExprDataType().type + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
            }
        }
    }

    public static ExpressionType analyzeLtrim_Rtirm_Trim(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        Object object;
        if (sqlExpression.getFunctionParams().size() == 2 && !FunctionAnalysis.isAlphaNumeric((SqlExpression)(object = sqlExpression.getFunctionParams().get(1)), sysDatabase)) {
            throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_ALPHANUMERIC + " ( " + ((SqlExpression)object).rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_ALPHANUMERIC_CODE);
        }
        object = new ExpressionType();
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        ((ExpressionType)object).setExpressionType(12, sqlExpression2.getExprDataType().length, 0, 0);
        return object;
    }

    public static ExpressionType analyzeIndex_InStr(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        int n = sqlExpression.getFunctionParams().size();
        switch (n) {
            case 0: 
            case 1: {
                throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
            }
            case 4: {
                SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(3);
                if (!FunctionAnalysis.isNumeric(sqlExpression2, sysDatabase)) {
                    throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_NUMERIC + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_NUMERIC_CODE);
                }
            }
            case 3: {
                SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(2);
                if (!FunctionAnalysis.isNumeric(sqlExpression3, sysDatabase)) {
                    throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_NUMERIC + " ( " + sqlExpression3.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_NUMERIC_CODE);
                }
            }
            case 2: {
                SqlExpression sqlExpression4 = sqlExpression.getFunctionParams().get(0);
                SqlExpression sqlExpression5 = sqlExpression.getFunctionParams().get(1);
                if (FunctionAnalysis.isAlphaNumeric(sqlExpression4, sysDatabase)) {
                    if (FunctionAnalysis.isAlphaNumeric(sqlExpression5, sysDatabase)) {
                        ExpressionType expressionType = new ExpressionType();
                        expressionType.setExpressionType(4, 10, 10, 0);
                        return expressionType;
                    }
                    throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_ALPHANUMERIC + " ( " + sqlExpression5.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_ALPHANUMERIC_CODE);
                }
                throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_ALPHANUMERIC + " ( " + sqlExpression4.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_ALPHANUMERIC_CODE);
            }
        }
        throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
    }

    /*
     * Unable to fully structure code
     */
    public static ExpressionType analyzeLpad_Rpad(SqlExpression var0, SysDatabase var1_1) throws ColumnNotFoundException {
        var2_2 = var0.getFunctionParams().size();
        var3_3 = 0;
        var4_4 = 0;
        switch (var2_2) {
            case 0: 
            case 1: {
                throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
            }
            case 4: {
                var5_5 = var0.getFunctionParams().get(3);
                if (var5_5.getConstantValue() == null) ** GOTO lbl12
                var3_3 = Integer.parseInt(var5_5.getConstantValue());
                ** GOTO lbl14
lbl12:
                // 1 sources

                if (!FunctionAnalysis.isNumeric(var5_5, var1_1)) {
                    throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_NUMERIC + " ( " + var5_5.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_NUMERIC_CODE);
                }
            }
lbl14:
            // 4 sources

            case 3: {
                var6_6 = var0.getFunctionParams().get(2);
                if (!FunctionAnalysis.isAlphaNumeric(var6_6, var1_1)) {
                    throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_ALPHANUMERIC + " ( " + var6_6.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_ALPHANUMERIC_CODE);
                }
                var4_4 = var6_6.getExprDataType().length;
            }
            case 2: {
                var7_7 = var0.getFunctionParams().get(0);
                var8_8 = var0.getFunctionParams().get(1);
                if (!FunctionAnalysis.isAlphaNumeric(var7_7, var1_1)) {
                    FunctionAnalysis.convertNumericToChar(var7_7);
                }
                if (!FunctionAnalysis.isNumeric(var8_8, var1_1)) {
                    throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_NUMERIC + " ( " + var7_7.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_NUMERIC_CODE);
                }
                var9_9 = var7_7.getExprDataType().length;
                var10_10 = Integer.parseInt(var8_8.getConstantValue());
                var11_11 = 0;
                var11_11 = var3_3 != 0 ? var3_3 : var9_9 + var4_4 * var10_10;
                if (!FunctionAnalysis.isAlphaNumeric(var7_7, var1_1) || !FunctionAnalysis.isNumeric(var8_8, var1_1)) break;
                var12_12 = new ExpressionType();
                var12_12.setExpressionType(12, var11_11, 0, 0);
                return var12_12;
            }
        }
        throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
    }

    public static ExpressionType analyzeReplace(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        int n = sqlExpression.getFunctionParams().size();
        switch (n) {
            case 0: 
            case 1: {
                throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
            }
            case 3: {
                SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(2);
                if (!FunctionAnalysis.isAlphaNumeric(sqlExpression2, sysDatabase)) {
                    throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_ALPHANUMERIC + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_ALPHANUMERIC_CODE);
                }
            }
            case 2: {
                SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(0);
                SqlExpression sqlExpression4 = sqlExpression.getFunctionParams().get(1);
                if (!FunctionAnalysis.isAlphaNumeric(sqlExpression3, sysDatabase)) {
                    throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_ALPHANUMERIC + " ( " + sqlExpression3.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_ALPHANUMERIC_CODE);
                }
                if (!FunctionAnalysis.isAlphaNumeric(sqlExpression4, sysDatabase)) {
                    throw new XDBServerException(ErrorMessageRepository.EXPRESSION_NOT_ALPHANUMERIC + " ( " + sqlExpression4.rebuildString() + " ) ", 0, ErrorMessageRepository.EXPRESSION_NOT_ALPHANUMERIC_CODE);
                }
                ExpressionType expressionType = new ExpressionType();
                expressionType.setExpressionType(12, sqlExpression4.getExprDataType().length * sqlExpression4.getExprDataType().length, 0, 0);
                return expressionType;
            }
        }
        throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
    }

    public static ExpressionType analyzeSubString(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        int n = sqlExpression.getFunctionParams().size();
        switch (n) {
            case 0: 
            case 1: {
                throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
            }
            case 3: {
                SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(2);
                if (!FunctionAnalysis.isNumeric(sqlExpression2, sysDatabase)) {
                    throw new NotNumericException(sqlExpression2, sqlExpression);
                }
            }
            case 2: {
                SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(0);
                SqlExpression sqlExpression4 = sqlExpression.getFunctionParams().get(1);
                if (!FunctionAnalysis.isAlphaNumeric(sqlExpression3, sysDatabase)) {
                    throw new NotAlphaNumericException(sqlExpression4, sqlExpression);
                }
                if (!FunctionAnalysis.isNumeric(sqlExpression4, sysDatabase)) {
                    throw new NotNumericException(sqlExpression4, sqlExpression);
                }
                ExpressionType expressionType = new ExpressionType();
                expressionType.setExpressionType(12, sqlExpression3.getExprDataType().length, 0, 0);
                return expressionType;
            }
        }
        throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
    }

    public static ExpressionType analyzeLength(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(4, 10, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeDatabase_Version_User(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(12, 2000, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeValue(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        for (SqlExpression sqlExpression2 : sqlExpression.getFunctionParams()) {
            if (sqlExpression2.getExprDataType() != null) continue;
            SqlExpression.setExpressionResultType(sqlExpression2, sysDatabase);
        }
        ExpressionType expressionType = new ExpressionType();
        if (sqlExpression.getFunctionParams().size() <= 0) {
            throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
        }
        expressionType.setExpressionType(sqlExpression.getFunctionParams().get((int)(sqlExpression.getFunctionParams().size() - 1)).getExprDataType().type, 10, 0, 0);
        return expressionType;
    }

    /*
     * WARNING - void declaration
     */
    public static ExpressionType analyzeCustom(SqlExpression sqlExpression, SysDatabase sysDatabase) {
        int n;
        int n2;
        int n3;
        String string;
        String string2;
        int n4 = 0;
        while (true) {
            block27: {
                block26: {
                    block28: {
                        string2 = sqlExpression.getFunctionName() + (n4 == 0 ? "" : "," + n4);
                        string = Property.get("xdb.sqlfunction." + string2 + ".paramcount");
                        if (string == null) break block28;
                        n3 = string.indexOf("+");
                        if (n3 > 0) {
                            try {
                                n2 = Integer.parseInt(string.substring(0, n3).trim());
                                if (sqlExpression.getFunctionParams().size() >= n2) break block26;
                                break block27;
                            }
                            catch (NumberFormatException numberFormatException) {
                                break block26;
                            }
                        }
                        n2 = 0;
                        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
                        while (stringTokenizer.hasMoreTokens()) {
                            String n6 = stringTokenizer.nextToken();
                            try {
                                n = Integer.parseInt(n6.trim());
                                if (sqlExpression.getFunctionParams().size() != n) continue;
                                n2 = 1;
                                break;
                            }
                            catch (NumberFormatException numberFormatException) {
                            }
                        }
                        if (n2 != 0) break block26;
                        break block27;
                    }
                    if (n4 > 0) {
                        throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
                    }
                }
                n3 = 0;
                n2 = 1;
                for (SqlExpression sqlExpression2 : sqlExpression.getFunctionParams()) {
                    ++n3;
                    if (sqlExpression2.getExprDataType() == null) {
                        SqlExpression.setExpressionResultType(sqlExpression2, sysDatabase);
                    }
                    if (sqlExpression2.getExprDataType().type == 0) continue;
                    String string3 = DataTypes.getJavaTypeDesc(sqlExpression2.getExprDataType().type);
                    String string4 = Property.get("xdb.sqlfunction." + string2 + ".arg" + n3, string3);
                    if ((string4 = string4.toUpperCase().replaceAll("ANYCHAR", "CHAR|VARCHAR|LONGVARCHAR|CLOB").replaceAll("ANYDATETIME", "DATE|TIME|TIMESTAMP").replaceAll("ANYNUMBER", "ANYINT|FLOAT|REAL|DOUBLE PRECISION|NUMERIC|DECIMAL").replaceAll("ANYINT", "BYTE|SMALLINT|INTEGER|BIGINT")).indexOf(string3) >= 0) continue;
                    n2 = 0;
                    break;
                }
                if (n2 != 0) break;
            }
            ++n4;
        }
        ExpressionType expressionType = new ExpressionType();
        string = Property.get("xdb.sqlfunction." + string2 + ".returntype");
        if (string != null) {
            void var8_17;
            n3 = string.indexOf("(");
            int n5 = -1;
            int n6 = -1;
            n = -1;
            if (n3 < 0) {
                n2 = DataTypes.getJavaType(string);
            } else {
                n2 = DataTypes.getJavaType(string.substring(0, n3).trim());
                switch (n2) {
                    case 6: 
                    case 7: 
                    case 12: {
                        int n7 = string.indexOf(")", n3 + 1);
                        if (n7 <= n3 + 1) break;
                        try {
                            n5 = Integer.parseInt(string.substring(n3 + 1, n7).trim());
                        }
                        catch (NumberFormatException numberFormatException) {}
                        break;
                    }
                    case 2: 
                    case 3: {
                        int n8 = string.indexOf(")", n3 + 1);
                        if (n8 <= n3 + 1) break;
                        int n9 = string.indexOf(",", n3 + 1);
                        if (n9 > n3 + 1 && n9 + 1 < n8) {
                            try {
                                int n10 = Integer.parseInt(string.substring(n3 + 1, n9).trim());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            try {
                                n = Integer.parseInt(string.substring(n9 + 1, n8).trim());
                            }
                            catch (NumberFormatException numberFormatException) {}
                            break;
                        }
                        try {
                            int n11 = Integer.parseInt(string.substring(n3 + 1, n8).trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        n = 0;
                        break;
                    }
                }
            }
            expressionType.setExpressionType(n2, n5, (int)var8_17, n);
        }
        return expressionType;
    }

    private static boolean isTimeStamp(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        if (sqlExpression.getExprDataType() == null || sqlExpression.getExprDataType().type == 0) {
            SqlExpression.setExpressionResultType(sqlExpression, sysDatabase);
        }
        if (sqlExpression.getExprDataType().type == 93) {
            return true;
        }
        if (sqlExpression.getExprDataType().isNumeric()) {
            return false;
        }
        try {
            Timestamp.valueOf(sqlExpression.getConstantValue().replaceAll("'", ""));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isTime(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        if (sqlExpression.getExprDataType() == null || sqlExpression.getExprDataType().type == 0) {
            SqlExpression.setExpressionResultType(sqlExpression, sysDatabase);
        }
        if (sqlExpression.getExprDataType().type == 92) {
            return true;
        }
        if (sqlExpression.getExprDataType().isNumeric()) {
            return false;
        }
        try {
            Time.valueOf(sqlExpression.getConstantValue().replaceAll("'", ""));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isDate(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        if (sqlExpression.getExprDataType() == null || sqlExpression.getExprDataType().type == 0) {
            SqlExpression.setExpressionResultType(sqlExpression, sysDatabase);
        }
        if (sqlExpression.getExprDataType().type == 91) {
            return true;
        }
        if (sqlExpression.getExprDataType().isNumeric()) {
            return false;
        }
        try {
            Date.valueOf(sqlExpression.getConstantValue().replaceAll("'", ""));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isNumeric(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        if (sqlExpression.getExprDataType() == null || sqlExpression.getExprDataType().type == 0) {
            SqlExpression.setExpressionResultType(sqlExpression, sysDatabase);
        }
        return sqlExpression.getExprDataType().isNumeric();
    }

    private static boolean isBit(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        if (sqlExpression.getExprDataType() == null || sqlExpression.getExprDataType().type == 0) {
            SqlExpression.setExpressionResultType(sqlExpression, sysDatabase);
        }
        return sqlExpression.getExprDataType().isBit();
    }

    private static boolean isCharacter(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        if (sqlExpression.getExprDataType() == null || sqlExpression.getExprDataType().type == 0) {
            SqlExpression.setExpressionResultType(sqlExpression, sysDatabase);
        }
        return sqlExpression.getExprType() != 2 || sqlExpression.getExprDataType().type == 12 || sqlExpression.getExprDataType().type == 1;
    }

    private static boolean isAlphaNumeric(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        if (sqlExpression.getExprDataType() == null) {
            SqlExpression.setExpressionResultType(sqlExpression, sysDatabase);
        }
        if (sqlExpression.getExprDataType().isNumeric()) {
            FunctionAnalysis.convertNumericToChar(sqlExpression);
        } else if (sqlExpression.getExprType() == 2) {
            try {
                Integer.parseInt(sqlExpression.rebuildString());
            }
            catch (Exception exception) {
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean isMacaddr(SqlExpression sqlExpression, SysDatabase sysDatabase) throws ColumnNotFoundException {
        return sqlExpression.getExprDataType().type == 119;
    }

    public static boolean isGroupFunction(int n) {
        return n == 76 || n == 82 || n == 80 || n == 81 || n == 75 || n == 78 || n == 181 || n == 182 || n == 79 || n == 183 || n == 184 || n == 166 || n == 168 || n == 167 || n == 164 || n == 165;
    }

    public static ExpressionType analyzeCurrDateTime(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(93, 26, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeAbbrev(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(1, 50, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeBroadcast(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(121, -1, -1, -1);
        return expressionType;
    }

    public static ExpressionType analyzeFamily(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(4, 0, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeHost(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(1, 50, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeHostmask(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(121, -1, -1, -1);
        return expressionType;
    }

    public static ExpressionType analyzeMasklen(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(4, 0, 0, 0);
        return expressionType;
    }

    public static ExpressionType analyzeNetmask(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(121, -1, -1, -1);
        return expressionType;
    }

    public static ExpressionType analyzeNetwork(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(120, -1, -1, -1);
        return expressionType;
    }

    public static ExpressionType analyzeSet_Masklen(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        SqlExpression sqlExpression2 = sqlExpression.getFunctionParams().get(0);
        ExpressionType expressionType2 = sqlExpression2.getExprDataType();
        if (expressionType2 == null || expressionType2.type != 121 && expressionType2.type != 120) {
            throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + " ( " + sqlExpression2.rebuildString() + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
        }
        expressionType.setExpressionType(expressionType2.type, expressionType2.length, expressionType2.precision, expressionType2.scale);
        return expressionType;
    }

    public static ExpressionType analyzeText(SqlExpression sqlExpression) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(1, 50, 0, 0);
        return expressionType;
    }
}

