/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.SyncAlterTableRenameColumn;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.parser.SqlAlterTable;
import com.edb.gridsql.parser.core.syntaxtree.RenameDef;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.util.HashMap;

public class SqlAlterRenameColumn
extends ObjectDepthFirst
implements IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlAlterRenameColumn.class);
    private XDBSessionContext client;
    private SqlAlterTable parent;
    private SysColumn column;
    private String oldName;
    private String newName;
    private String[] commands;

    public SqlAlterRenameColumn(SqlAlterTable sqlAlterTable, XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.parent = sqlAlterTable;
    }

    public Object visit(RenameDef renameDef, Object object) {
        Object var3_3 = null;
        IdentifierHandler identifierHandler = new IdentifierHandler();
        this.oldName = (String)renameDef.f2.accept(identifierHandler, object);
        this.newName = (String)renameDef.f4.accept(identifierHandler, object);
        return var3_3;
    }

    public String getNewName() {
        return this.newName;
    }

    public SysColumn getSysColumn() {
        return this.column;
    }

    public SqlAlterTable getParent() {
        return this.parent;
    }

    public boolean isPrepared() {
        return this.commands != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws Exception {
        try {
            SysTable sysTable = this.parent.getTable();
            sysTable.ensurePermission(this.client.getCurrentUser(), (short)6);
            this.column = sysTable.getSysColumn(this.oldName);
            if (this.column == null) {
                throw new XDBServerException("The Table Has Not A Column Named " + this.oldName);
            }
            if (sysTable != this.column.getSysTable()) {
                throw new XDBServerException("Can not modify inherited column");
            }
            if (sysTable.getSysColumn(this.newName) != null) {
                throw new XDBServerException("The Table Already Has A Column Named " + this.newName);
            }
            String string = Props.XDB_SQLCOMMAND_ALTERTABLE_RENAMECOLUMN;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("table", IdentifierHandler.quote(sysTable.getTableName()));
            hashMap.put("old_colname", IdentifierHandler.quote(this.oldName));
            hashMap.put("new_colname", IdentifierHandler.quote(this.newName));
            string = ParseCmdLine.substitute(string, hashMap);
            if (Props.XDB_SQLCOMMAND_ALTERTABLE_RENAMECOLUMN_TO_PARENT) {
                this.parent.addCommonCommand(string);
                this.commands = new String[0];
            } else {
                this.commands = new String[]{string};
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResult execute(Engine engine) throws Exception {
        try {
            engine.executeDDLOnMultipleNodes(this.commands, this.parent.getNodeList(), (IMetaDataUpdate)new SyncAlterTableRenameColumn(this), this.client);
            ExecutionResult executionResult = null;
            Object var4_3 = null;
            return executionResult;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            throw throwable;
        }
    }
}

