/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SyncCreateUser;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.CreateUser;
import com.edb.gridsql.parser.core.syntaxtree.NodeChoice;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlCreateUser
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlCreateUser.class);
    private XDBSessionContext client;
    private SysDatabase database;
    private String iUserName = null;
    private String iPassword = null;
    private int iUserClass = 1;
    private boolean prepared = false;

    public SqlCreateUser(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.database = xDBSessionContext.getSysDatabase();
    }

    public SqlCreateUser(SysDatabase sysDatabase, String string, String string2, int n) {
        this.database = sysDatabase;
        this.iUserName = string;
        this.iPassword = string2;
        this.iUserClass = n;
        this.prepared = true;
    }

    @Override
    public Object visit(CreateUser createUser, Object object) {
        Object var3_3 = null;
        IdentifierHandler identifierHandler = new IdentifierHandler();
        this.iUserName = (String)createUser.f2.accept(identifierHandler, object);
        this.iPassword = (String)createUser.f4.accept(identifierHandler, object);
        if (createUser.f5.present()) {
            switch (((NodeChoice)createUser.f5.node).which) {
                case 0: {
                    this.iUserClass = 0;
                    break;
                }
                case 1: {
                    this.iUserClass = 1;
                    break;
                }
                case 2: {
                    this.iUserClass = 2;
                }
            }
        }
        return var3_3;
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        List list = Collections.emptyList();
        return new LockSpecification<SysTable>(list, list);
    }

    @Override
    public Collection<DBNode> getNodeList() {
        return Collections.emptyList();
    }

    public String getPassword() {
        return this.iPassword;
    }

    public int getUserClass() {
        return this.iUserClass;
    }

    public String getUserClassStr() {
        switch (this.iUserClass) {
            case 0: {
                return "DBA";
            }
            case 1: {
                return "RESOURCE";
            }
            case 2: {
                return "STANDARD";
            }
        }
        return "RESOURCE";
    }

    public String getUserName() {
        return this.iUserName;
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }

    @Override
    public void prepare() throws Exception {
        if (!this.prepared) {
            if (this.client.getCurrentUser().getUserClass() != 0) {
                XDBSecurityException xDBSecurityException = new XDBSecurityException("Only DBA can create users");
                logger.throwing(xDBSecurityException);
                throw xDBSecurityException;
            }
            if (this.client.getSysDatabase().hasSysUser(this.iUserName)) {
                XDBServerException xDBServerException = new XDBServerException("User " + this.iUserName + " already exists");
                logger.throwing(xDBServerException);
                throw xDBServerException;
            }
        }
        this.prepared = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        try {
            if (!this.isPrepared()) {
                this.prepare();
            }
            SyncCreateUser syncCreateUser = new SyncCreateUser(this);
            MetaData metaData = MetaData.getMetaData();
            metaData.beginTransaction();
            try {
                syncCreateUser.execute(this.database);
                metaData.commitTransaction(syncCreateUser);
            }
            catch (Exception exception) {
                logger.catching(exception);
                metaData.rollbackTransaction();
                throw exception;
            }
            ExecutionResult executionResult = ExecutionResult.createSuccessResult(13);
            Object var6_6 = null;
            return executionResult;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            throw throwable;
        }
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }
}

