/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.MultinodeExecutor;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SyncDropTablespace;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.SysTablespace;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.DropTablespace;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlDropTableSpace
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlDropTableSpace.class);
    private XDBSessionContext client;
    private String tablespaceName;
    private SysTablespace tablespace;
    private HashMap<DBNode, String> statements = null;

    public SqlDropTableSpace(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
    }

    @Override
    public Object visit(DropTablespace dropTablespace, Object object) {
        this.tablespaceName = (String)dropTablespace.f2.accept(new IdentifierHandler(), object);
        return null;
    }

    public SysTablespace getTablespace() {
        return this.tablespace;
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public Collection<DBNode> getNodeList() {
        if (!this.isPrepared()) {
            try {
                this.prepare();
            }
            catch (Exception exception) {
                logger.catching(exception);
            }
        }
        return this.statements.keySet();
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        List list = Collections.emptyList();
        return new LockSpecification<SysTable>(list, list);
    }

    @Override
    public boolean isPrepared() {
        return this.statements != null;
    }

    @Override
    public void prepare() throws Exception {
        this.tablespace = MetaData.getMetaData().getTablespace(this.tablespaceName);
        if (this.tablespace == null) {
            throw new XDBServerException("Tablespace \"" + this.tablespaceName + "\" does not exist");
        }
        if (this.client.getCurrentUser().getUserClass() != 0) {
            throw new XDBSecurityException("Only DBA user can drop tablespaces");
        }
        this.statements = new HashMap();
        for (Integer n : this.tablespace.getLocations().keySet()) {
            DBNode dBNode = this.client.getSysDatabase().getDBNode(n);
            String string = "DROP TABLESPACE " + IdentifierHandler.quote(this.tablespaceName + "_" + n);
            this.statements.put(dBNode, string);
        }
    }

    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        if (!this.isPrepared()) {
            this.prepare();
        }
        SyncDropTablespace syncDropTablespace = new SyncDropTablespace(this);
        MetaData metaData = MetaData.getMetaData();
        metaData.beginTransaction();
        try {
            syncDropTablespace.execute(this.client);
            MultinodeExecutor multinodeExecutor = this.client.getMultinodeExecutor(this.getNodeList());
            multinodeExecutor.executeCommand(this.statements, true);
            metaData.commitTransaction(syncDropTablespace);
        }
        catch (Exception exception) {
            logger.catching(exception);
            metaData.rollbackTransaction();
            logger.throwing(exception);
            throw exception;
        }
        return ExecutionResult.createSuccessResult(20);
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }
}

