/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.misc.combinedresultset.ServerResultSetImpl;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.queryproc.QueryCombiner;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlDropTempTables
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlDropTempTables.class);
    private XDBSessionContext client;
    private String rsKey;
    private ResultSet rs;
    private Collection<String> dropOnNodes;
    private Collection<String> dropOnCoordinator;

    public SqlDropTempTables(String string, XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.rsKey = string;
    }

    public SqlDropTempTables(ResultSet resultSet, XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.rs = resultSet;
        if (resultSet instanceof ServerResultSetImpl) {
            ServerResultSetImpl serverResultSetImpl = (ServerResultSetImpl)resultSet;
            this.dropOnNodes = serverResultSetImpl.getFinalNodeTempTableList();
            this.dropOnCoordinator = serverResultSetImpl.getFinalCoordTempTableList();
        }
    }

    @Override
    public Collection<DBNode> getNodeList() {
        return Collections.emptyList();
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        List list = Collections.emptyList();
        return new LockSpecification<SysTable>(list, list);
    }

    @Override
    public boolean isPrepared() {
        return this.rs != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws Exception {
        try {
            if (this.isPrepared()) {
                Object var3_1 = null;
                return;
            }
            this.rs = this.client.getResultSet(this.rsKey);
            if (this.rs instanceof ServerResultSetImpl) {
                ServerResultSetImpl serverResultSetImpl = (ServerResultSetImpl)this.rs;
                this.dropOnNodes = serverResultSetImpl.getFinalNodeTempTableList();
                this.dropOnCoordinator = serverResultSetImpl.getFinalCoordTempTableList();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
        Object var3_2 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        try {
            Object object;
            if (!this.isPrepared()) {
                this.prepare();
            }
            try {
                if (this.rs != null) {
                    try {
                        this.rs.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (this.dropOnNodes != null && !this.dropOnNodes.isEmpty()) {
                    engine.dropNodeTempTables(this.dropOnNodes, this.getNodeList(), this.client);
                }
                if (this.dropOnCoordinator != null && !this.dropOnCoordinator.isEmpty()) {
                    object = new QueryCombiner(this.client, "");
                    ((QueryCombiner)object).dropTempTables(this.dropOnCoordinator);
                }
                Object var4_4 = null;
                this.client.closeCursor(this.rsKey);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.client.closeCursor(this.rsKey);
                throw throwable;
            }
            object = ExecutionResult.createSuccessResult(19);
            Object var6_7 = null;
            return object;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            throw throwable;
        }
    }

    @Override
    public boolean needCoordinatorConnection() {
        return true;
    }
}

