/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.ActivityLog;
import com.edb.gridsql.common.ColumnMetaData;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IParametrizedSql;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.engine.io.DataTypes;
import com.edb.gridsql.exception.ColumnNotFoundException;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.optimizer.OrderByElement;
import com.edb.gridsql.optimizer.QueryCondition;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.RelationNode;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.Command;
import com.edb.gridsql.parser.ExpressionType;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.Lexer;
import com.edb.gridsql.parser.ParserHelper;
import com.edb.gridsql.parser.core.syntaxtree.Select;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.OrderByClauseHandler;
import com.edb.gridsql.parser.handler.QueryTreeHandler;
import com.edb.gridsql.parser.handler.QueryTreeTracker;
import com.edb.gridsql.queryproc.QueryProcessor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlSelect
extends ObjectDepthFirst
implements IXDBSql,
IPreparable,
IParametrizedSql {
    private static final XLogger logger = XLogger.getLogger(SqlSelect.class);
    private XDBSessionContext client;
    SysTable targetTable;
    public QueryTree aQueryTree = null;
    private SysDatabase database;
    private Command commandToExecute;
    private QueryProcessor qProcessor;
    private String selectString;
    public String selectType;
    public Vector selectList;
    public Vector orderList;
    public Vector fromList;
    public Vector whereList;
    public Vector groupList;
    public Vector havingList;
    private String specialMetadataRequest = null;
    private boolean isParameterPrepared = false;
    private HashSet<String> noPermissionCheck = new HashSet();

    public SqlSelect(XDBSessionContext xDBSessionContext) {
        this.orderList = new Vector();
        this.selectList = new Vector();
        this.fromList = new Vector();
        this.whereList = new Vector();
        this.groupList = new Vector();
        this.havingList = new Vector();
        this.client = xDBSessionContext;
        this.database = MetaData.getMetaData().getSysDatabase(xDBSessionContext.getDBName());
        this.commandToExecute = new Command(1, this, new QueryTreeTracker(), xDBSessionContext);
        this.aQueryTree = new QueryTree();
    }

    public SysTable getTargetTable(String string) throws XDBServerException {
        if (this.targetTable == null) {
            this.targetTable = this.commandToExecute.getClientContext().getSysDatabase().getSysTable(string);
        }
        return this.targetTable;
    }

    @Override
    public Object visit(Select select, Object object) {
        QueryTreeHandler queryTreeHandler = new QueryTreeHandler(this.commandToExecute);
        select.f0.accept(queryTreeHandler, this.aQueryTree);
        OrderByClauseHandler orderByClauseHandler = new OrderByClauseHandler(this.commandToExecute);
        select.f1.accept(orderByClauseHandler, this.aQueryTree);
        this.aQueryTree.setOrderByList(orderByClauseHandler.orderByList);
        this.preProcessOrderByList();
        this.FillSQLExpressionInformation(this.aQueryTree.getOrderByList());
        select.f2.accept(queryTreeHandler, this.aQueryTree);
        select.f3.accept(queryTreeHandler, this.aQueryTree);
        this.preProcessUnionList();
        return null;
    }

    private void preProcessUnionList() {
        if (this.aQueryTree.isHasUnion()) {
            for (int i = 0; i < this.aQueryTree.getUnionQueryTreeList().size(); ++i) {
                this.aQueryTree.getUnionQueryTreeList().get(i).checkExpressionTypes(this.aQueryTree.getProjectionList());
            }
        }
    }

    private void preProcessOrderByList() {
        for (OrderByElement orderByElement : this.aQueryTree.getOrderByList()) {
            SqlExpression sqlExpression = orderByElement.orderExpression;
            String string = sqlExpression.rebuildString();
            try {
                int n = Integer.parseInt(string);
                int n2 = n - 1;
                if (n2 >= this.aQueryTree.getProjectionList().size() || n2 < 0) {
                    throw new XDBServerException(ErrorMessageRepository.ORDERBY_CLAUSE_POINTS_TO_ILLEGAL_PROJ_COLUMN, 0, ErrorMessageRepository.ORDERBY_CLAUSE_POINTS_TO_ILLEGAL_PROJ_COLUMN_CODE);
                }
                SqlExpression sqlExpression2 = this.aQueryTree.getProjectionList().get(n2);
                orderByElement.orderExpression = new SqlExpression();
                SqlExpression.copy(sqlExpression2, orderByElement.orderExpression);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private void FillSQLExpressionInformation(List<OrderByElement> list) throws ColumnNotFoundException {
        Vector<SqlExpression> vector = new Vector<SqlExpression>();
        for (OrderByElement object2 : list) {
            vector.add(object2.orderExpression);
        }
        QueryTreeHandler.checkAndExpand(vector, this.aQueryTree.getRelationNodeList(), this.database, this.commandToExecute);
        List<SqlExpression> list2 = QueryTreeHandler.checkAndFillTableNames(vector, this.aQueryTree.getRelationNodeList(), this.aQueryTree.getProjectionList(), 4, this.commandToExecute.getaQueryTreeTracker(), this.database);
        this.aQueryTree.getOrderByOrphans().addAll((Collection<SqlExpression>)list2);
        Enumeration<SqlExpression> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SqlExpression sqlExpression = enumeration.nextElement();
            sqlExpression.rebuildExpression();
            SqlExpression.setExpressionResultType(sqlExpression, this.database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getCost() {
        try {
            try {
                if (!this.isPrepared()) {
                    this.prepare();
                }
                if (this.specialMetadataRequest == null) return this.qProcessor.getCost();
                return 0L;
            }
            catch (Exception exception) {
                return 0L;
            }
        }
        catch (Throwable throwable2) {
            Object var4_8 = null;
            throw throwable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        try {
            try {
                if (!this.isPrepared()) {
                    this.prepare();
                }
                if (this.specialMetadataRequest == null) return this.qProcessor.getLockSpecs();
                Set set = Collections.emptySet();
                return new LockSpecification<SysTable>(set, set);
            }
            catch (Exception exception) {
                return null;
            }
        }
        catch (Throwable throwable2) {
            Object var4_9 = null;
            throw throwable2;
        }
    }

    @Override
    public Collection<DBNode> getNodeList() {
        try {
            if (!this.isPrepared()) {
                this.prepare();
            }
            if (this.specialMetadataRequest != null) {
                Set<DBNode> set = Collections.emptySet();
                return set;
            }
            return this.qProcessor.getNodeList();
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    public void addSkipPermissionCheck(String string) {
        this.noPermissionCheck.add(string.toUpperCase());
    }

    @Override
    public boolean isPrepared() {
        return this.specialMetadataRequest != null || this.qProcessor != null && this.qProcessor.isPrepared();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws Exception {
        try {
            if (this.specialMetadataRequest != null) {
                Object var2_1 = null;
                return;
            }
            this.qProcessor = new QueryProcessor(this.client, this.aQueryTree);
            if (!this.noPermissionCheck.isEmpty()) {
                this.qProcessor.setSkipPermissionCheck(this.noPermissionCheck);
            }
            this.qProcessor.prepare();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            throw throwable;
        }
        Object var2_2 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        ExecutionResult executionResult;
        block15: {
            Object object;
            block14: {
                try {
                    if (!this.isPrepared()) {
                        this.prepare();
                    }
                    if (this.getParamCount() > 0 && this.specialMetadataRequest == null) {
                        if (!this.isParameterPrepared) {
                            this.qProcessor.prepareParameters(this.commandToExecute.getParameters());
                            this.isParameterPrepared = true;
                        }
                        this.qProcessor.resetExecPlan(this.commandToExecute.getParameters());
                    }
                    if (this.specialMetadataRequest != null) {
                        Connection connection = this.client.getAndSetCoordinatorConnection();
                        try {
                            ResultSet resultSet;
                            List<SqlExpression> list = this.commandToExecute.getParameters();
                            if (list == null) {
                                object = connection.createStatement();
                                resultSet = object.executeQuery(this.specialMetadataRequest);
                            } else {
                                for (int n = list.size(); n > 0; this.specialMetadataRequest = this.specialMetadataRequest.replaceAll("\\$" + n, "?"), --n) {
                                }
                                object = connection.prepareStatement(this.specialMetadataRequest);
                                int n = 0;
                                while (n < list.size()) {
                                    SqlExpression sqlExpression = list.get(n++);
                                    DataTypes.setParameter((PreparedStatement)object, n, sqlExpression.getParamValue(), sqlExpression.getExprDataType().type);
                                }
                                resultSet = object.executeQuery();
                            }
                            object = ExecutionResult.createResultSetResult(0, resultSet);
                        }
                        catch (SQLException sQLException) {
                            logger.catching(sQLException);
                            connection.rollback();
                            ExecutionResult executionResult2 = ExecutionResult.createErrorResult(sQLException);
                            Object var9_13 = null;
                            if (!Props.XDB_ENABLE_ACTIVITY_LOG) return executionResult2;
                            ActivityLog.endRequest(this.client.getStatementId());
                            return executionResult2;
                        }
                        Object var9_12 = null;
                        if (!Props.XDB_ENABLE_ACTIVITY_LOG) return object;
                        break block14;
                    }
                    if (Props.XDB_ENABLE_ACTIVITY_LOG) {
                        ActivityLog.startRequest(this.client.getStatementId(), this.selectString);
                    }
                    executionResult = this.qProcessor.execute(engine);
                    break block15;
                }
                catch (Throwable throwable) {
                    Object var9_15 = null;
                    if (!Props.XDB_ENABLE_ACTIVITY_LOG) throw throwable;
                    ActivityLog.endRequest(this.client.getStatementId());
                    throw throwable;
                }
            }
            ActivityLog.endRequest(this.client.getStatementId());
            return object;
        }
        Object var9_14 = null;
        if (!Props.XDB_ENABLE_ACTIVITY_LOG) return executionResult;
        ActivityLog.endRequest(this.client.getStatementId());
        return executionResult;
    }

    public ColumnMetaData[] getMetaData() throws Exception {
        if (!this.isPrepared()) {
            this.prepare();
        }
        return this.qProcessor.getMetaData();
    }

    @Override
    public boolean needCoordinatorConnection() {
        return this.qProcessor == null ? false : this.qProcessor.needCoordinatorConnection();
    }

    public boolean manualParse(String string) {
        Object object;
        Lexer lexer;
        String string2;
        block42: {
            int n;
            string2 = null;
            this.selectString = string;
            lexer = new Lexer(string);
            if (!lexer.hasMoreTokens() || !lexer.nextToken().equalsIgnoreCase("SELECT")) {
                return false;
            }
            if (!lexer.hasMoreTokens()) {
                return false;
            }
            string2 = lexer.nextToken();
            if (string2.equalsIgnoreCase("DISTINCT") || string2.equalsIgnoreCase("UNIQUE")) {
                this.aQueryTree.setDistinct(true);
            }
            if (!(lexer = new Lexer(string.substring((n = string.toUpperCase().indexOf(" FROM ")) + 6))).hasMoreTokens()) {
                return false;
            }
            String string3 = lexer.nextToken();
            if (string3.equals("(")) {
                int n2 = 0;
                while (lexer.peekToken(n2++) != null && lexer.peekToken(n2).equals("(")) {
                }
                string3 = lexer.peekToken(n2);
            }
            if (string3.startsWith("pg_") || string3.equalsIgnoreCase("dual") || string3.equalsIgnoreCase("INFORMATION_SCHEMA") || string3.equalsIgnoreCase("dbo") || string3.equalsIgnoreCase("sys")) {
                this.specialMetadataRequest = string;
                this.handleMetadataParams(string);
                return true;
            }
            if (string.indexOf("SELECT", 6) > 0) {
                return false;
            }
            QueryTreeTracker queryTreeTracker = this.commandToExecute.getaQueryTreeTracker();
            queryTreeTracker.registerTree(this.aQueryTree);
            RelationNode relationNode = this.aQueryTree.newRelationNode();
            relationNode.setNodeType(2);
            relationNode.setTableName(string3);
            relationNode.setTemporaryTable(this.client.getTempTableName(string3) != null);
            relationNode.setClient(this.commandToExecute.getClientContext());
            relationNode.setAlias("");
            if (lexer.hasMoreTokens() && !(string2 = lexer.nextToken()).equals(";") && !string2.equalsIgnoreCase("WHERE") && !string2.equalsIgnoreCase("ORDER")) {
                relationNode.setAlias(string2);
                if (lexer.hasMoreTokens() && !(string2 = lexer.nextToken()).equalsIgnoreCase("WHERE") && !string2.equalsIgnoreCase("ORDER")) {
                    return false;
                }
            }
            SysTable sysTable = this.client.getSysDatabase().getSysTable(string3);
            if (!ParserHelper.parseProjectionsForSingleTable(string.substring(7, n), this.aQueryTree, relationNode, sysTable, this.client)) {
                return false;
            }
            QueryTreeHandler.FillAllExprDataTypes(this.aQueryTree, this.database);
            if (string2.equals(";")) {
                return true;
            }
            int n3 = string.toUpperCase().indexOf(" WHERE ", n);
            if (n3 > 0) {
                lexer = new Lexer(string.substring(n3 + 6));
                do {
                    if ((object = ParserHelper.getSimpleCondition(lexer, this.client.getSysDatabase().getSysTable(string3), this.aQueryTree, this.client)) == null) {
                        return false;
                    }
                    QueryTreeHandler.ProcessWhereCondition((QueryCondition)object, this.aQueryTree, queryTreeTracker, this.database);
                    if (lexer.hasMoreTokens()) continue;
                    return true;
                } while ((string2 = lexer.nextToken()).equalsIgnoreCase("AND"));
            } else {
                int n4 = string.toUpperCase().indexOf(" ORDER ", n);
                if (n4 > 0) {
                    lexer = new Lexer(string.substring(n4));
                    string2 = lexer.nextToken();
                }
            }
            if (string2.equals(";")) {
                return true;
            }
            if (!string2.equalsIgnoreCase("ORDER")) {
                return false;
            }
            if (!lexer.hasMoreTokens() || !lexer.nextToken().equalsIgnoreCase("BY")) {
                return false;
            }
            if (!lexer.hasMoreTokens()) {
                return false;
            }
            object = null;
            do {
                int n5;
                String string4;
                OrderByElement orderByElement = null;
                String string5 = lexer.nextToken();
                if (lexer.hasMoreTokens()) {
                    object = lexer.nextToken();
                    if (((String)object).equals(".")) {
                        if (!((String)object).equalsIgnoreCase(string3) && !((String)object).equalsIgnoreCase(relationNode.getAlias())) {
                            return false;
                        }
                        if (!lexer.hasMoreTokens()) {
                            return false;
                        }
                        string4 = lexer.nextToken();
                    } else {
                        string4 = string5;
                    }
                } else {
                    string4 = string5;
                }
                if (sysTable.getSysColumn(string4) == null) {
                    try {
                        n5 = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                    orderByElement = new OrderByElement();
                    orderByElement.orderExpression = this.aQueryTree.getProjectionList().get(n5 - 1);
                    orderByElement.orderDirection = 1;
                    this.aQueryTree.getOrderByList().add(orderByElement);
                } else {
                    n5 = 0;
                    for (SqlExpression sqlExpression : this.aQueryTree.getProjectionList()) {
                        if (sqlExpression.getExprType() != 4 || !string4.equalsIgnoreCase(sqlExpression.getColumn().columnName) && !string4.equalsIgnoreCase(sqlExpression.getColumn().columnAlias)) continue;
                        orderByElement = new OrderByElement();
                        orderByElement.orderExpression = sqlExpression;
                        this.aQueryTree.getOrderByList().add(orderByElement);
                        n5 = 1;
                        break;
                    }
                    if (n5 == 0) {
                        return false;
                    }
                }
                if (((String)object).equalsIgnoreCase("ASC")) {
                    orderByElement.orderDirection = 1;
                    if (!lexer.hasMoreTokens()) {
                        return true;
                    }
                    object = lexer.nextToken();
                } else if (((String)object).equalsIgnoreCase("DESC")) {
                    orderByElement.orderDirection = 2;
                    if (!lexer.hasMoreTokens()) {
                        return true;
                    }
                    object = lexer.nextToken();
                }
                if (object == null || ((String)object).equals(";")) break block42;
            } while (((String)object).equals(","));
            return false;
        }
        this.preProcessOrderByList();
        this.FillSQLExpressionInformation(this.aQueryTree.getOrderByList());
        if (object == null) {
            return true;
        }
        if (!lexer.hasMoreTokens()) {
            return true;
        }
        string2 = lexer.nextToken();
        if (!string2.equals(";")) {
            return false;
        }
        return !lexer.hasMoreTokens();
    }

    @Override
    public int getParamCount() throws XDBServerException {
        return this.commandToExecute.getParamCount();
    }

    @Override
    public void setParamValue(int n, String string) throws ArrayIndexOutOfBoundsException, XDBServerException {
        this.commandToExecute.getParameter(n + 1).setParamValue(string);
    }

    @Override
    public void setParamValues(String[] stringArray) throws ArrayIndexOutOfBoundsException, XDBServerException {
        for (int i = 0; i < stringArray.length; ++i) {
            this.commandToExecute.getParameter(i + 1).setParamValue(stringArray[i]);
        }
    }

    @Override
    public int getParamDataType(int n) throws ArrayIndexOutOfBoundsException, XDBServerException {
        ExpressionType expressionType = this.commandToExecute.getParameter(n + 1).getExprDataType();
        return expressionType == null ? 0 : expressionType.type;
    }

    @Override
    public int[] getParamDataTypes() throws ArrayIndexOutOfBoundsException, XDBServerException {
        int[] nArray = new int[this.commandToExecute.getParamCount()];
        for (int i = 0; i < this.commandToExecute.getParamCount(); ++i) {
            ExpressionType expressionType = this.commandToExecute.getParameter(i + 1).getExprDataType();
            nArray[i] = expressionType == null ? 0 : expressionType.type;
        }
        return nArray;
    }

    @Override
    public String getParamValue(int n) throws ArrayIndexOutOfBoundsException, XDBServerException {
        return this.commandToExecute.getParameter(n + 1).getParamValue();
    }

    @Override
    public String[] getParamValues() throws ArrayIndexOutOfBoundsException, XDBServerException {
        String[] stringArray = new String[this.commandToExecute.getParamCount()];
        for (int i = 0; i < this.commandToExecute.getParamCount(); ++i) {
            stringArray[i] = this.commandToExecute.getParameter(i + 1).getParamValue();
        }
        return null;
    }

    @Override
    public void setParamDataType(int n, int n2) throws ArrayIndexOutOfBoundsException, XDBServerException {
        ExpressionType expressionType = this.commandToExecute.getParameter(n + 1).getExprDataType();
        if (expressionType == null) {
            expressionType = new ExpressionType();
            this.commandToExecute.getParameter(n + 1).setExprDataType(expressionType);
        }
        expressionType.type = n2;
    }

    @Override
    public void setParamDataTypes(int[] nArray) throws ArrayIndexOutOfBoundsException, XDBServerException {
        int n;
        if (this.specialMetadataRequest != null) {
            for (n = nArray.length; n > 0; --n) {
                this.specialMetadataRequest = this.specialMetadataRequest.replaceAll("\\$" + n, "?");
            }
        }
        for (n = 0; n < nArray.length; ++n) {
            ExpressionType expressionType = this.commandToExecute.getParameter(n + 1).getExprDataType();
            if (expressionType == null) {
                expressionType = new ExpressionType();
                this.commandToExecute.getParameter(n + 1).setExprDataType(expressionType);
            }
            expressionType.type = nArray[n];
        }
    }

    public void setSelectString(String string) {
        this.selectString = string;
    }

    private void handleMetadataParams(String string) {
        String[] stringArray = string.split("\\$");
        for (int i = 1; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            int n = 0;
            while (string2.length() >= 1 && string2.charAt(n) >= '0' && string2.charAt(n) <= '9') {
                ++n;
            }
            if (n <= 0) continue;
            SqlExpression sqlExpression = new SqlExpression();
            sqlExpression.setExprType(1024);
            sqlExpression.setExprDataType(new ExpressionType());
            int n2 = Integer.parseInt(string2.substring(0, n));
            this.commandToExecute.registerParameter(n2, sqlExpression);
            sqlExpression.setParamNumber(Integer.valueOf(string2.substring(0, n)));
        }
    }
}

