/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.planner;

import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.NodeDBConnectionInfo;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.partitions.HashPartitionMap;
import com.edb.gridsql.metadata.partitions.PartitionMap;
import com.edb.gridsql.metadata.partitions.ReplicatedPartitionMap;
import com.edb.gridsql.parser.ExpressionType;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.planner.Leaf;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StepDetail
implements Serializable {
    private static final long serialVersionUID = 644465276880869900L;
    private static final XLogger logger = XLogger.getLogger(StepDetail.class);
    private transient XDBSessionContext client;
    public int requestId;
    public int stepNo;
    public boolean isProducer;
    public boolean isConsumer;
    public String queryString;
    public String targetTable;
    public String targetSchema;
    public List<String> dropList;
    private short destType;
    private int destNode;
    public ArrayList<Integer> consumerNodeList;
    public boolean combineOnCoordFirst = false;
    private int hashColumnPosition = 0;
    private int[] groupHashColumns;
    private ExpressionType hashDataType = null;
    private PartitionMap partitionMap;
    public static final short DEST_TYPE_BROADCAST = 1;
    public static final short DEST_TYPE_COORD = 2;
    public static final short DEST_TYPE_ONE = 3;
    public static final short DEST_TYPE_HASH = 4;
    public static final short DEST_TYPE_BROADCAST_AND_COORD = 5;
    public static final short DEST_TYPE_COORD_FINAL = 6;
    public static final short DEST_TYPE_NODEID = 7;
    private transient SysDatabase database;
    public boolean isFinalUnionPart = false;
    public short unionResultGroup = 0;
    public List finalUnionPartSortInfo;
    public boolean finalUnionPartIsDistinct = false;
    protected String nonProjectionSelectPart;
    protected boolean isLookupStep = false;
    private boolean isOuterStep = false;
    public boolean suppressSendingNodeId = false;
    public NodeDBConnectionInfo[] nodeInfos = null;
    private String indexColumnString;
    private String insertColumnString;
    private String outerNodeIdColumn;
    private short serialColumnPosition = (short)-1;
    private Map<Integer, String> createTablespaceMap;

    public StepDetail() {
    }

    public StepDetail(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.dropList = new ArrayList<String>();
        this.database = MetaData.getMetaData().getSysDatabase(xDBSessionContext.getDBName());
        if (Props.XDB_USE_LOAD_FOR_STEP) {
            Collection<DBNode> collection = this.database.getDBNodeList();
            this.nodeInfos = new NodeDBConnectionInfo[collection.size()];
            int n = 0;
            for (DBNode dBNode : collection) {
                this.nodeInfos[n++] = dBNode.getNodeDBConnectionInfo();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDropTable(String string) {
        this.dropList.add(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNodeId(String string) {
        int n = this.partitionMap.getPartitions(string).iterator().next();
        return n;
    }

    public StepDetail copy() {
        StepDetail stepDetail = new StepDetail(this.client);
        stepDetail.requestId = this.requestId;
        stepDetail.stepNo = this.stepNo;
        stepDetail.isProducer = this.isProducer;
        stepDetail.isConsumer = this.isConsumer;
        stepDetail.queryString = this.queryString;
        stepDetail.nonProjectionSelectPart = this.nonProjectionSelectPart;
        stepDetail.targetTable = this.targetTable;
        stepDetail.targetSchema = this.targetSchema;
        stepDetail.dropList = this.dropList;
        stepDetail.destType = this.destType;
        stepDetail.destNode = this.destNode;
        stepDetail.combineOnCoordFirst = this.combineOnCoordFirst;
        stepDetail.hashColumnPosition = this.hashColumnPosition;
        stepDetail.hashDataType = this.hashDataType;
        stepDetail.partitionMap = this.partitionMap;
        stepDetail.consumerNodeList = this.consumerNodeList;
        stepDetail.database = this.database;
        stepDetail.suppressSendingNodeId = this.suppressSendingNodeId;
        stepDetail.nodeInfos = this.nodeInfos;
        stepDetail.indexColumnString = this.indexColumnString;
        stepDetail.insertColumnString = this.insertColumnString;
        stepDetail.isOuterStep = this.isOuterStep;
        stepDetail.outerNodeIdColumn = this.outerNodeIdColumn;
        stepDetail.serialColumnPosition = this.serialColumnPosition;
        stepDetail.createTablespaceMap = this.createTablespaceMap;
        return stepDetail;
    }

    public String toString() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertLeafToStep(Leaf leaf, Leaf leaf2, Leaf leaf3, int n, boolean bl) {
        this.stepNo = leaf.getLeafStepNo();
        this.isLookupStep = leaf.isLookupStep();
        this.outerNodeIdColumn = leaf.getOuterNodeIdColumn();
        this.serialColumnPosition = leaf.getSerialColumnPosition();
        if (leaf2 == null) {
            this.isConsumer = false;
        } else if (!(leaf2.isCombineOnMain() || leaf.isCombinerStep() || leaf.isExtraStep())) {
            this.isConsumer = true;
        } else {
            this.isConsumer = false;
            if (leaf2.isCombinerStep() && leaf.groupByColumns.size() - leaf.getAddedGroupCount() > 0) {
                this.isConsumer = true;
            }
        }
        if (!(leaf.isCombineOnMain() || leaf.isCombinerStep() || leaf.isExtraStep())) {
            this.isProducer = true;
        } else {
            this.isProducer = false;
            if (leaf.isCombinerStep() && leaf.groupByColumns.size() > 0) {
                this.isProducer = true;
            }
        }
        this.targetTable = leaf.getTargetTableName();
        this.targetSchema = leaf.getTempTargetCreateStmt();
        this.destType = (short)-1;
        if (this.isProducer) {
            this.updateProducerStepInfo(leaf, leaf2, leaf3, this);
        }
        if (n > 0 && !bl) {
            this.addNodeIdToStep(n, leaf2 != null);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertLeafToStepCoord(Leaf leaf, Leaf leaf2, Leaf leaf3, int n, boolean bl) {
        this.stepNo = leaf.getLeafStepNo();
        this.outerNodeIdColumn = leaf.getOuterNodeIdColumn();
        if (leaf2 == null) {
            this.isConsumer = true;
        } else {
            if (!(leaf2.isCombineOnMain() || leaf.isCombinerStep() || leaf.isExtraStep())) {
                this.isConsumer = leaf2.subplan != null;
            } else {
                this.isConsumer = true;
                if (leaf2.isCombinerStep() && leaf.groupByColumns.size() - leaf.getAddedGroupCount() > 0) {
                    this.isConsumer = false;
                }
            }
            if (leaf3 != null && leaf3.isExtraStep()) {
                this.isConsumer = true;
            }
        }
        if (leaf.isCombineOnMain() || leaf.isCombinerStep() || leaf.isExtraStep()) {
            this.isProducer = true;
            if (leaf.isCombinerStep() && leaf.groupByColumns.size() - leaf.getAddedGroupCount() > 0) {
                this.isProducer = false;
            }
        } else {
            this.isProducer = false;
        }
        if (!this.isConsumer && !this.isProducer) {
            return;
        }
        this.targetTable = leaf.getTargetTableName();
        this.targetSchema = leaf.getTempTargetCreateStmt();
        this.destType = (short)-1;
        if (this.isProducer) {
            this.updateProducerStepInfo(leaf, leaf2, leaf3, this);
        }
        if (n > 0 && !bl) {
            this.addNodeIdToStep(n, leaf2 != null);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateProducerStepInfo(Leaf leaf, Leaf leaf2, Leaf leaf3, StepDetail stepDetail) {
        block26: {
            int n;
            SysTable sysTable = null;
            stepDetail.queryString = leaf.getSelect();
            stepDetail.nonProjectionSelectPart = leaf.getNonProjectionSelectPart();
            stepDetail.dropList = new ArrayList<String>(leaf.tempTableDropList);
            if (leaf2 == null) {
                stepDetail.setDestTypeCoordinator();
                break block26;
            }
            if (leaf2.subplan != null) {
                stepDetail.setDestTypeCoordinator();
                break block26;
            }
            if (leaf3 != null && leaf3.isExtraStep()) {
                stepDetail.setDestTypeBroadcastAndCoordinator();
                break block26;
            }
            if (leaf2.isCombinerStep()) {
                if (leaf.groupByColumns.size() - leaf.getAddedGroupCount() > 0) {
                    HashPartitionMap hashPartitionMap = new HashPartitionMap();
                    Collection<DBNode> collection = this.database.getDBNodeList();
                    ArrayList<Integer> arrayList = new ArrayList<Integer>(collection.size());
                    for (DBNode object2 : collection) {
                        arrayList.add(object2.getNodeId());
                    }
                    hashPartitionMap.generateDistribution(arrayList);
                    Leaf.Projection projection = leaf.groupByColumns.get(0);
                    if (projection.groupByPosition == 0) {
                        boolean n2 = true;
                        for (Leaf.Projection projection2 : leaf.selectColumns) {
                            void var10_16;
                            if (projection2.projectString.equalsIgnoreCase(projection.projectString)) {
                                stepDetail.setDestTypeHash((int)var10_16, hashPartitionMap);
                                ExpressionType expressionType = new ExpressionType();
                                expressionType.setExpressionType(12, 0, 0, 0);
                                stepDetail.setHashDataType(expressionType);
                            }
                            ++var10_16;
                        }
                    } else if (leaf.groupByColumns.size() == 1) {
                        stepDetail.setDestTypeHash(projection.groupByPosition, hashPartitionMap);
                        ExpressionType expressionType = new ExpressionType();
                        expressionType.setExpressionType(12, 0, 0, 0);
                        stepDetail.setHashDataType(expressionType);
                    } else {
                        int[] nArray = new int[leaf.groupByColumns.size()];
                        int n2 = 0;
                        for (Leaf.Projection projection3 : leaf.groupByColumns) {
                            nArray[n2++] = projection3.groupByPosition;
                            if (Props.XDB_MAX_GROUP_HASH_COUNT <= 0 || n2 < Props.XDB_MAX_GROUP_HASH_COUNT) continue;
                            break;
                        }
                        stepDetail.setDestTypeHashList(nArray, hashPartitionMap);
                        ExpressionType expressionType = new ExpressionType();
                        expressionType.setExpressionType(12, 0, 0, 0);
                        stepDetail.setHashDataType(expressionType);
                    }
                } else {
                    stepDetail.setDestTypeCoordinator();
                }
                break block26;
            }
            if (leaf2.isCombineOnMain() || leaf.isCombinerStep() || leaf.isExtraStep()) {
                stepDetail.setDestTypeCoordinator();
                break block26;
            }
            if (leaf2.getHashColumn() != null) {
                sysTable = SysTable.getPartitionTable(leaf2.getHashTableName(), this.database);
                n = 0;
                for (Leaf.Projection projection : leaf.selectColumns) {
                    ++n;
                    if (!leaf2.getHashColumn().equals(Leaf.normalizeHashColumnName(projection.projectString))) continue;
                    stepDetail.setDestTypeHash(n, sysTable.getPartitionMap());
                    stepDetail.setHashDataType(new ExpressionType(sysTable.getPartitionedColumn()));
                    return;
                }
            }
            try {
                sysTable = SysTable.getPartitionTable(leaf2.getTableName(), this.database);
            }
            catch (Exception exception) {
                stepDetail.setDestTypeBroadcast();
                return;
            }
            if (sysTable.getPartitionScheme() == 1) {
                stepDetail.setDestTypeOne(sysTable.getPartitionMap().joinPartitions().iterator().next());
                break block26;
            }
            if (sysTable.getPartitionScheme() == 2) {
                stepDetail.setDestTypeOne(this.database.getCoordinatorNodeID());
                break block26;
            }
            if (leaf2.isSingleStepCorrelated() && leaf2.getSingleCorrelatedHash() != null) {
                n = 1;
                for (Leaf.Projection projection : leaf.selectColumns) {
                    if (leaf2.getSingleCorrelatedHash().equals(Leaf.normalizeHashColumnName(projection.projectString))) {
                        stepDetail.setDestTypeHash(n, sysTable.getPartitionMap());
                        stepDetail.setHashDataType(new ExpressionType(sysTable.getPartitionedColumn()));
                        break block26;
                    }
                    ++n;
                }
                break block26;
            }
            stepDetail.setDestTypeBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertLeafToStepCorrDown1(Leaf leaf) {
        this.stepNo = 1000 + leaf.getLeafStepNo();
        this.isConsumer = true;
        this.isProducer = true;
        this.outerNodeIdColumn = leaf.getOuterNodeIdColumn();
        this.queryString = leaf.getCorrelatedSelectString();
        this.targetTable = leaf.correlatedJoinTableName + "A";
        this.targetSchema = leaf.getCreateCorrelatedTableString().replaceFirst(leaf.correlatedJoinTableName, this.targetTable);
        HashPartitionMap hashPartitionMap = new HashPartitionMap();
        Collection<DBNode> collection = this.database.getDBNodeList();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(collection.size());
        for (DBNode dBNode : collection) {
            arrayList.add(dBNode.getNodeId());
        }
        hashPartitionMap.generateDistribution(arrayList);
        this.setDestTypeHash(1, hashPartitionMap);
        this.setHashDataType(leaf.correlatedChildHashableExpression.getExprDataType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertLeafToStepCorrDown2(Leaf leaf) {
        this.stepNo = 1000 + leaf.getLeafStepNo();
        this.isConsumer = true;
        this.isProducer = true;
        this.outerNodeIdColumn = leaf.getOuterNodeIdColumn();
        this.targetTable = leaf.correlatedJoinTableName;
        this.targetSchema = leaf.getCreateCorrelatedTableString();
        this.queryString = "SELECT DISTINCT * FROM " + IdentifierHandler.quote(this.targetTable + "A");
        this.dropList.add(this.targetTable + "A");
        this.setDestTypeBroadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertLeafToStepCorrelatedDown(Leaf leaf, Leaf leaf2) {
        this.stepNo = leaf.getLeafStepNo();
        this.isConsumer = true;
        this.isProducer = true;
        this.outerNodeIdColumn = leaf.getOuterNodeIdColumn();
        this.targetTable = leaf2.getTargetTableName();
        this.targetSchema = leaf2.getTempTargetCreateStmt();
        String string = leaf.correlatedParentHashableExpression.getAlias() != null && leaf.correlatedParentHashableExpression.getAlias().length() > 0 ? leaf.correlatedParentHashableExpression.getAlias() : leaf.correlatedParentHashableExpression.getExprString();
        string = Leaf.normalizeHashColumnName(string);
        this.setHashDataType(leaf.correlatedParentHashableExpression.getExprDataType());
        HashPartitionMap hashPartitionMap = new HashPartitionMap();
        Collection<DBNode> collection = this.database.getDBNodeList();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(collection.size());
        for (DBNode dBNode : collection) {
            arrayList.add(dBNode.getNodeId());
        }
        hashPartitionMap.generateDistribution(arrayList);
        for (int i = 0; i < leaf2.selectColumns.size(); ++i) {
            if (!string.equals(Leaf.normalizeHashColumnName(leaf2.selectColumns.get((int)i).projectString))) continue;
            this.setDestTypeHash(i + 1, hashPartitionMap);
        }
    }

    protected void addNodeIdToStep(int n, boolean bl) {
        int n2;
        if (this.queryString != null) {
            n2 = this.queryString.indexOf(" FROM ");
            this.queryString = this.queryString.substring(0, n2) + ", XNODEID" + n + this.queryString.substring(n2);
        }
        if (this.targetSchema != null && bl) {
            n2 = this.targetSchema.lastIndexOf(")");
            this.targetSchema = this.targetSchema.substring(0, n2) + ", XNODEID" + n + " INTEGER)";
        } else {
            this.suppressSendingNodeId = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertLeafToStepCorrDownNodeId(Leaf leaf, int n) {
        this.stepNo = 1000 + leaf.getLeafStepNo();
        this.isConsumer = true;
        this.isProducer = true;
        this.queryString = leaf.getCorrelatedSelectString();
        this.targetTable = leaf.correlatedJoinTableName;
        this.targetSchema = leaf.getCreateCorrelatedTableString();
        this.setDestTypeBroadcast();
        this.addNodeIdToStep(n + 1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertLeafToStepCorrelatedNodeIdDown(Leaf leaf, Leaf leaf2, int n) {
        this.stepNo = leaf.getLeafStepNo();
        this.isConsumer = true;
        this.isProducer = true;
        this.targetTable = leaf2.getTargetTableName();
        this.targetSchema = leaf2.getTempTargetCreateStmt();
        this.setDestTypeNodeID();
        this.addNodeIdToStep(n + 1, true);
    }

    public void setIndexColumnString(String string) {
        this.indexColumnString = string;
    }

    public String getCorrelatedIndex() {
        String string = null;
        if (this.indexColumnString != null) {
            string = "CREATE INDEX IDX_TMP_" + this.targetTable + " ON " + IdentifierHandler.quote(this.targetTable) + " (" + this.indexColumnString + ")";
        }
        return string;
    }

    public String getInsertColumnString() {
        return this.insertColumnString;
    }

    public void setIsOuterStep(boolean bl) {
        this.isOuterStep = bl;
    }

    public boolean getIsOuterStep() {
        return this.isOuterStep;
    }

    public String getOuterNodeIdColumn() {
        return this.outerNodeIdColumn;
    }

    public short getSerialColumnPosition() {
        return this.serialColumnPosition;
    }

    public ExpressionType getHashDataType() {
        return this.hashDataType;
    }

    public void setHashDataType(ExpressionType expressionType) {
        this.hashDataType = expressionType;
    }

    public void addCreateTablespace(int n, String string) {
        if (this.createTablespaceMap == null) {
            this.createTablespaceMap = new HashMap<Integer, String>();
        }
        this.createTablespaceMap.put(n, string);
    }

    public boolean usesTablespace() {
        return this.createTablespaceMap != null;
    }

    public String getTablespaceClause(int n) {
        String string = null;
        if (this.createTablespaceMap != null) {
            string = this.createTablespaceMap.get(n);
        }
        return string;
    }

    public void setDestTypeNodeID() {
        this.destType = (short)7;
        this.partitionMap = null;
        this.hashColumnPosition = 0;
        this.destNode = 0;
    }

    public void setDestTypeOne(int n) {
        this.destType = (short)3;
        this.partitionMap = new ReplicatedPartitionMap();
        this.partitionMap.generateDistribution(Collections.singleton(n));
        this.hashColumnPosition = 0;
        this.destNode = n;
    }

    public void setDestTypeCoordinatorFinal() {
        this.destType = (short)6;
        this.destNode = this.database.getCoordinatorNodeID();
    }

    public void setDestTypeCoordinator() {
        this.destType = (short)2;
        this.partitionMap = null;
        this.hashColumnPosition = 0;
        this.destNode = this.database.getCoordinatorNodeID();
    }

    public void setDestTypeBroadcastAndCoordinator() {
        this.setDestTypeBroadcast(true);
    }

    public void setDestTypeBroadcast() {
        this.setDestTypeBroadcast(false);
    }

    private void setDestTypeBroadcast(boolean bl) {
        this.destType = (short)(bl ? 5 : 1);
        this.partitionMap = null;
        this.hashColumnPosition = 0;
        this.destNode = bl ? this.database.getCoordinatorNodeID() : 0;
    }

    public void setDestTypeHash(int n, PartitionMap partitionMap) {
        this.destType = (short)4;
        this.partitionMap = partitionMap;
        this.hashColumnPosition = n;
        this.destNode = 0;
    }

    public void setDestTypeHashList(int[] nArray, PartitionMap partitionMap) {
        this.destType = (short)4;
        this.partitionMap = partitionMap;
        this.hashColumnPosition = -1;
        this.groupHashColumns = nArray;
        this.destNode = 0;
    }

    public int getDestType() {
        return this.destType;
    }

    public int getHashColumnPosition() {
        return this.hashColumnPosition;
    }

    public int getDestNode() {
        return this.destNode;
    }

    public PartitionMap getPartitionMap() {
        return this.partitionMap;
    }

    public void setPartitionMap(PartitionMap partitionMap) {
        this.partitionMap = partitionMap;
    }

    public int[] getGroupHashColumns() {
        return this.groupHashColumns;
    }
}

