/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.protocol;

import com.edb.gridsql.common.ColumnMetaData;
import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.engine.io.CopyResponse;
import com.edb.gridsql.engine.io.ResultSetResponse;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.protocol.PgProtocolHandler;
import com.edb.gridsql.protocol.PgProtocolMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Level;

public class PgProtocolSession
implements Runnable {
    private static final XLogger logger = XLogger.getLogger(PgProtocolSession.class);
    protected static final String CHARSET_NAME = Property.get("xdb.charset", "ISO-8859-1");
    private static final int PROTOCOL_MAJOR = 3;
    private static final int PROTOCOL_MINOR = 0;
    static final int SESSION_STATE_DISCONNECTED = 0;
    static final int SESSION_STATE_HANDSHAKE = 1;
    static final int SESSION_STATE_READY = 2;
    static final int SESSION_STATE_QUERY = 3;
    static final int MAX_ERROR_MSG_SIZE = 511;
    private PgProtocolHandler manager;
    private XDBSessionContext client;
    private SocketChannel channel;
    private int sessionState = 0;
    private boolean error = false;
    private int fetchSize = 0;
    private int backendKey = 0;
    private static final int OID_INVALID = 0;
    private static final int OID_INT2 = 21;
    private static final int OID_INT4 = 23;
    private static final int OID_INT8 = 20;
    private static final int OID_TEXT = 25;
    private static final int OID_NUMERIC = 1700;
    private static final int OID_FLOAT4 = 700;
    private static final int OID_FLOAT8 = 701;
    private static final int OID_BOOL = 16;
    private static final int OID_DATE = 1082;
    private static final int OID_TIME = 1083;
    private static final int OID_TIMETZ = 1266;
    private static final int OID_TIMESTAMP = 1114;
    private static final int OID_TIMESTAMPTZ = 1184;
    private static final int OID_BYTEA = 17;
    private static final int OID_VARCHAR = 1043;
    private static final int OID_OID = 26;
    private static final int OID_BPCHAR = 1042;
    private static final int OID_MONEY = 790;
    private static final int OID_NAME = 19;
    private static final int OID_BIT = 1560;
    private static final int OID_VOID = 2278;

    private PgProtocolMessage readRequest() throws IOException {
        byte[] byArray;
        int n;
        int n2;
        ByteBuffer byteBuffer;
        byte by = 0;
        if (this.sessionState == 0) {
            byteBuffer = ByteBuffer.allocate(4);
            n2 = 0;
            do {
                if ((n = this.channel.read(byteBuffer)) == -1) {
                    throw new IOException("Connection is broken");
                }
                if (n != 0 || n2 != 0) continue;
                return null;
            } while ((n2 += n) < 4);
            byteBuffer.flip();
        } else {
            byteBuffer = ByteBuffer.allocate(5);
            n2 = 0;
            do {
                if ((n = this.channel.read(byteBuffer)) == -1) {
                    throw new IOException("Connection is broken");
                }
                if (n != 0 || n2 != 0) continue;
                return null;
            } while ((n2 += n) < 5);
            byteBuffer.flip();
            by = byteBuffer.get();
        }
        n2 = ((byteBuffer.get() & 0xFF) << 24 | (byteBuffer.get() & 0xFF) << 16 | (byteBuffer.get() & 0xFF) << 8 | byteBuffer.get() & 0xFF) - 4;
        if (n2 > 0) {
            int n3;
            ByteBuffer byteBuffer2;
            try {
                byteBuffer2 = ByteBuffer.allocate(n2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                logger.catching(outOfMemoryError);
                this.channel.close();
                PgProtocolHandler.getProtocolManager().removeClient(this.channel);
                throw new IOException("Probably channel is out of sync and receiving garbage");
            }
            int n4 = 0;
            do {
                if ((n3 = this.channel.read(byteBuffer2)) != -1) continue;
                throw new IOException("Connection is broken");
            } while ((n4 += n3) < n2);
            byArray = byteBuffer2.array();
        } else {
            byArray = new byte[]{};
        }
        return new PgProtocolMessage(by, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeToChannel(PgProtocolMessage pgProtocolMessage, SocketChannel socketChannel) throws IOException {
        logger.log(Level.DEBUG, "Writing response: %0%", new Object[]{pgProtocolMessage.getMessageType()});
        ByteBuffer byteBuffer = pgProtocolMessage.getAsByteBuffer(null);
        SocketChannel socketChannel2 = socketChannel;
        synchronized (socketChannel2) {
            while (true) {
                socketChannel.write(byteBuffer);
                if (byteBuffer.remaining() <= 0) break;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    PgProtocolSession(PgProtocolHandler pgProtocolHandler, SocketChannel socketChannel, XDBSessionContext xDBSessionContext) throws Exception {
        this.manager = pgProtocolHandler;
        this.channel = socketChannel;
        this.client = xDBSessionContext;
        socketChannel.configureBlocking(true);
    }

    void close() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (Throwable throwable) {
                logger.error("Session has not been closed properly: " + this.client.getSessionID());
                logger.catching(throwable);
            }
        }
    }

    XDBSessionContext getClient() {
        return this.client;
    }

    void setState(int n) throws IOException {
        this.sessionState = n;
        if (n == 2) {
            PgProtocolMessage pgProtocolMessage = new PgProtocolMessage(90, new byte[]{this.client.isInTransaction() ? (byte)84 : 73});
            PgProtocolSession.writeToChannel(pgProtocolMessage, this.channel);
        }
    }

    private boolean writeResponse(ExecutionResult executionResult) throws IOException {
        switch (executionResult.getContentType()) {
            case 3: {
                Exception exception = executionResult.getException();
                PgProtocolMessage pgProtocolMessage = new PgProtocolMessage(69, null);
                pgProtocolMessage.putInt8(83);
                pgProtocolMessage.putString("ERROR");
                pgProtocolMessage.putInt8(67);
                pgProtocolMessage.putString("XX000");
                pgProtocolMessage.putInt8(77);
                if (exception.getMessage() != null && exception.getMessage().length() > 511) {
                    pgProtocolMessage.putString(exception.getMessage().substring(0, 508) + "...");
                } else {
                    pgProtocolMessage.putString(exception.getMessage());
                }
                pgProtocolMessage.putInt8(0);
                PgProtocolSession.writeToChannel(pgProtocolMessage, this.channel);
                break;
            }
            case 1: {
                PgProtocolMessage pgProtocolMessage = new PgProtocolMessage(67, new byte[0]);
                if (executionResult.getKind() == 16) {
                    pgProtocolMessage.putString("INSERT 0 " + executionResult.getRowCount());
                } else if (executionResult.getKind() == 17) {
                    pgProtocolMessage.putString("UPDATE " + executionResult.getRowCount());
                } else if (executionResult.getKind() == 15) {
                    pgProtocolMessage.putString("DELETE " + executionResult.getRowCount());
                } else if (executionResult.getKind() == 45 || executionResult.getKind() == 46) {
                    pgProtocolMessage.putString("COPY " + executionResult.getRowCount());
                } else {
                    pgProtocolMessage.putString("OK " + executionResult.getRowCount());
                }
                PgProtocolSession.writeToChannel(pgProtocolMessage, this.channel);
                break;
            }
            case 0: {
                PgProtocolMessage pgProtocolMessage = new PgProtocolMessage(67, new byte[0]);
                if (executionResult.getKind() == 6) {
                    pgProtocolMessage.putString("BEGIN");
                } else if (executionResult.getKind() == 8) {
                    pgProtocolMessage.putString("COMMIT");
                } else if (executionResult.getKind() == 9) {
                    pgProtocolMessage.putString("ROLLBACK");
                } else {
                    pgProtocolMessage.putString("OK");
                }
                PgProtocolSession.writeToChannel(pgProtocolMessage, this.channel);
                break;
            }
            case 4: {
                this.sendSubResults(executionResult);
                break;
            }
            case 2: {
                ResultSet resultSet = executionResult.getResultSet();
                int n = 0;
                try {
                    int n2 = resultSet.getMetaData().getColumnCount();
                    while (resultSet.next()) {
                        PgProtocolMessage pgProtocolMessage = new PgProtocolMessage(68, new byte[0]);
                        pgProtocolMessage.putInt16(n2);
                        for (int i = 1; i <= n2; ++i) {
                            String string = resultSet.getString(i);
                            if (string == null) {
                                pgProtocolMessage.putInt32(-1);
                                continue;
                            }
                            byte[] byArray = string.getBytes(CHARSET_NAME);
                            pgProtocolMessage.putInt32(byArray.length);
                            pgProtocolMessage.putBytes(byArray);
                        }
                        PgProtocolSession.writeToChannel(pgProtocolMessage, this.channel);
                        if (++n != this.fetchSize || this.fetchSize <= 0) continue;
                        PgProtocolSession.writeToChannel(PgProtocolMessage.MSG_PORTAL_SUSPENDED, this.channel);
                        return false;
                    }
                }
                catch (SQLException sQLException) {
                    PgProtocolMessage pgProtocolMessage = new PgProtocolMessage(69, null);
                    pgProtocolMessage.putInt8(83);
                    pgProtocolMessage.putString(sQLException.getMessage());
                    pgProtocolMessage.putInt8(67);
                    pgProtocolMessage.putString("XX000");
                    pgProtocolMessage.putInt8(77);
                    pgProtocolMessage.putString(executionResult.getException().getMessage());
                    pgProtocolMessage.putInt8(0);
                    PgProtocolSession.writeToChannel(pgProtocolMessage, this.channel);
                }
                PgProtocolMessage pgProtocolMessage = new PgProtocolMessage(67, new byte[0]);
                pgProtocolMessage.putString("FETCH " + n);
                PgProtocolSession.writeToChannel(pgProtocolMessage, this.channel);
            }
        }
        return true;
    }

    private void sendSubResults(ExecutionResult executionResult) throws UnsupportedEncodingException, IOException {
        boolean bl = true;
        int n = 0;
        ResultSet resultSet = null;
        for (Map.Entry<Integer, ExecutionResult> entry : executionResult.getSubResults().entrySet()) {
            try {
                Object object;
                Object object2;
                if (bl) {
                    bl = false;
                    if (entry.getValue().getContentType() == 2) {
                        resultSet = entry.getValue().getResultSet();
                    }
                } else if (entry.getValue().getContentType() == 2 ? resultSet == null : resultSet != null) {
                    throw new SQLException("Results on different nodes do not match");
                }
                if (resultSet == null) {
                    PgProtocolMessage pgProtocolMessage = new PgProtocolMessage(68, new byte[0]);
                    pgProtocolMessage.putInt16(2);
                    object2 = "" + entry.getValue().getRowCount();
                    object = ((String)object2).getBytes(CHARSET_NAME);
                    pgProtocolMessage.putInt32(((byte[])object).length);
                    pgProtocolMessage.putBytes((byte[])object);
                    object2 = "" + entry.getKey();
                    object = ((String)object2).getBytes(CHARSET_NAME);
                    pgProtocolMessage.putInt32(((byte[])object).length);
                    pgProtocolMessage.putBytes((byte[])object);
                    PgProtocolSession.writeToChannel(pgProtocolMessage, this.channel);
                    ++n;
                    continue;
                }
                resultSet = entry.getValue().getResultSet();
                int n2 = resultSet.getMetaData().getColumnCount();
                while (resultSet.next()) {
                    Object object3;
                    object2 = new PgProtocolMessage(68, new byte[0]);
                    ((PgProtocolMessage)object2).putInt16(n2 + 1);
                    for (int i = 1; i <= n2; ++i) {
                        object3 = resultSet.getString(i);
                        if (object3 == null) {
                            ((PgProtocolMessage)object2).putInt32(-1);
                            continue;
                        }
                        byte[] byArray = ((String)object3).getBytes(CHARSET_NAME);
                        ((PgProtocolMessage)object2).putInt32(byArray.length);
                        ((PgProtocolMessage)object2).putBytes(byArray);
                    }
                    object = "" + entry.getKey();
                    object3 = object.getBytes(CHARSET_NAME);
                    ((PgProtocolMessage)object2).putInt32(((Object)object3).length);
                    ((PgProtocolMessage)object2).putBytes((byte[])object3);
                    PgProtocolSession.writeToChannel((PgProtocolMessage)object2, this.channel);
                    ++n;
                }
            }
            catch (SQLException sQLException) {
                PgProtocolMessage pgProtocolMessage = new PgProtocolMessage(69, null);
                pgProtocolMessage.putInt8(83);
                pgProtocolMessage.putString(sQLException.getMessage());
                pgProtocolMessage.putInt8(67);
                pgProtocolMessage.putString("XX000");
                pgProtocolMessage.putInt8(77);
                pgProtocolMessage.putString(executionResult.getException().getMessage());
                pgProtocolMessage.putInt8(0);
                PgProtocolSession.writeToChannel(pgProtocolMessage, this.channel);
            }
        }
        PgProtocolMessage pgProtocolMessage = new PgProtocolMessage(67, new byte[0]);
        pgProtocolMessage.putString("FETCH " + n);
        PgProtocolSession.writeToChannel(pgProtocolMessage, this.channel);
    }

    private boolean cancelRequest(int n, int n2) {
        if (this.client.getSessionID() == n && n2 == this.backendKey) {
            this.client.kill();
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 2[TRYBLOCK], 1[TRYBLOCK]], but top level block is 15[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void sendRowDescription(ResultSetResponse resultSetResponse) throws IOException {
        ColumnMetaData[] columnMetaDataArray = null;
        if (resultSetResponse != null) {
            columnMetaDataArray = resultSetResponse.getColumnMetaData();
        }
        if (columnMetaDataArray == null) {
            PgProtocolSession.writeToChannel(PgProtocolMessage.MSG_NO_DATA, this.channel);
        } else {
            PgProtocolMessage pgProtocolMessage = new PgProtocolMessage(84, new byte[0]);
            pgProtocolMessage.putInt16(columnMetaDataArray.length);
            for (ColumnMetaData columnMetaData : columnMetaDataArray) {
                pgProtocolMessage.putString(columnMetaData.alias);
                pgProtocolMessage.putInt32(0);
                pgProtocolMessage.putInt16(0);
                pgProtocolMessage.putInt32(PgProtocolSession.getOID(columnMetaData.javaSqlType));
                pgProtocolMessage.putInt16(columnMetaData.maxLength);
                pgProtocolMessage.putInt32(0);
                pgProtocolMessage.putInt16(0);
            }
            PgProtocolSession.writeToChannel(pgProtocolMessage, this.channel);
        }
    }

    private void sendParameterDescription(int[] nArray) throws IOException {
        PgProtocolMessage pgProtocolMessage = new PgProtocolMessage(116, new byte[0]);
        pgProtocolMessage.putInt16(nArray.length);
        for (int n : nArray) {
            pgProtocolMessage.putInt32(PgProtocolSession.getOID(n));
        }
        PgProtocolSession.writeToChannel(pgProtocolMessage, this.channel);
    }

    private void startCopyInProcess(CopyResponse copyResponse) throws IOException {
        PgProtocolMessage pgProtocolMessage = new PgProtocolMessage(71, new byte[0]);
        pgProtocolMessage.putInt8(0);
        int n = copyResponse.getColumnMetaData().length;
        pgProtocolMessage.putInt16(n);
        for (int i = 0; i < n; ++i) {
            pgProtocolMessage.putInt16(0);
        }
        PgProtocolSession.writeToChannel(pgProtocolMessage, this.channel);
        copyResponse.setInputStream(new CopyInStream());
    }

    private void startCopyOutProcess(CopyResponse copyResponse) throws IOException {
        PgProtocolMessage pgProtocolMessage = new PgProtocolMessage(72, new byte[0]);
        pgProtocolMessage.putInt8(0);
        int n = copyResponse.getColumnMetaData().length;
        pgProtocolMessage.putInt16(n);
        for (int i = 0; i < n; ++i) {
            pgProtocolMessage.putInt16(0);
        }
        PgProtocolSession.writeToChannel(pgProtocolMessage, this.channel);
        copyResponse.setOutputStream(new CopyOutStream());
    }

    private String[] decodeParameters(byte[][] byArray, int[] nArray) {
        int[] nArray2;
        String[] stringArray = new String[byArray.length];
        if (nArray == null || nArray.length == 0) {
            nArray2 = new int[byArray.length];
            Arrays.fill(nArray2, 0);
        } else if (nArray.length == 1) {
            nArray2 = new int[byArray.length];
            Arrays.fill(nArray2, nArray[0]);
        } else {
            nArray2 = nArray;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (nArray2[i] != 0) {
                throw new XDBServerException("Only text format is supported");
            }
            stringArray[i] = PgProtocolMessage.decodeString(byArray[i]);
        }
        return stringArray;
    }

    private String[] splitSimpleQuery(String string) {
        if (Props.XDB_ALLOW_MULTISTATEMENT_QUERY) {
            String[] stringArray;
            String string2;
            LinkedList<String> linkedList = new LinkedList<String>();
            boolean bl = false;
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\'') {
                    bl = !bl;
                    continue;
                }
                if (c != ';' || bl) continue;
                linkedList.add(string.substring(n, i + 1));
                n = i + 1;
            }
            if (n < string.length() && (string2 = string.substring(n).trim()).length() > 0) {
                linkedList.add(string2);
            }
            if (linkedList.size() == 0) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "";
            } else {
                stringArray = linkedList.toArray(new String[linkedList.size()]);
            }
            return stringArray;
        }
        return new String[]{string};
    }

    private static int getOID(int n) {
        switch (n) {
            case 2003: {
                return 0;
            }
            case -5: {
                return 20;
            }
            case -2: {
                return 17;
            }
            case -7: {
                return 1560;
            }
            case 2004: {
                return 26;
            }
            case 16: {
                return 16;
            }
            case 1: {
                return 1042;
            }
            case 2005: {
                return 25;
            }
            case 70: {
                return 0;
            }
            case 91: {
                return 1082;
            }
            case 3: {
                return 790;
            }
            case 2001: {
                return 0;
            }
            case 8: {
                return 701;
            }
            case 6: {
                return 700;
            }
            case 4: {
                return 23;
            }
            case 2000: {
                return 17;
            }
            case -4: {
                return 26;
            }
            case -1: {
                return 25;
            }
            case 0: {
                return 26;
            }
            case 2: {
                return 1700;
            }
            case 1111: {
                return 0;
            }
            case 7: {
                return 701;
            }
            case 2006: {
                return 19;
            }
            case 5: {
                return 21;
            }
            case 2002: {
                return 0;
            }
            case 92: {
                return 1083;
            }
            case 93: {
                return 1184;
            }
            case -6: {
                return 21;
            }
            case -3: {
                return 17;
            }
            case 12: {
                return 1043;
            }
        }
        return 0;
    }

    private static int getJavaType(int n) {
        switch (n) {
            case 1560: {
                return -7;
            }
            case 16: {
                return 16;
            }
            case 1042: {
                return 1;
            }
            case 17: {
                return -2;
            }
            case 1082: {
                return 91;
            }
            case 700: {
                return 6;
            }
            case 701: {
                return 8;
            }
            case 21: {
                return 5;
            }
            case 23: {
                return 4;
            }
            case 20: {
                return -5;
            }
            case 0: {
                return 1111;
            }
            case 790: {
                return 3;
            }
            case 19: {
                return 2006;
            }
            case 1700: {
                return 2;
            }
            case 26: {
                return 2006;
            }
            case 25: {
                return -1;
            }
            case 1083: {
                return 92;
            }
            case 1114: {
                return 93;
            }
            case 1184: {
                return 93;
            }
            case 1266: {
                return 92;
            }
            case 1043: {
                return 12;
            }
            case 2278: {
                return 0;
            }
        }
        return 1111;
    }

    private class CopyOutStream
    extends OutputStream {
        CopyOutStream() {
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            PgProtocolMessage pgProtocolMessage = new PgProtocolMessage(100, new byte[0]);
            pgProtocolMessage.putBytes(byArray, n, n2);
            PgProtocolSession.writeToChannel(pgProtocolMessage, PgProtocolSession.this.channel);
        }

        public void write(int n) throws IOException {
            throw new IOException("Only single row can be output");
        }

        public void close() throws IOException {
            PgProtocolSession.writeToChannel(PgProtocolMessage.MSG_COPY_DONE, PgProtocolSession.this.channel);
        }
    }

    private class CopyInStream
    extends InputStream {
        ByteBuffer bbuf;
        boolean copydone = false;

        CopyInStream() {
        }

        private boolean fill() throws IOException {
            block5: while (!this.copydone) {
                PgProtocolMessage pgProtocolMessage = PgProtocolSession.this.readRequest();
                switch (pgProtocolMessage.getMessageType()) {
                    case 100: {
                        this.bbuf = ByteBuffer.wrap(pgProtocolMessage.getBytes(pgProtocolMessage.getLength()));
                        return true;
                    }
                    case 99: {
                        this.copydone = true;
                        continue block5;
                    }
                    case 102: {
                        throw new IOException("Copy is failed");
                    }
                }
                throw new IOException("Copy is failed");
            }
            return false;
        }

        public int read() throws IOException {
            if (this.bbuf != null && this.bbuf.hasRemaining() || this.fill()) {
                return this.bbuf.get() & 0xFF;
            }
            return -1;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (n2 > 0 && (this.bbuf != null && this.bbuf.hasRemaining() || this.fill())) {
                int n4 = Math.min(n2, this.bbuf.remaining());
                this.bbuf.get(byArray, n, n4);
                n3 += n4;
                n += n4;
                n2 -= n4;
            }
            return n3 == 0 && this.copydone ? -1 : n3;
        }
    }
}

