/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.util;

import com.edb.gridsql.util.ParseArgs;
import com.edb.gridsql.util.Util;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;

public class XdbDbStop {
    private static void terminate(String string) {
        System.err.println(string);
        System.err.println("Parameters: <connect> -d <database>\n\twhere <connect> is -j jdbc:edb://<host>:<port>/<database>?user=<username>&password=<password>\n\tor [-h <host>] [-s <port>] -d <database> -u <user> [-p <password>]\n\t-h <host> : Host name or IP address where XDBServer is running. Default is localhost\n\t-s <port> : XDBServer's port. Default is 6453\n\t-d <database> : Name of databases to stop.\n\t-u <user>, -p <password> : Login to the database.");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Connection connection = null;
        Statement statement = null;
        try {
            Map<String, List<String>> map = ParseArgs.parse(stringArray, "hsdup");
            String string = ParseArgs.getStrArg(map, "-d");
            connection = Util.connect(map, true);
            statement = connection.createStatement();
            String string2 = "STOP DATABASE " + string;
            statement.execute(string2);
            System.out.println("Database(s) " + string + " stopped.");
        }
        catch (Exception exception) {
            XdbDbStop.terminate(exception.getMessage());
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        System.exit(0);
    }
}

