/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.wrapper;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public class Driver
implements java.sql.Driver {
    private static final String prefix = "jdbc:wrapper";
    private static final String[] versions = new String[]{"4", "3", "2"};
    static /* synthetic */ Class class$java$sql$Connection;

    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(prefix);
    }

    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            throw new SQLException("Wrapper driver does not accept this URL:" + url);
        }
        int cut = url.indexOf(58, prefix.length());
        if (cut == -1) {
            throw new SQLException("Format: jdbc:wrapper:<your driver connection string>");
        }
        String driverConnURL = url.substring(cut);
        if (!driverConnURL.startsWith("jdbc")) {
            driverConnURL = "jdbc" + driverConnURL;
        }
        Connection wrappedConnection = DriverManager.getConnection(driverConnURL);
        for (int i = 0; i < versions.length; ++i) {
            try {
                return this.startWrapper(versions[i], wrappedConnection);
            }
            catch (SecurityException e) {
                continue;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            catch (InstantiationException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        throw new SQLException("No suitable Connection version found");
    }

    private Connection startWrapper(String version, Connection connection) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> connectionClass = Class.forName("org.postgresql.wrapper.jdbc" + version + ".WrapperConnection");
        Constructor<?> constr = connectionClass.getConstructor(class$java$sql$Connection == null ? (class$java$sql$Connection = Driver.class$("java.sql.Connection")) : class$java$sql$Connection);
        return (Connection)constr.newInstance(connection);
    }

    public int getMajorVersion() {
        return 0;
    }

    public int getMinorVersion() {
        return 1;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[]{new DriverPropertyInfo("", "")};
    }

    public boolean jdbcCompliant() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

