DROP table aspnet_users, aspnet_applications CASCADE

CREATE TABLE aspnet_applications
(
  applicationname varchar(256) NOT NULL,
  loweredapplicationname varchar(256) NOT NULL,
  applicationid varchar(36) NOT NULL,
  description varchar(256),
  CONSTRAINT aspnet_applications_pkey PRIMARY KEY (applicationname),
  CONSTRAINT aspnet_applications_applicationid_key UNIQUE (applicationid)
) 
WITH OIDS;
ALTER TABLE aspnet_applications OWNER TO postgres;


CREATE INDEX aspnet_Applications_Index ON aspnet_Applications(LoweredApplicationName);


CREATE TABLE aspnet_users
(
  applicationid varchar(36),
  userid char(36) NOT NULL,
  username varchar(256) NOT NULL,
  loweredusername varchar(256) NOT NULL,
  mobilealias varchar(16),
  isanonymous bool NOT NULL DEFAULT false,
  lastactivitydate timestamp NOT NULL,
  lastupdateddate timestamp,
  CONSTRAINT aspnet_users_pkey PRIMARY KEY (userid),
  CONSTRAINT aspnet_users_applicationid_fkey FOREIGN KEY (applicationid) REFERENCES aspnet_applications (applicationid) ON UPDATE NO ACTION ON DELETE NO ACTION
) 
WITH OIDS;
ALTER TABLE aspnet_users OWNER TO postgres;


   CREATE INDEX aspnet_Users_Index ON aspnet_Users(ApplicationId, LoweredUserName);
   CREATE INDEX aspnet_Users_Index2 ON aspnet_Users(ApplicationId, LastActivityDate);

CREATE VIEW vw_aspnet_Users
  AS SELECT aspnet_Users.ApplicationId, aspnet_Users.UserId, aspnet_Users.UserName, aspnet_Users.LoweredUserName, aspnet_Users.MobileAlias, aspnet_Users.IsAnonymous, aspnet_Users.LastActivityDate
  FROM aspnet_Users; 

CREATE TABLE aspnet_profile
(
  userid char(36) NOT NULL,
  propertynames text,
  propertyvaluesstring text,
  propertyvaluesbinary text,
  lastupdateddate timestamp,
  birth_month int2,
  birth_day int2,
  birth_year int2,
  gender bool,
  CONSTRAINT aspnet_profile_pkey PRIMARY KEY (userid)
) 
WITH OIDS;
ALTER TABLE aspnet_profile OWNER TO postgres;

