; -------------------------------------------------------------------------------------------------------------------------------
;
; Author: Mark Dootson
; eMail: mark.dootson@znix.com
;
; This InnoSetup script installs the ODBC and OleDb clients for PostgreSQL.
;
; MDAC and DCOM components must be installed independently.
;
; The scripts pgW32cli-full.iss and pgW32cli-web.iss provide options for installing
; MDAC adn DCOM
;
; -------------------------------------------------------------------------------------------------------------------------------
; This script was created using ISTool for Inno Setup
; http://www.innosetup.com
; http://www.istool.org
; ----------------------------

[Setup]
OutputDir=..\setup\pgw32cli
OutputBaseFilename=pgw32cli-min-1_0
MinVersion=4.0,4.0
AdminPrivilegesRequired=true
CreateAppDir=true
DisableStartupPrompt=true
Uninstallable=true

AppName=PostgreSQL Win32 ODBC and OLEDB Clients
AppVerName=PG Clients 1.0
AppPublisher=Mark Dootson
AppPublisherURL=http://pgfoundry.org/projects/pgw32cli/
AppSupportURL=http://pgfoundry.org/projects/pgw32cli/
AppUpdatesURL=http://pgfoundry.org/projects/pgw32cli/
DefaultDirName={pf}\PgW32cli
;DefaultGroupName=PostgreSQL Win32 Clients
LicenseFile=..\pgw32cli\fulllicence.txt
Compression=lzma
SolidCompression=true
VersionInfoVersion=1.0
VersionInfoCompany=Mark Dootson
VersionInfoDescription=PG Win32 CLients 1.0
VersionInfoTextVersion=1.0
AppCopyright=Mark Dootson 2005
UserInfoPage=false
DefaultUserInfoSerial=1234567890
ShowLanguageDialog=no
ShowTasksTreeLines=true
AppID={{26065794-8C0A-47DE-9AC9-8A224059D44E}
UsePreviousUserInfo=false
UsePreviousAppDir=false
DisableProgramGroupPage=true
UsePreviousGroup=false
FlatComponentsList=false
UsePreviousSetupType=false
UsePreviousTasks=false
LanguageDetectionMethod=none
AppVersion=1.0
UninstallDisplayName=PostgreSQL Win32 Clients
InfoAfterFile=..\pgw32cli\after.txt
InfoBeforeFile=..\pgw32cli\Before.rtf
WizardImageFile=..\pgw32cli\largsetup.bmp
WizardSmallImageFile=..\pgw32cli\smallsetup.bmp

[Tasks]

[Files]

Source: ..\Redist\PGCONNECT\libintl-2.dll; DestDir: {app}\libs; Flags: sharedfile uninsneveruninstall replacesameversion; Components: OLEDB
Source: ..\Redist\PGCONNECT\libiconv-2.dll; DestDir: {app}\libs; Flags: sharedfile uninsneveruninstall replacesameversion; Components: OLEDB
Source: ..\Redist\PGCONNECT\libpq.dll; DestDir: {app}\libs; Flags: sharedfile uninsneveruninstall replacesameversion; Components: OLEDB
Source: ..\Redist\PGCONNECT\psqlodbc.dll; DestDir: {app}\libs; Flags: sharedfile uninsneveruninstall replacesameversion; Components: ODBC
Source: ..\Redist\PGCONNECT\PgOleDb.dll; DestDir: {app}\libs; Flags: regserver sharedfile uninsneveruninstall replacesameversion; Components: OLEDB
Source: ..\Redist\OpenSSL\libeay32.dll; DestDir: {app}\libs; Flags: sharedfile uninsneveruninstall replacesameversion; Components: OLEDB
Source: ..\Redist\OpenSSL\ssleay32.dll; DestDir: {app}\libs; Flags: sharedfile uninsneveruninstall replacesameversion; Components: OLEDB

[Registry]

; PostgreSQL ODBC Settings
Root: HKLM; Subkey: SOFTWARE\ODBC\ODBCINST.INI\ODBC Drivers; ValueType: string; ValueName: PostgreSQL; ValueData: Installed; Components: ODBC
Root: HKLM; Subkey: SOFTWARE\ODBC\ODBCINST.INI\PostgreSQL; ValueType: string; ValueName: APILevel; ValueData: 1; Components: ODBC
Root: HKLM; Subkey: SOFTWARE\ODBC\ODBCINST.INI\PostgreSQL; ValueType: string; ValueName: ConnectFunctions; ValueData: YYN; Components: ODBC
Root: HKLM; Subkey: SOFTWARE\ODBC\ODBCINST.INI\PostgreSQL; ValueType: string; ValueName: Driver; ValueData: {app}\libs\psqlodbc.dll; Components: ODBC
Root: HKLM; Subkey: SOFTWARE\ODBC\ODBCINST.INI\PostgreSQL; ValueType: string; ValueName: DriverODBCVer; ValueData: 03.00; Components: ODBC
Root: HKLM; Subkey: SOFTWARE\ODBC\ODBCINST.INI\PostgreSQL; ValueType: string; ValueName: FileUsage; ValueData: 0; Components: ODBC
Root: HKLM; Subkey: SOFTWARE\ODBC\ODBCINST.INI\PostgreSQL; ValueType: string; ValueName: SQLLevel; ValueData: 1; Components: ODBC
Root: HKLM; Subkey: SOFTWARE\ODBC\ODBCINST.INI\PostgreSQL; ValueType: string; ValueName: Setup; ValueData: {app}\libs\psqlodbc.dll; Components: ODBC
Root: HKLM; Subkey: SOFTWARE\ODBC\ODBCINST.INI\PostgreSQL; ValueType: dword; ValueName: UsageCount; ValueData: 1; Components: ODBC

[Run]

[Dirs]
Name: {app}\libs

[Components]
Name: OLEDB; Description: OLEDB Driver for PostgreSQL; Types: full
Name: ODBC; Description: ODBC Driver for PostgreSQL; Types: full
