/* $Id: tupledesc.h,v 1.10 2006/02/27 04:41:44 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/src/tupd.h,v 1.1.1.1 2004/12/16 00:32:18 flaw
 * imp/src/tupd.h,v 1.1.1.1 2004/10/04 01:52:56 flaw
 * if/src/tupd.h,v 1.22 2004/09/28 15:43:58 flaw
 *//*
 * Python Postgres Tuple Descriptor declaration
 */
#ifndef PyPg_tupledesc_H
#define PyPg_tupledesc_H 0
#ifdef __cplusplus
extern "C" {
#endif

#define PyPgTupleDesc_HEAD \
	PyObject_HEAD				\
	TupleDesc td_desc;

typedef struct PyPgTupleDesc {
	PyPgTupleDesc_HEAD
} * PyPgTupleDesc;

#ifndef PyPg_ci_H
extern PyTypeObject PyPgTupleDesc_Type;
extern PyObj EmptyPyPgTupleDesc;

TupleDesc PyPg_CreateTupleDescCopy(TupleDesc);
TupleDesc PyPg_CreateTupleDescCopyConstr(TupleDesc);
int EmptyPyPgTupleDesc_Initialize(void);

PyObj PyPgTupleDesc_NEW(PyTypeObject *subtype, TupleDesc tupd);

TupleDesc TupleDesc_FromNamesAndOids(unsigned int, const char **, Oid *);
AttrNumber AttrNumber_FromTupleDescAndNameStr(TupleDesc, char *);
int AttrOffset_FromTupleDescAndPyObject(TupleDesc, PyObj);
PyObj TupleDesc_Keys(TupleDesc);
bool TupleDesc_HasKey(TupleDesc, const char *);
HeapTuple PyPgTupleDesc_AttTuple(PyObj, long);
int PyPgTupleDesc_AttOffset(PyObj, PyObj);
PyObj PyPgTupleDesc_FromRelationId(Oid);
PyObj PyPgTupleDesc_FetchPyPgType(PyObj tdo, unsigned int item);
#else /* PyPg_ci_H */
#	define PyPgTupleDesc_Type (*(PyPgCI._PyPgTupleDesc_Type))
#	define EmtpyPyPgTupleDesc (PyPgCI._EmptyPyPgTupleDesc)
#	define PyPgTupleDesc_NEW(SUBTYPE, TUPD) \
		((PyPgCI._PyPgTupleDesc_NEW(SUBTYPE, TUPD))
#endif

#define PyPgTupleDesc_New(TD) \
	((PyObj) PyPgTupleDesc_NEW(&PyPgTupleDesc_Type, TD))

#define PyPgTupleDesc(SELF) ((PyPgTupleDesc) SELF)

#define PyPgTupleDesc_Check(SELF) \
	(PyObject_TypeCheck(SELF, &PyPgTupleDesc_Type))
#define PyPgTupleDesc_CheckExact(SELF) \
	(SELF->ob_type == &PyPgTupleDesc_Type)

#define PyPgTupleDesc_FetchTupleDesc(SELF) \
	(PyPgTupleDesc(SELF)->td_desc)

#define PyPgTupleDesc_FixTupleDesc(SELF, TD) \
	(PyPgTupleDesc(SELF)->td_desc = TD)

#define PyPgTupleDesc_FetchAttributeTypeOid(SELF, AN) \
	(PyPgTupleDesc_FetchTupleDesc(SELF)->attrs[AN]->atttypid)
#define PyPgTupleDesc_FetchAttributeType(SELF, AN) \
	PyPgType_FromOid(PyPgTupleDesc_FetchAttributeTypeOid(SELF, AN))

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_tupledesc_H */
/*
 * vim: ts=3:sw=3:noet:
 */
