/* $Id: function.h,v 1.6 2006/02/15 06:30:07 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * Postgres function calling and lookup interface
 */
#ifndef PyPg_function_H
#define PyPg_function_H 0
#ifdef __cplusplus
extern "C" {
#endif

typedef struct PyPgFunction {
	PyObject_HEAD
	Oid					fn_procid;			/* pg_proc entry Oid */
	PGFunction 			fn_pointer;			/* PGFunction */
	bool					fn_retset;			/* Set returning function */
	PyObj 				fn_code;				/* PyCodeObject, Python */
	PyObj					fn_input;			/* PyPgTupleDesc */
	PyObj					fn_output;			/* PyPgType or PyPgTupleDesc (OUT) */
} * PyPgFunction;

extern PyTypeObject PyPgFunction_Type;

#ifndef PyPg_ci_H
int PyPgFunction_Initialize(void);
PyObj PyPgFunction_FromOid(Oid);
int PyPgFunction_DelCached(Oid);

TupleDesc TupleDesc_From_proargtypes_proargnames(int2, Datum, Datum);
TupleDesc TupleDesc_From_pg_proc_arginfo(HeapTuple);
#else
#	define PyPgFunction_Type (*(PyPgCI._PyPgFunction_Type))
#	define PyPgFunction_FromOid(a) \
		(PyPgCI._PyPgFunction_FromOid(a))
#	define PyPgFunction_DelCached(a) \
		(PyPgCI._PyPgFunction_DelCached(a))
#endif

#define PyPgFunction_NEW()  \
	((PyObj) PyPgFunction_Type.tp_alloc(&PyPgFunction_Type, 0))

#define PyPgFunction_Check(SELF) (PyObject_TypeCheck((SELF), &PyPgFunction_Type))
#define PyPgFunction_CheckExact(SELF) ((SELF)->ob_type == &PyPgFunction_Type)

#define PyPgFunction(SELF)	((PyPgFunction) SELF)

#define PyPgFunction_FetchFunction(SELF) \
	(PyPgFunction(SELF)->fn_pointer)
#define PyPgFunction_FetchPGFunction(SELF) \
	(PyPgFunction(SELF)->fn_pointer)
#define PyPgFunction_FetchProcId(SELF) \
	(PyPgFunction(SELF)->fn_procid)
#define PyPgFunction_FetchReturnsSet(SELF) \
	(PyPgFunction(SELF)->fn_retset)
#define PyPgFunction_IsSRF(SELF) \
	PyPgFunction_FetchReturnsSet(SELF)
#define PyPgFunction_FetchCode(SELF) \
	(PyPgFunction(SELF)->fn_code)
#define PyPgFunction_FetchInput(SELF) \
	(PyPgFunction(SELF)->fn_input)
#define PyPgFunction_FetchOutput(SELF) \
	(PyPgFunction(SELF)->fn_output)

#define PyPgFunction_FixPGFunction(SELF, PGF) \
	(PyPgFunction(SELF)->fn_pointer = PGF)
#define PyPgFunction_FixProcId(SELF, OB) \
	(PyPgFunction(SELF)->fn_procid = OB)
#define PyPgFunction_FixReturnsSet(SELF, OB) \
	(PyPgFunction(SELF)->fn_retset = OB)
#define PyPgFunction_FixCode(SELF, OB) \
	(PyPgFunction(SELF)->fn_code = OB)
#define PyPgFunction_FixInput(SELF, OB) \
	(PyPgFunction(SELF)->fn_input = OB)
#define PyPgFunction_FixOutput(SELF, OB) \
	(PyPgFunction(SELF)->fn_output = OB)

#define PyPgFunction_IsPython(SELF) \
	(PyPgFunction_FetchCode(SELF) != Py_None)

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_function_H */
/*
 * vim: ts=3:sw=3:noet:
 */
