--
-- PGSessionVars
-- 
-- Created for PostgreSQL 8.3
--

DROP TABLE IF EXISTS sessionvariable;
CREATE TABLE sessionvariable (
    session_id int,
    name varchar(32),
    value varchar(256)
);
COMMENT ON TABLE sessionvariable IS 'Contains session local variable settings.';

DROP FUNCTION IF EXISTS set_session_var(varname varchar, newvalue varchar);
CREATE OR REPLACE FUNCTION set_session_var(varname varchar, newvalue varchar) RETURNS VOID AS
$BODY$
BEGIN
   UPDATE sessionvariable SET value = newvalue WHERE name = varname AND session_id = pg_backend_pid();
   IF NOT FOUND THEN
       INSERT INTO sessionvariable(session_id, name, value) VALUES (pg_backend_pid(),varname,newvalue);
   END IF;
END
$BODY$   
LANGUAGE 'plpgsql' VOLATILE;
COMMENT ON FUNCTION set_session_var(varname varchar, newvalue varchar) IS 'Sets a session local variable.'; 

DROP FUNCTION IF EXISTS remove_session_var(varname varchar);
CREATE OR REPLACE FUNCTION remove_session_var(varname varchar) RETURNS VOID AS
$BODY$
   DELETE FROM sessionvariable WHERE session_id = pg_backend_pid() AND name = $1;
$BODY$   
LANGUAGE 'sql' VOLATILE;
COMMENT ON FUNCTION remove_session_var(varname varchar) IS 'Removes a session local variable.';  

DROP FUNCTION IF EXISTS get_session_var(varname varchar);
CREATE OR REPLACE FUNCTION get_session_var(varname varchar) RETURNS varchar AS
$BODY$
   SELECT value FROM sessionvariable WHERE session_id = pg_backend_pid() AND name = $1;
$BODY$   
LANGUAGE 'sql' STABLE STRICT;
COMMENT ON FUNCTION get_session_var(varname varchar) IS 'Retrieves the value of a session local variable. Returns null, if the  variable does not exist.';

DROP FUNCTION IF EXISTS clear_session_vars();
CREATE OR REPLACE FUNCTION clear_session_vars() RETURNS VOID AS
$BODY$
   DELETE FROM sessionvariable WHERE session_id = pg_backend_pid();
$BODY$   
LANGUAGE 'sql' VOLATILE;
COMMENT ON FUNCTION clear_session_vars() IS 'Clears all variables of this session.';

DROP FUNCTION IF EXISTS cleanup_session_vars();
CREATE OR REPLACE FUNCTION cleanup_session_vars() RETURNS VOID AS
$BODY$
   DELETE FROM sessionvariable WHERE session_id IN 
     (select pg_stat_get_backend_pid(pg_stat_get_backend_idset) FROM pg_stat_get_backend_idset());
$BODY$   
LANGUAGE 'sql' VOLATILE;
COMMENT ON FUNCTION cleanup_session_vars() IS 'Removes all variables left from previous sessions.';
