DROP TYPE PERIOD CASCADE;
DROP FUNCTION IF EXISTS period_granularity();

--Date functions
DROP FUNCTION IF EXISTS date_add(date, numeric) CASCADE;
DROP FUNCTION IF EXISTS date_subtract(date, numeric) CASCADE;
DROP FUNCTION IF EXISTS date_granularity();

-- Timestamp functions
DROP FUNCTION IF EXISTS timestamp_add(timestamp, numeric) CASCADE;
DROP FUNCTION IF EXISTS timestamp_add(timestamptz, numeric) CASCADE;
DROP FUNCTION IF EXISTS timestamp_subtract(timestamp, numeric) CASCADE;
DROP FUNCTION IF EXISTS timestamp_subtract(timestamptz, numeric) CASCADE;
DROP FUNCTION IF EXISTS prior(timestamp);
DROP FUNCTION IF EXISTS prior(timestampTz);
DROP FUNCTION IF EXISTS next(timestamp);
DROP FUNCTION IF EXISTS next(timestampTz);
DROP FUNCTION IF EXISTS timestamp_granularity();

-- time functions
DROP FUNCTION IF EXISTS time_add(time, numeric) CASCADE;
DROP FUNCTION IF EXISTS time_add(timetz, numeric) CASCADE;
DROP FUNCTION IF EXISTS time_subtract(time, numeric) CASCADE;
DROP FUNCTION IF EXISTS time_subtract(timetz, numeric) CASCADE;

-- interval functions
DROP FUNCTION IF EXISTS seconds(interval);
DROP FUNCTION IF EXISTS to_char(interval);
DROP FUNCTION IF EXISTS duration(interval, varchar);
DROP FUNCTION IF EXISTS to_interval(numeric);

-- misc functions
DROP FUNCTION IF EXISTS week_of_month(date);
DROP FUNCTION IF EXISTS week_of_month(date, integer);
DROP FUNCTION IF EXISTS last_day(date);
DROP FUNCTION IF EXISTS day_of_cycle(date, date, integer);

